/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.config.CompassConfig;
import dlovin.advancedcompass.gui.renderers.AntiqueAtlasWPCollector;
import dlovin.advancedcompass.gui.renderers.CompassRenderer;
import dlovin.advancedcompass.gui.renderers.EntitiesRenderer;
import dlovin.advancedcompass.gui.renderers.IRenderer;
import dlovin.advancedcompass.gui.renderers.JourneyMapWPCollector;
import dlovin.advancedcompass.gui.renderers.ModWaypointCollector;
import dlovin.advancedcompass.gui.renderers.VoxemapWPCollector;
import dlovin.advancedcompass.gui.renderers.WaypointRenderer;
import dlovin.advancedcompass.gui.renderers.XaeroMinimapWPCollector;
import dlovin.advancedcompass.utils.InventoryUtils;
import dlovin.advancedcompass.utils.enums.CoordinatesMode;
import dlovin.advancedcompass.utils.enums.ShowMode;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_243;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class CompassGui {
    private final class_2960 COMPASS_TOP = new class_2960("advancedcompass", "textures/gui/compass_top.png");
    private final class_2960 COMPASS_MID = new class_2960("advancedcompass", "textures/gui/compass_mid.png");
    private final class_2960 COMPASS_BOT = new class_2960("advancedcompass", "textures/gui/compass_bot.png");
    protected final class_2960 CARDINAL_P = new class_2960("advancedcompass", "textures/gui/cardinal_point.png");
    private class_310 mc = class_310.method_1551();
    public CompassConfig settings;
    private CompassRenderer compassRenderer;
    private EntitiesRenderer entitiesRenderer;
    private WaypointRenderer waypointRenderer;
    private List<ModWaypointCollector> modCollectors;
    private Collection<IRenderer> renderers = new ArrayList<IRenderer>();
    private float coordinatesScale;
    private int coordinatesOffset;
    private int compassOffset;
    private int coordinatesHeight;
    public int bossOffset;

    public CompassGui(CompassConfig config) {
        this.settings = config;
        this.coordinatesScale = (float)this.settings.getCoordinatesScale() / 100.0f;
        this.setCoordinatesMode(AdvancedCompass.getConfig().getCoordinatesMode());
        this.compassRenderer = new CompassRenderer(this.mc, this.mc.field_1772, this.settings);
        this.renderers.add(this.compassRenderer);
        this.entitiesRenderer = new EntitiesRenderer(this.mc, this.mc.field_1772, this.settings);
        this.renderers.add(this.entitiesRenderer);
        this.waypointRenderer = new WaypointRenderer(class_310.method_1551(), this.mc.field_1772, this.settings, this);
        this.renderers.add(this.waypointRenderer);
        this.modCollectors = new ArrayList<ModWaypointCollector>();
        if (FabricLoader.getInstance().isModLoaded("xaerominimap")) {
            this.modCollectors.add(new XaeroMinimapWPCollector(this.mc, this.settings));
        }
        if (FabricLoader.getInstance().isModLoaded("journeymap")) {
            this.modCollectors.add(new JourneyMapWPCollector(this.mc, this.settings));
        }
        if (FabricLoader.getInstance().isModLoaded("voxelmap")) {
            this.modCollectors.add(new VoxemapWPCollector(this.mc, this.settings));
        }
    }

    public List<ModWaypointCollector> getModCollectors() {
        return this.modCollectors;
    }

    public boolean hasMod() {
        return this.modCollectors.size() > 0;
    }

    public boolean hasAtlas() {
        for (ModWaypointCollector r : this.modCollectors) {
            if (!(r instanceof AntiqueAtlasWPCollector)) continue;
            return true;
        }
        return false;
    }

    public void setIconScale(int scale) {
        this.settings.setIconScale(scale);
        this.recalculateCoords();
        this.renderers.forEach(r -> r.setIconScale(scale));
    }

    public void setCoordinatesMode(CoordinatesMode mode) {
        this.settings.setCoordinatesMode(mode);
        this.recalculateCoords();
    }

    public void setCoordinatesScale(int scale) {
        this.settings.setCoordinatesScale(scale);
        this.coordinatesScale = (float)scale / 100.0f;
        this.recalculateCoords();
    }

    public void setCompassHeight(int height) {
        this.settings.setCompassHeight(height);
        this.recalculateCoords();
    }

    private void recalculateCoords() {
        if (this.settings.getCoordinatesMode().equals(CoordinatesMode.ABOVE)) {
            this.coordinatesOffset = 0;
            this.compassOffset = (int)(10.0f * this.coordinatesScale);
            int iconheight = (int)((float)(9 * this.settings.getIconScale()) / 100.0f);
            if (this.settings.getCompassHeight() / 2 < iconheight) {
                this.compassOffset += iconheight - this.settings.getCompassHeight() / 2;
            }
            iconheight = (int)((float)(22 * this.settings.getIconScale()) / 100.0f);
            this.bossOffset = this.compassOffset + this.settings.getCompassHeight();
            if (this.bossOffset < this.compassOffset + this.settings.getCompassHeight() / 2 + iconheight / 2) {
                this.bossOffset = this.compassOffset + this.settings.getCompassHeight() / 2 + iconheight / 2;
            }
            this.coordinatesHeight = 0;
        } else if (this.settings.getCoordinatesMode().equals(CoordinatesMode.BELOW)) {
            int iconheight = (int)((float)(10 * this.settings.getIconScale()) / 100.0f);
            this.compassOffset = this.settings.getCompassHeight() / 2 < iconheight ? iconheight - this.settings.getCompassHeight() / 2 : 0;
            iconheight = (int)(22.0f * ((float)this.settings.getIconScale() / 100.0f));
            this.coordinatesOffset = this.settings.getCompassHeight() + 2;
            if (this.coordinatesOffset < this.compassOffset + this.settings.getCompassHeight() / 2 + iconheight / 2) {
                this.coordinatesOffset = this.compassOffset + this.settings.getCompassHeight() / 2 + iconheight / 2 + 2;
            }
            this.coordinatesHeight = (int)(8.0f * this.coordinatesScale);
            this.bossOffset = this.coordinatesOffset + this.coordinatesHeight;
        } else {
            this.coordinatesOffset = 0;
            int iconheight = (int)((float)(10 * this.settings.getIconScale()) / 100.0f);
            this.compassOffset = this.settings.getCompassHeight() / 2 < iconheight ? iconheight - this.settings.getCompassHeight() / 2 : 0;
            this.coordinatesHeight = 0;
            iconheight = (int)((float)(22 * this.settings.getIconScale()) / 100.0f);
            this.bossOffset = this.settings.getCompassHeight();
            if (this.settings.getCompassHeight() < this.compassOffset + this.settings.getCompassHeight() / 2 + iconheight / 2) {
                this.bossOffset = this.compassOffset + this.settings.getCompassHeight() / 2 + iconheight / 2;
            }
        }
    }

    public void render(class_332 context, float pticks) {
        if (!this.renderWithDebug()) {
            return;
        }
        if (!this.renderWithPlayerList()) {
            return;
        }
        if (AdvancedCompass.getConfig().getShowMode().equals(ShowMode.OFF)) {
            return;
        }
        if (!AdvancedCompass.getConfig().getShowMode().equals(ShowMode.ALWAYS_ON)) {
            if (AdvancedCompass.getConfig().getShowMode().equals(ShowMode.MAIN_HAND) && !InventoryUtils.isCompass(this.mc.field_1724.method_6047())) {
                return;
            }
            if (AdvancedCompass.getConfig().getShowMode().equals(ShowMode.BOTH_HANDS) && !InventoryUtils.hasCompass(this.mc.field_1724.method_5877())) {
                return;
            }
            if (AdvancedCompass.getConfig().getShowMode().equals(ShowMode.ANY_SLOT) && !InventoryUtils.hasCompass(new Iterable[]{this.mc.field_1724.method_31548().field_7547, this.mc.field_1724.method_31548().field_7548, this.mc.field_1724.method_31548().field_7544})) {
                return;
            }
        }
        int width = this.mc.method_22683().method_4486();
        float scale = this.getScale(width, this.settings.getCompassWidth());
        float angle = -class_3532.method_15393((float)this.mc.field_1724.method_5705(pticks));
        context.method_51448().method_22903();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, (float)(this.compassOffset + this.settings.getyOffset()), -1.0f);
        context.method_25290(this.COMPASS_TOP, (int)((float)(width / 2) - (float)(this.settings.getCompassWidth() / 2) * scale), 0, 0.0f, 0.0f, (int)((float)this.settings.getCompassWidth() * scale), (int)(3.0f * scale), (int)((float)this.settings.getCompassWidth() * scale), (int)(3.0f * scale));
        context.method_25290(this.COMPASS_MID, (int)((float)(width / 2) - (float)(this.settings.getCompassWidth() / 2) * scale), (int)(scale * 3.0f), 0.0f, 0.0f, (int)((float)this.settings.getCompassWidth() * scale), (int)((float)(this.settings.getCompassHeight() - 6) * scale), (int)((float)this.settings.getCompassWidth() * scale), (int)((float)(this.settings.getCompassHeight() - 6) * scale));
        context.method_25290(this.COMPASS_BOT, (int)((float)(width / 2) - (float)(this.settings.getCompassWidth() / 2) * scale), (int)((float)(this.settings.getCompassHeight() - 3) * scale), 0.0f, 0.0f, (int)((float)this.settings.getCompassWidth() * scale), (int)(3.0f * scale), (int)((float)this.settings.getCompassWidth() * scale), (int)(3.0f * scale));
        context.method_25290(this.CARDINAL_P, width / 2 - 3, (int)((float)(this.settings.getCompassHeight() - 1) * scale), 0.0f, 0.0f, 6, 4, 6, 18);
        context.method_51448().method_22903();
        RenderSystem.enableBlend();
        context.method_51448().method_46416((float)width * 0.5f, 0.0f, 1.0f);
        this.compassRenderer.render(context, angle, scale);
        if (this.settings.isShowEntities()) {
            this.entitiesRenderer.render(context, angle, scale);
        }
        if (this.settings.isShowWaypoints()) {
            this.waypointRenderer.render(context, angle, scale);
        }
        RenderSystem.disableBlend();
        context.method_51448().method_22909();
        context.method_51448().method_22909();
        if (!this.settings.getCoordinatesMode().equals(CoordinatesMode.OFF)) {
            context.method_51448().method_22903();
            class_243 pos = this.mc.field_1724.method_19538();
            String coords = String.format("%.1f  %.0f  %.1f", pos.field_1352, pos.field_1351, pos.field_1350);
            context.method_51448().method_46416((float)width * 0.5f, (float)(this.coordinatesOffset + this.settings.getyOffset()), 0.0f);
            context.method_51448().method_22905(this.coordinatesScale, this.coordinatesScale, this.coordinatesScale);
            context.method_25303(this.mc.field_1772, coords, (int)((float)(-this.mc.field_1772.method_1727(coords)) * 0.5f), 0, -1);
            context.method_51448().method_22909();
        }
        RenderSystem.disableBlend();
        context.method_51448().method_22909();
    }

    private boolean renderWithDebug() {
        if (this.settings.isDebugRendering()) {
            return true;
        }
        return !this.mc.field_1690.field_1866;
    }

    private boolean renderWithPlayerList() {
        if (this.settings.isPlayerlistRendering()) {
            return true;
        }
        class_269 scoreboard = this.mc.field_1687.method_8428();
        class_266 objective1 = scoreboard.method_1189(0);
        return !this.mc.field_1690.field_1907.method_1434() || this.mc.method_1542() && this.mc.field_1724.field_3944.method_2880().size() <= 1 && objective1 == null;
    }

    private float getScale(int width, int w) {
        if (width < w) {
            return (float)width / (float)w;
        }
        return 1.0f;
    }

    public void removeWaypointByName(String name) {
        this.waypointRenderer.removeWaypointByName(name);
    }

    public void addWaypoint(Waypoint waypoint) {
        this.waypointRenderer.addWaypoint(waypoint);
    }

    public void setWaypoints(Collection waypoints) {
        this.waypointRenderer.setWaypoints(waypoints);
    }

    public void removeWaypoint(Waypoint w) {
        this.waypointRenderer.removeWaypoint(w);
    }

    public void changeWaypoint(Waypoint w) {
        this.waypointRenderer.changeWaypoint(w);
    }
}

