/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.config;

import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.config.CompassConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static File file;
    private static CompassConfig config;

    private static void prepareConfigFile() {
        if (file != null) {
            return;
        }
        file = new File(FabricLoader.getInstance().getConfigDir().toString(), "advancedcompass.json");
    }

    public static CompassConfig initializeConfig() {
        if (config != null) {
            return config;
        }
        config = new CompassConfig();
        ConfigManager.load();
        return config;
    }

    public static void save() {
        ConfigManager.prepareConfigFile();
        String jsonString = AdvancedCompass.GSON.toJson((Object)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save InventoryHUD configuration file");
            e.printStackTrace();
        }
    }

    private static void load() {
        ConfigManager.prepareConfigFile();
        try {
            BufferedReader br;
            CompassConfig parsed;
            if (!file.exists()) {
                ConfigManager.save();
            }
            if (file.exists() && (parsed = (CompassConfig)AdvancedCompass.GSON.fromJson((Reader)(br = new BufferedReader(new FileReader(file))), CompassConfig.class)) != null) {
                config = parsed;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't load InventoryHUD configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static CompassConfig getConfig() {
        if (config == null) {
            config = new CompassConfig();
        }
        return config;
    }
}

