/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.BuiltInEndecs;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import it.unimi.dsi.fastutil.Pair;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_5131;
import org.slf4j.Logger;

public class AttributeUtils {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final StructEndec<class_1322> ATTRIBUTE_MODIFIER_ENDEC = StructEndecBuilder.of((StructField)BuiltInEndecs.UUID.fieldOf("uuid", class_1322::method_6189), (StructField)Endec.STRING.fieldOf("name", class_1322::method_6185), (StructField)Endec.DOUBLE.fieldOf("amount", class_1322::method_6186), (StructField)Endec.forEnum(class_1322.class_1323.class).fieldOf("operation", class_1322::method_6182), class_1322::new);

    public static void addTransientAttributeModifiers(class_1309 livingEntity, AccessoryAttributeBuilder attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        class_5131 attributeMap = livingEntity.method_6127();
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        attributes.getSlotModifiers().asMap().forEach((s, modifiers) -> {
            AccessoriesContainer container = (AccessoriesContainer)containers.get(s);
            if (container == null) {
                return;
            }
            modifiers.stream().filter(modifier -> !container.hasModifier(modifier.method_6189())).forEach(container::addTransientModifier);
        });
        attributes.getAttributeModifiers(true).asMap().forEach((holder, modifiers) -> {
            class_1324 instance = attributeMap.method_26842(holder);
            if (instance == null) {
                return;
            }
            modifiers.stream().filter(modifier -> !instance.method_6196(modifier)).forEach(arg_0 -> ((class_1324)instance).method_26835(arg_0));
        });
    }

    public static void removeTransientAttributeModifiers(class_1309 livingEntity, AccessoryAttributeBuilder attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        class_5131 attributeMap = livingEntity.method_6127();
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        attributes.getSlotModifiers().asMap().forEach((s, modifiers) -> {
            AccessoriesContainer container = (AccessoriesContainer)containers.get(s);
            if (container == null) {
                return;
            }
            modifiers.stream().map(class_1322::method_6189).forEach(container::removeModifier);
        });
        attributes.getAttributeModifiers(true).asMap().forEach((holder, modifiers) -> {
            class_1324 instance = attributeMap.method_26842(holder);
            if (instance == null) {
                return;
            }
            modifiers.stream().map(class_1322::method_6189).forEach(arg_0 -> ((class_1324)instance).method_6200(arg_0));
        });
    }

    public static class_2960 getLocation(String name) {
        String safeName = name.toLowerCase(Locale.ROOT).replace(" ", "_").replaceAll("(?![a-z0-9/._-]).|\n", "");
        class_2960 location = class_2960.method_12829((String)safeName);
        if (location == null) {
            location = Accessories.of(safeName);
        }
        return location;
    }

    public static Pair<String, UUID> getModifierData(class_2960 location) {
        String name = location.toString();
        UUID id = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        return Pair.of((Object)name, (Object)id);
    }
}

