/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.components.AccessoryRenderOverrideComponent;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.endec.format.nbt.NbtDeserializer;
import io.wispforest.accessories.endec.format.nbt.NbtEndec;
import io.wispforest.accessories.endec.format.nbt.NbtSerializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public class AccessoriesDataComponents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final KeyedEndec<AccessoryNestContainerContents> NESTED_ACCESSORIES = AccessoryNestContainerContents.ENDEC.keyed(Accessories.of("nested_accessories").toString(), (Object)AccessoryNestContainerContents.EMPTY);
    public static final KeyedEndec<AccessoryRenderOverrideComponent> RENDER_OVERRIDE = AccessoryRenderOverrideComponent.ENDEC.keyed(Accessories.of("render_override").toString(), (Object)AccessoryRenderOverrideComponent.DEFAULT);
    public static final KeyedEndec<AccessorySlotValidationComponent> SLOT_VALIDATION = AccessorySlotValidationComponent.ENDEC.keyed(Accessories.of("slot_validation").toString(), (Object)AccessorySlotValidationComponent.EMPTY);
    public static final KeyedEndec<AccessoryItemAttributeModifiers> ATTRIBUTES = AccessoryItemAttributeModifiers.ENDEC.keyed(Accessories.of("attributes").toString(), (Object)AccessoryItemAttributeModifiers.EMPTY);
    public static final KeyedEndec<AccessoryStackSizeComponent> STACK_SIZE = AccessoryStackSizeComponent.ENDEC.keyed(Accessories.of("stack_size").toString(), (Object)AccessoryStackSizeComponent.DEFAULT);
    public static final Endec<Map<class_2960, class_2520>> COMPONENTS_ENDEC = NbtEndec.COMPOUND.xmap(compoundTag -> {
        HashMap<class_2960, class_2520> map = new HashMap<class_2960, class_2520>();
        for (String key : compoundTag.method_10541()) {
            class_2960 location = class_2960.method_12829((String)key);
            if (location == null) continue;
            map.put(location, compoundTag.method_10580(key));
        }
        return map;
    }, map -> {
        class_2487 compound = new class_2487();
        map.forEach((location, tag) -> compound.method_10566(location.toString(), tag));
        return compound;
    });
    public static final KeyedEndec<Map<class_2960, class_2520>> COMPONENTS_KEY = COMPONENTS_ENDEC.keyed("components", HashMap::new);

    @ApiStatus.Internal
    public static void init() {
    }

    public static <T> boolean has(KeyedEndec<T> keyedEndec, class_1799 stack) {
        class_2960 location;
        class_2487 tag = stack.method_7969();
        if (tag != null && (location = class_2960.method_12829((String)keyedEndec.key())) != null) {
            return ((Map)new NbtMapCarrier(tag).get(COMPONENTS_KEY)).containsKey(location);
        }
        return false;
    }

    public static <T> T readOrDefault(KeyedEndec<T> keyedEndec, class_1799 stack) {
        NbtMapCarrier carrier;
        Map components;
        class_2520 data;
        class_2960 location;
        class_2487 tag = stack.method_7969();
        if (tag != null && (location = class_2960.method_12829((String)keyedEndec.key())) != null && (data = (class_2520)(components = (Map)(carrier = new NbtMapCarrier(tag)).get(COMPONENTS_KEY)).get(location)) != null) {
            try {
                return (T)keyedEndec.endec().decodeFully(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new StackAttribute(stack.method_7972())}), NbtDeserializer::of, (Object)data);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to read the given component from the given stack: [Key: {}]", (Object)keyedEndec.key(), (Object)e);
                components.remove(location);
                carrier.put(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new StackAttribute(stack.method_7972())}), COMPONENTS_KEY, components);
            }
        }
        return (T)keyedEndec.defaultValue();
    }

    public static <T> void write(KeyedEndec<T> keyedEndec, class_1799 stack, T data) {
        NbtMapCarrier carrier = new NbtMapCarrier(stack.method_7948());
        Map components = (Map)carrier.get(COMPONENTS_KEY);
        class_2960 location = class_2960.method_12829((String)keyedEndec.key());
        if (location != null) {
            try {
                components.put(location, (class_2520)keyedEndec.endec().encodeFully(NbtSerializer::of, data));
            }
            catch (Exception e) {
                LOGGER.warn("Unable to write the given component from the given stack: [Key: {}]", (Object)keyedEndec.key(), (Object)e);
            }
        }
        carrier.put(COMPONENTS_KEY, components);
    }

    public static <T> void update(KeyedEndec<T> keyedEndec, class_1799 stack, UnaryOperator<T> operator) {
        AccessoriesDataComponents.write(keyedEndec, stack, operator.apply(AccessoriesDataComponents.readOrDefault(keyedEndec, stack)));
    }

    public record StackAttribute(class_1799 stack) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<StackAttribute> INSTANCE = SerializationAttribute.withValue((String)"accessories:stack");

        public SerializationAttribute attribute() {
            return INSTANCE;
        }

        public Object value() {
            return this;
        }
    }
}

