/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.resources;

import java.util.Locale;

public enum Rank {
    OUTLAW,
    PEASANT,
    MERCHANT,
    NOBLE,
    MAYOR,
    MONARCH;

    private static final Rank[] VALUES;

    public Rank promote() {
        if (this.ordinal() + 1 < VALUES.length) {
            return VALUES[this.ordinal() + 1];
        }
        return MONARCH;
    }

    public Rank degrade() {
        if (this.ordinal() - 1 >= 0) {
            return VALUES[this.ordinal() - 1];
        }
        return null;
    }

    public static Rank fromName(String name) {
        try {
            return Rank.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return PEASANT;
        }
    }

    public boolean isAtLeast(Rank r) {
        return this.ordinal() >= r.ordinal();
    }

    public String getTranslationKey() {
        return "gui.village.rank." + this.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        VALUES = Rank.values();
    }
}

