/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.client.model;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import quilt.net.mca.MCAClient;
import quilt.net.mca.entity.EntitiesMCA;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.VillagerLike;
import quilt.net.mca.entity.ai.relationship.Gender;
import quilt.net.mca.entity.ai.relationship.VillagerDimensions;

public interface CommonVillagerModel<T extends class_1309> {
    public class_630 getBreastPart();

    public class_630 getBodyPart();

    public Iterable<class_630> getCommonHeadParts();

    public Iterable<class_630> getCommonBodyParts();

    public Iterable<class_630> getBreastParts();

    public VillagerDimensions.Mutable getDimensions();

    public float getBreastSize();

    public void setBreastSize(float var1);

    default public void renderCommon(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        float breastSize;
        float headSize = this.getDimensions().getHead();
        matrices.method_22903();
        matrices.method_22905(headSize, headSize, headSize);
        this.getCommonHeadParts().forEach(a -> a.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha));
        matrices.method_22909();
        this.getCommonBodyParts().forEach(a -> a.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha));
        if (this.getBreastPart().field_3665 && this.getBodyPart().field_3665 && (breastSize = this.getBreastSize() * this.getDimensions().getBreasts()) > 0.0f) {
            matrices.method_22903();
            matrices.method_22905(breastSize * 0.2f + 1.05f, breastSize * 0.75f + 0.75f, breastSize * 0.75f + 0.75f);
            for (class_630 part : this.getBreastParts()) {
                part.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
            }
            matrices.method_22909();
        }
    }

    default public void applyVillagerDimensions(VillagerLike<?> villager, boolean isSneaking) {
        this.getDimensions().set(villager.getVillagerDimensions());
        this.setBreastSize(villager.getGenetics().getBreastSize());
        this.getBreastPart().field_3665 = villager.getGenetics().getGender() == Gender.FEMALE;
        for (class_630 part : this.getBreastParts()) {
            part.field_3654 = 0.9424779f + this.getBodyPart().field_3654;
            float cy = 0.0f;
            float cz = 0.0f;
            if (isSneaking) {
                cy = 3.0f;
                cz = 1.5f;
            }
            part.method_2851(0.25f, (float)(5.0 - Math.pow(this.getBreastSize(), 0.5) * 2.5 + (double)cy), -1.5f + this.getBreastSize() * 0.25f + cz);
        }
    }

    default public void copyCommonAttributes(CommonVillagerModel<T> target) {
        target.getDimensions().set(this.getDimensions());
        target.setBreastSize(this.getBreastSize());
    }

    public static VillagerLike<?> getVillager(class_1937 world, UUID uuid) {
        if (MCAClient.fallbackVillager == null) {
            MCAClient.fallbackVillager = (VillagerEntityMCA)((class_1299)EntitiesMCA.MALE_VILLAGER.get()).method_5883(world);
        }
        return MCAClient.playerData.getOrDefault(uuid, MCAClient.fallbackVillager);
    }

    public static VillagerLike<?> getVillager(class_1297 villager) {
        if (villager instanceof VillagerLike) {
            VillagerLike v = (VillagerLike)villager;
            return v;
        }
        return CommonVillagerModel.getVillager(villager.method_37908(), villager.method_5667());
    }
}

