/*
 * Decompiled with CFR 0.152.
 */
package vt.villagernameisprofession.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import org.apache.commons.io.FileUtils;

public class Configuration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "VillagerNameIsProfession.json";
    private static final File CONFIG_FILE = class_310.method_1551().field_1697.toPath().resolve("config").resolve("VillagerNameIsProfession.json").toFile();
    private boolean alwaysVisibleProfession = true;
    private int radius = 100;
    private List<String> profession = new ArrayList<String>();
    private boolean isProfessionListBlocking;

    private Configuration() {
        this.profession.add("none");
        this.isProfessionListBlocking = true;
    }

    public boolean isProfessionListBlocking() {
        return this.isProfessionListBlocking;
    }

    public void setProfessionListBlocking(boolean isProfessionListBlocking) {
        this.isProfessionListBlocking = isProfessionListBlocking;
    }

    public boolean isAlwaysVisibleProfession() {
        return this.alwaysVisibleProfession;
    }

    public void setAlwaysVisibleProfession(boolean alwaysVisibleProfession) {
        this.alwaysVisibleProfession = alwaysVisibleProfession;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public List<String> getProfession() {
        return this.profession;
    }

    public void setProfession(List<String> profession) {
        this.profession = profession;
    }

    public static Configuration load() {
        if (CONFIG_FILE.exists()) {
            try {
                return (Configuration)GSON.fromJson(FileUtils.readFileToString((File)CONFIG_FILE, (Charset)StandardCharsets.UTF_8), Configuration.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new Configuration();
    }

    public void save() {
        try {
            FileUtils.writeStringToFile((File)CONFIG_FILE, (String)GSON.toJson((Object)this), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> getConfigFields() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("alwaysVisibleProfession", this.alwaysVisibleProfession);
        fields.put("radius", this.radius);
        fields.put("profession", this.profession);
        fields.put("isProfessionListBlocking", this.isProfessionListBlocking);
        return fields;
    }
}

