/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.toomanyorigins.platform;

import com.google.auto.service.AutoService;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeReference;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.apace100.origins.badge.BadgeManager;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.merchantpug.toomanyorigins.TooManyOrigins;
import net.merchantpug.toomanyorigins.badge.factory.IBadgeFactory;
import net.merchantpug.toomanyorigins.platform.Services;
import net.merchantpug.toomanyorigins.platform.services.IPowerHelper;
import net.merchantpug.toomanyorigins.power.factory.SimplePowerFactory;
import net.merchantpug.toomanyorigins.power.factory.SpecialPowerFactory;
import net.merchantpug.toomanyorigins.registry.TMORegisters;
import net.merchantpug.toomanyorigins.registry.services.RegistryObject;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;

@AutoService(value={IPowerHelper.class})
public class FabricPowerHelper
implements IPowerHelper<PowerTypeReference> {
    public PowerFactory<?> unwrapSimpleFactory(PowerFactory<?> factory) {
        return factory;
    }

    @Override
    public <F extends SimplePowerFactory<?>> RegistryObject<F> registerFactory(F factory) {
        return TMORegisters.POWER_FACTORIES.register(factory.getSerializerId().method_12832(), () -> factory);
    }

    @Override
    public <F extends SpecialPowerFactory<?>> RegistryObject<F> registerFactory(String name, Class<F> factoryClass) {
        SpecialPowerFactory factory = (SpecialPowerFactory)Services.load(factoryClass);
        return TMORegisters.POWER_FACTORIES.register(name, () -> (PowerFactory)factory);
    }

    @Override
    public <P extends Power> List<P> getPowers(class_1309 entity, SimplePowerFactory<P> factory) {
        return PowerHolderComponent.getPowers((class_1297)entity, factory.getPowerClass());
    }

    @Override
    public <P> List<P> getPowers(class_1309 entity, SpecialPowerFactory<P> factory) {
        LinkedList<Power> list = new LinkedList<Power>();
        if (PowerHolderComponent.KEY.isProvidedBy((Object)entity)) {
            List powers = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity)).getPowers();
            Class<P> cls = factory.getPowerClass();
            for (Power power : powers) {
                if (!cls.isAssignableFrom(power.getClass()) || !power.isActive()) continue;
                list.add(power);
            }
        }
        return list;
    }

    @Override
    public <P extends Power> boolean hasPower(class_1309 entity, SimplePowerFactory<P> factory) {
        return PowerHolderComponent.hasPower((class_1297)entity, factory.getPowerClass());
    }

    @Override
    public <P> boolean hasPower(class_1309 entity, SpecialPowerFactory<P> factory) {
        List powers = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity)).getPowers();
        Class<P> cls = factory.getPowerClass();
        LinkedList list = new LinkedList();
        for (Power power : powers) {
            if (!cls.isAssignableFrom(power.getClass()) || !power.isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SerializableDataType<PowerTypeReference> getPowerTypeDataType() {
        return ApoliDataTypes.POWER_TYPE;
    }

    @Override
    public OptionalInt getResource(class_1309 entity, PowerTypeReference powerType) {
        Power power = powerType.get((class_1297)entity);
        if (power instanceof VariableIntPower) {
            VariableIntPower vip = (VariableIntPower)power;
            return OptionalInt.of(vip.getValue());
        }
        if (power instanceof CooldownPower) {
            CooldownPower cdp = (CooldownPower)power;
            return OptionalInt.of(cdp.getRemainingTicks());
        }
        TooManyOrigins.LOG.warn("Failed to get resource for power [{}], because it doesn't hold any resource!", (Object)powerType.getIdentifier());
        return OptionalInt.empty();
    }

    @Override
    public OptionalInt setResource(class_1309 entity, PowerTypeReference powerType, int value) {
        Power power = powerType.get((class_1297)entity);
        if (power instanceof VariableIntPower) {
            VariableIntPower vip = (VariableIntPower)power;
            int result = vip.setValue(value);
            PowerHolderComponent.syncPower((class_1297)entity, (PowerType)powerType);
            return OptionalInt.of(result);
        }
        if (power instanceof CooldownPower) {
            CooldownPower cdp = (CooldownPower)power;
            cdp.setCooldown(value);
            PowerHolderComponent.syncPower((class_1297)entity, (PowerType)powerType);
            return OptionalInt.of(cdp.getRemainingTicks());
        }
        TooManyOrigins.LOG.warn("Failed to set resource for power [{}], because it doesn't hold any resource!", (Object)powerType.getIdentifier());
        return OptionalInt.empty();
    }

    @Override
    public <F extends IBadgeFactory> Supplier<BadgeFactory> registerBadge(String name, Class<F> badgeClass) {
        IBadgeFactory factory = (IBadgeFactory)Services.load(badgeClass);
        class_2960 resource = TooManyOrigins.asResource(name);
        if (BadgeManager.REGISTRY.getFactory(resource) == null) {
            BadgeManager.register((BadgeFactory)new BadgeFactory(resource, factory.getSerializableData(), factory.getFactoryCreator()));
        }
        return () -> (BadgeFactory)BadgeManager.REGISTRY.getFactory(resource);
    }
}

