/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.toomanyorigins.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.merchantpug.toomanyorigins.TooManyOrigins;
import net.merchantpug.toomanyorigins.data.LegacyContentRecord;
import net.merchantpug.toomanyorigins.data.LegacyContentRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.slf4j.Logger;

public class LegacyContentManager
extends class_4080<Set<LegacyContentRecord>> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    protected Set<LegacyContentRecord> prepare(class_3300 manager, class_3695 profiler) {
        HashSet<LegacyContentRecord> enabledSet = new HashSet<LegacyContentRecord>();
        Iterator iterator = manager.method_14488("toomanyorigins", id -> id.method_12832().equals("toomanyorigins/legacy_content.json")).entrySet().iterator();
        HashSet resourcesHandled = new HashSet();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            resourcesHandled.clear();
            manager.method_14489((class_2960)next.getKey()).forEach(resource -> {
                if (!resourcesHandled.contains(resource.method_14480())) {
                    resourcesHandled.add(resource.method_14480());
                    try {
                        BufferedReader reader = resource.method_43039();
                        JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
                        DataResult dataResult = LegacyContentRecord.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
                        dataResult.error().ifPresent(result -> TooManyOrigins.LOG.info("Error loading legacy_content json file from pack '{}'. (Skipping). {}", (Object)resource.method_14480(), (Object)result.message()));
                        dataResult.resultOrPartial(arg_0 -> ((Logger)TooManyOrigins.LOG).error(arg_0)).ifPresent(pair -> enabledSet.add((LegacyContentRecord)pair.getFirst()));
                    }
                    catch (Throwable e) {
                        TooManyOrigins.LOG.error("There was a problem reading TooManyOrigins legacy content file from pack '{}'. (skipping): {}.", (Object)resource.method_14480(), (Object)e.getMessage());
                    }
                }
            });
        }
        return enabledSet;
    }

    protected void apply(Set<LegacyContentRecord> prepared, class_3300 manager, class_3695 profiler) {
        LegacyContentRegistry.disableAll();
        LegacyContentRegistry.setRecord(prepared.stream().anyMatch(LegacyContentRecord::dragonFireballEnabled), prepared.stream().anyMatch(LegacyContentRecord::witheredCropsEnabled), prepared.stream().anyMatch(LegacyContentRecord::zombifyingEnabled));
        if (LegacyContentRegistry.getContentCount() > 0) {
            TooManyOrigins.LOG.info("Successfully enabled {} TooManyOrigins legacy content modules.", (Object)LegacyContentRegistry.getContentCount());
        }
    }
}

