/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.toomanyorigins.badge;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.badge.BadgeFactory;
import java.util.LinkedList;
import java.util.List;
import net.merchantpug.toomanyorigins.badge.IBadge;
import net.merchantpug.toomanyorigins.client.tooltip.GuiTooltipComponent;
import net.merchantpug.toomanyorigins.registry.TMOBadges;
import net.merchantpug.toomanyorigins.util.GuiBackground;
import net.merchantpug.toomanyorigins.util.GuiContent;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5683;
import net.minecraft.class_5684;

public interface IGuiBadge<P>
extends IBadge<P> {
    default public boolean hasTooltip() {
        return true;
    }

    public static void addLines(List<class_5684> tooltips, class_2561 text, class_327 textRenderer, int widthLimit) {
        if (textRenderer.method_27525((class_5348)text) > widthLimit) {
            for (class_5481 orderedText : textRenderer.method_1728((class_5348)text, widthLimit)) {
                tooltips.add((class_5684)new class_5683(orderedText));
            }
        } else {
            tooltips.add((class_5684)new class_5683(text.method_30937()));
        }
    }

    @Override
    default public List<class_5684> generateTooltipComponents(P power, int widthLimit, float time, class_327 textRenderer) {
        LinkedList<class_5684> tooltips = new LinkedList<class_5684>();
        class_2371<GuiContent> contentList = this.peekContent(time);
        if (this.getPrefix() != null) {
            IGuiBadge.addLines(tooltips, this.getPrefix(), textRenderer, widthLimit);
        }
        tooltips.add(new GuiTooltipComponent(this.getBackground(), contentList, class_3532.method_15375((float)(time / 30.0f))));
        if (this.getSuffix() != null) {
            IGuiBadge.addLines(tooltips, this.getSuffix(), textRenderer, widthLimit);
        }
        return tooltips;
    }

    default public class_2371<GuiContent> peekContent(float time) {
        int seed = class_3532.method_15375((float)(time / 30.0f));
        if (this.getContent().isEmpty()) {
            return class_2371.method_10211();
        }
        int contentSize = this.getContent().size();
        class_2371 contents = class_2371.method_10211();
        for (int index = 0; index < contentSize; ++index) {
            List<GuiContent> content = this.getContent().get(index);
            if (content.size() <= 0) continue;
            contents.add((Object)content.get(seed % content.size()));
        }
        return contents;
    }

    default public SerializableData.Instance toData(SerializableData.Instance instance) {
        instance.set("sprite", (Object)this.spriteId());
        instance.set("prefix", (Object)this.getPrefix());
        instance.set("suffix", (Object)this.getSuffix());
        instance.set("background", (Object)this.getBackground());
        instance.set("content", this.getContent());
        return instance;
    }

    default public BadgeFactory getBadgeFactory() {
        return TMOBadges.GUI.get();
    }

    public GuiBackground getBackground();

    public List<List<GuiContent>> getContent();

    public class_2561 getPrefix();

    public class_2561 getSuffix();
}

