/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.platform.fabric;

import com.lion.graveyard.item.BoneStaffItem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class ServerEvents {

    public static class UnloadUUIDMapping
    implements ServerWorldEvents.Unload {
        public void onWorldUnload(MinecraftServer server, class_3218 world) {
            this.saveGhoulingUUIDFile(server);
        }

        private void saveGhoulingUUIDFile(MinecraftServer server) {
            try {
                FileWriter fileWriter = new FileWriter(server.method_27050(class_5218.field_24188).toString() + "/graveyardGhoulingUUIDmapping.txt");
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                for (Map.Entry<UUID, UUID> entry : BoneStaffItem.ownerGhoulingMapping.entrySet()) {
                    bufferedWriter.write(entry.getKey() + ":" + entry.getValue());
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class LoadUUIDMapping
    implements ServerWorldEvents.Load {
        public void onWorldLoad(MinecraftServer server, class_3218 world) {
            this.readGhoulingUUIDFile(server);
        }

        private void readGhoulingUUIDFile(MinecraftServer server) {
            File file = new File(server.method_27050(class_5218.field_24188).toString() + "/graveyardGhoulingUUIDmapping.txt");
            if (file.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(server.method_27050(class_5218.field_24188).toString() + "/graveyardGhoulingUUIDmapping.txt"));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] keyValuePair = line.split(":", 2);
                        if (keyValuePair.length <= 1) continue;
                        String key = keyValuePair[0];
                        String value = keyValuePair[1];
                        BoneStaffItem.ownerGhoulingMapping.putIfAbsent(UUID.fromString(key), UUID.fromString(value));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class DeleteOldConfigs
    implements ServerLifecycleEvents.ServerStarted {
        public void onServerStarted(MinecraftServer server) {
            ArrayList<File> oldConfigs = new ArrayList<File>();
            oldConfigs.add(new File(FabricLoader.getInstance().getConfigDir().toString() + "/the-graveyard-config.json5"));
            oldConfigs.add(new File(FabricLoader.getInstance().getConfigDir().toString() + "/the-graveyard-1.19-config.json5"));
            oldConfigs.add(new File(FabricLoader.getInstance().getConfigDir().toString() + "/graveyard/the-graveyard-2.0-config.json5"));
            oldConfigs.add(new File(FabricLoader.getInstance().getConfigDir().toString() + "/graveyard/the-graveyard-2.2-config.json5"));
            oldConfigs.add(new File(FabricLoader.getInstance().getConfigDir().toString() + "/graveyard/the-graveyard-2.3-config.json5"));
            oldConfigs.add(new File(FabricLoader.getInstance().getConfigDir().toString() + "/graveyard/the-graveyard-2.4-config.json5"));
            oldConfigs.add(new File(FabricLoader.getInstance().getConfigDir().toString() + "/graveyard/the-graveyard-2.5-config.json5"));
            oldConfigs.add(new File(FabricLoader.getInstance().getConfigDir().toString() + "/graveyard/the-graveyard-2.6-config.json5"));
            oldConfigs.add(new File(FabricLoader.getInstance().getConfigDir().toString() + "/graveyard/the-graveyard-2.7-config.json5"));
            for (File file : oldConfigs) {
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }
}

