/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.entities.HostileGraveyardEntity;
import com.lion.graveyard.entities.ai.goals.NightmareMeleeAttackGoal;
import com.lion.graveyard.init.TGAdvancements;
import com.lion.graveyard.init.TGSounds;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_6019;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NightmareEntity
extends HostileGraveyardEntity
implements GeoEntity,
class_5354 {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation WALK_ANIMATION = RawAnimation.begin().then("walk", Animation.LoopType.LOOP);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    protected static final byte ANIMATION_IDLE = 0;
    protected static final byte ANIMATION_WALK = 1;
    protected static final byte ANIMATION_DEATH = 3;
    protected static final byte ANIMATION_ATTACK = 5;
    protected static final class_2940<Byte> ANIMATION = class_2945.method_12791(NightmareEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> ATTACK_ANIM_TIMER = class_2945.method_12791(NightmareEntity.class, (class_2941)class_2943.field_13327);
    public final int ATTACK_ANIMATION_DURATION = 20;
    private static final class_2940<Boolean> ANGRY = class_2945.method_12791(NightmareEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> PROVOKED = class_2945.method_12791(NightmareEntity.class, (class_2941)class_2943.field_13323);
    private static final class_6019 ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private UUID target;
    private int angerTime;
    private int ageWhenTargetSet;

    public NightmareEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world, "nightmare");
        this.method_49477(1.0f);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ANGRY, (Object)false);
        this.field_6011.method_12784(PROVOKED, (Object)false);
        this.field_6011.method_12784(ANIMATION, (Object)0);
        this.field_6011.method_12784(ATTACK_ANIM_TIMER, (Object)0);
    }

    public int getAnimationState() {
        return ((Byte)this.field_6011.method_12789(ANIMATION)).byteValue();
    }

    public void setState(byte time) {
        this.field_6011.method_12778(ANIMATION, (Object)time);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new ChasePlayerGoal(this));
        this.field_6201.method_6277(2, (class_1352)new NightmareMeleeAttackGoal(this, 1.0, false));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new TeleportTowardsPlayerGoal(this, arg_0 -> ((NightmareEntity)this).method_29515(arg_0)));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
    }

    protected void method_5958() {
        float f;
        if (this.getAttackAnimTimer() == 20) {
            this.setAnimation((byte)5);
        }
        if (this.getAttackAnimTimer() > 0) {
            int animTimer = this.getAttackAnimTimer() - 1;
            this.setAttackAnimTimer(animTimer);
        }
        if (this.method_5770().method_8530() && this.field_6012 >= this.ageWhenTargetSet + 600 && (f = this.method_5718()) > 0.5f && this.method_5770().method_8311(this.method_24515()) && this.field_5974.method_43057() * 30.0f < (f - 0.4f) * 2.0f) {
            this.method_5980(null);
            this.teleportRandomly();
        }
        super.method_5958();
    }

    @Override
    public void method_6007() {
        this.field_6282 = false;
        if (!this.method_5770().field_9236) {
            if (this.method_5968() != null && this.method_5968().method_5858((class_1297)this) >= 1024.0) {
                this.method_29922();
            }
            this.method_29510((class_3218)this.method_5770(), true);
        }
        super.method_6007();
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.method_29517(nbt);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_29512(this.method_5770(), nbt);
    }

    public static class_5132.class_5133 createNightmareAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 45.0).method_26868(class_5134.field_23724, 3.0).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23719, 0.19).method_26868(class_5134.field_23717, 64.0);
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.field_6213 == 28 && !this.method_5770().method_8608()) {
            this.method_5770().method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42247)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public byte getAnimation() {
        return (Byte)this.field_6011.method_12789(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.field_6011.method_12778(ANIMATION, (Object)animation);
    }

    public int getAttackAnimTimer() {
        return (Integer)this.field_6011.method_12789(ATTACK_ANIM_TIMER);
    }

    public void setAttackAnimTimer(int time) {
        this.field_6011.method_12778(ATTACK_ANIM_TIMER, (Object)time);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, event -> {
            if (this.method_29504()) {
                event.getController().setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 5 && this.getAttackAnimTimer() == 19 && this.method_6510() && !this.method_29504() && !((double)this.method_6032() < 0.01)) {
                this.setAttackAnimTimer(18);
                event.getController().setAnimation(this.ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if ((this.getAnimationState() == 1 || event.isMoving()) && this.getAttackAnimTimer() <= 0) {
                event.getController().setAnimation(this.WALK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 0 && this.getAttackAnimTimer() <= 0 && !event.isMoving()) {
                event.getController().setAnimation(this.IDLE_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 0 && this.getAttackAnimTimer() > 0) {
                this.setAnimation((byte)5);
                return PlayState.STOP;
            }
            if (this.getAttackAnimTimer() <= 0 && !this.method_29504() && !((double)this.method_6032() < 0.01)) {
                this.setAnimation((byte)0);
                return PlayState.STOP;
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void method_5966() {
        this.method_5783(TGSounds.NIGHTMARE_AMBIENT.get(), 1.0f, -10.0f);
    }

    protected void method_6013(class_1282 source) {
        this.method_5783(TGSounds.NIGHTMARE_HURT.get(), 1.0f, -10.0f);
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.method_5783(TGSounds.NIGHTMARE_DEATH.get(), 1.0f, -10.0f);
    }

    boolean isPlayerStaring(class_1657 player) {
        class_1799 itemStack = (class_1799)player.method_31548().field_7548.get(3);
        if (itemStack.method_31574(class_2246.field_10147.method_8389())) {
            return false;
        }
        class_243 vec3d = player.method_5828(1.0f).method_1029();
        class_243 vec3d2 = new class_243(this.method_23317() - player.method_23317(), this.method_23320() - player.method_23320(), this.method_23321() - player.method_23321());
        double d = vec3d2.method_1033();
        double e = vec3d.method_1026(vec3d2 = vec3d2.method_1029());
        if (e > 1.0 - 0.025 / d) {
            return player.method_6057((class_1297)this);
        }
        return false;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 2.55f;
    }

    boolean teleportTo(class_1297 entity) {
        class_243 vec3d = new class_243(this.method_23317() - entity.method_23317(), this.method_23323(0.5) - entity.method_23320(), this.method_23321() - entity.method_23321());
        vec3d = vec3d.method_1029();
        double e = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 2.0 - vec3d.field_1352 * 16.0;
        double f = this.method_23318() + (double)(this.field_5974.method_43048(4) - 2) - vec3d.field_1351 * 16.0;
        double g = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 2.0 - vec3d.field_1350 * 16.0;
        return this.teleportTo(e, f, g);
    }

    private boolean teleportTo(double x, double y, double z) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, y, z);
        while (mutable.method_10264() > this.method_5770().method_31607() && !this.method_5770().method_8320((class_2338)mutable).method_51366()) {
            mutable.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.method_5770().method_8320((class_2338)mutable);
        boolean bl = blockState.method_51366();
        boolean bl2 = blockState.method_26227().method_15767(class_3486.field_15517);
        if (bl && !bl2) {
            boolean bl3 = this.method_6082(x, y, z, false);
            if (bl3 && !this.method_5701()) {
                this.method_5783(class_3417.field_14879, 1.0f, -10.0f);
            }
            return bl3;
        }
        return false;
    }

    protected boolean teleportRandomly() {
        if (!this.method_5770().method_8608() && this.method_5805()) {
            double d = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 64.0;
            double e = this.method_23318() + (double)(this.field_5974.method_43048(64) - 32);
            double f = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 64.0;
            return this.teleportTo(d, e, f);
        }
        return false;
    }

    public boolean method_29511() {
        return (Boolean)this.field_6011.method_12789(ANGRY);
    }

    public void method_29514(int ticks) {
        this.angerTime = ticks;
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void setProvoked() {
        this.field_6011.method_12778(PROVOKED, (Object)true);
    }

    @Nullable
    public UUID method_29508() {
        return this.target;
    }

    public void method_29513(@Nullable UUID uuid) {
        this.target = uuid;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME.method_35008(this.field_5974));
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        if (target == null) {
            this.ageWhenTargetSet = 0;
            this.field_6011.method_12778(ANGRY, (Object)false);
            this.method_29514(0);
            this.field_6011.method_12778(PROVOKED, (Object)false);
        } else {
            this.ageWhenTargetSet = this.field_6012;
            this.field_6011.method_12778(ANGRY, (Object)true);
        }
    }

    protected void method_23733(@Nullable class_1309 adversary) {
        class_3222 player;
        if (adversary instanceof class_3222 && (player = (class_3222)adversary).method_6059(class_1294.field_5919)) {
            TGAdvancements.KILL_WHILE_BLINDED.trigger(player);
        }
        super.method_23733(adversary);
    }

    static class ChasePlayerGoal
    extends class_1352 {
        private final NightmareEntity nightmare;
        @Nullable
        private class_1309 target;

        public ChasePlayerGoal(NightmareEntity nightmare) {
            this.nightmare = nightmare;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            this.target = this.nightmare.method_5968();
            if (!(this.target instanceof class_1657)) {
                return false;
            }
            double d = this.target.method_5858((class_1297)this.nightmare);
            return d > 256.0 ? false : this.nightmare.isPlayerStaring((class_1657)this.target);
        }

        public void method_6269() {
            this.nightmare.method_5942().method_6340();
        }

        public void method_6268() {
            this.nightmare.method_5988().method_20248(this.target.method_23317(), this.target.method_23320(), this.target.method_23321());
        }
    }

    static class TeleportTowardsPlayerGoal
    extends class_1400<class_1657> {
        private final NightmareEntity nightmare;
        @Nullable
        private class_1657 targetPlayer;
        private int lookAtPlayerWarmup;
        private int ticksSinceUnseenTeleport;
        private final class_4051 staringPlayerPredicate;
        private final class_4051 validTargetPredicate = class_4051.method_36625().method_36627();

        public TeleportTowardsPlayerGoal(NightmareEntity nightmare, @Nullable Predicate<class_1309> targetPredicate) {
            super((class_1308)nightmare, class_1657.class, 10, false, false, targetPredicate);
            this.nightmare = nightmare;
            this.staringPlayerPredicate = class_4051.method_36625().method_18418(this.method_6326()).method_18420(playerEntity -> nightmare.isPlayerStaring((class_1657)playerEntity));
        }

        public boolean method_6264() {
            this.targetPlayer = this.nightmare.method_5770().method_18462(this.staringPlayerPredicate, (class_1309)this.nightmare);
            return this.targetPlayer != null;
        }

        public void method_6269() {
            this.lookAtPlayerWarmup = this.method_38847(5);
            this.ticksSinceUnseenTeleport = 0;
            this.nightmare.setProvoked();
        }

        public void method_6270() {
            this.targetPlayer = null;
            super.method_6270();
        }

        public boolean method_6266() {
            if (this.targetPlayer != null) {
                if (!this.nightmare.isPlayerStaring(this.targetPlayer)) {
                    return false;
                }
                this.nightmare.method_5951((class_1297)this.targetPlayer, 10.0f, 10.0f);
                return true;
            }
            return this.field_6644 != null && this.validTargetPredicate.method_18419((class_1309)this.nightmare, this.field_6644) ? true : super.method_6266();
        }

        public void method_6268() {
            if (this.nightmare.method_5968() == null) {
                super.method_24632((class_1309)null);
            }
            if (this.targetPlayer != null) {
                if (--this.lookAtPlayerWarmup <= 0) {
                    this.field_6644 = this.targetPlayer;
                    this.targetPlayer = null;
                    super.method_6269();
                }
            } else {
                if (this.field_6644 != null && !this.nightmare.method_5765()) {
                    if (this.nightmare.isPlayerStaring((class_1657)this.field_6644)) {
                        if (this.field_6644.method_5858((class_1297)this.nightmare) <= 384.0 && this.field_6644 != null && this.field_6644.method_5858((class_1297)this.nightmare) > 24.0) {
                            this.field_6644.method_6092(new class_1293(class_1294.field_5919, 100));
                            this.nightmare.teleportTo((class_1297)this.field_6644);
                        }
                        this.ticksSinceUnseenTeleport = 0;
                    } else if (this.field_6644.method_5858((class_1297)this.nightmare) > 256.0 && this.ticksSinceUnseenTeleport++ >= this.method_38847(80) && this.nightmare.teleportTo((class_1297)this.field_6644)) {
                        this.ticksSinceUnseenTeleport = 0;
                    }
                }
                super.method_6268();
            }
        }
    }
}

