/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.simplysneak.networking;

import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_742;

public class SimplySneakNetworking {
    public static final class_2960 SNEAKING_PACKET_ID = new class_2960("simplysneak", "sneaking_packet");
    public static final class_2960 ANIMATION_PACKET_ID = new class_2960("simplysneak", "animation_packet");
    public static final class_2960 RESET_ANIMATION_PACKET_ID = new class_2960("simplysneak", "reset_animation_packet");

    public static void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ANIMATION_PACKET_ID, (client, handler, buf, responseSender) -> {
            UUID playerUUID = buf.method_10790();
            String animationName = buf.method_19772();
            client.execute(() -> {
                class_1657 player;
                if (client.field_1687 != null && (player = client.field_1687.method_18470(playerUUID)) instanceof class_742) {
                    class_742 targetPlayer = (class_742)player;
                    SimplySneakNetworking.triggerAnimationForPlayer(targetPlayer, animationName);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RESET_ANIMATION_PACKET_ID, (client, handler, buf, responseSender) -> {
            UUID playerUUID = buf.method_10790();
            client.execute(() -> {
                class_1657 player;
                if (client.field_1687 != null && (player = client.field_1687.method_18470(playerUUID)) instanceof class_742) {
                    class_742 targetPlayer = (class_742)player;
                    SimplySneakNetworking.resetAnimationForPlayer(targetPlayer);
                }
            });
        });
    }

    public static void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SNEAKING_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            boolean isSneaking = buf.readBoolean();
            server.execute(() -> {
                if (isSneaking) {
                    SimplySneakNetworking.broadcastAnimationToNearbyPlayers(player, "hiding");
                } else {
                    SimplySneakNetworking.broadcastResetToNearbyPlayers(player);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ANIMATION_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            UUID playerUUID = buf.method_10790();
            String animationName = buf.method_19772();
            server.execute(() -> SimplySneakNetworking.broadcastAnimationToNearbyPlayers(player, animationName));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RESET_ANIMATION_PACKET_ID, (server, player, handler, buf, responseSender) -> server.execute(() -> SimplySneakNetworking.broadcastResetToNearbyPlayers(player)));
    }

    public static void sendSneakingPacket(class_2540 buf) {
        ClientPlayNetworking.send((class_2960)SNEAKING_PACKET_ID, (class_2540)buf);
    }

    private static void triggerAnimationForPlayer(class_742 player, String animationName) {
        KeyframeAnimation animation;
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null && (animation = PlayerAnimationRegistry.getAnimation((class_2960)new class_2960("simplysneak", animationName))) != null) {
            AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
            animationStack.removeLayer(0);
            KeyframeAnimationPlayer animationPlayer = new KeyframeAnimationPlayer(animation);
            animationStack.addAnimLayer(0, (IAnimation)animationPlayer);
        }
    }

    private static void resetAnimationForPlayer(class_742 player) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null) {
            AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
            animationStack.removeLayer(0);
        }
    }

    private static void broadcastAnimationToNearbyPlayers(class_3222 sender, String animationName) {
        double radius = 64.0;
        class_1937 world = sender.method_37908();
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(sender.method_5667());
        buf.method_10814(animationName);
        world.method_18456().forEach(player -> {
            class_3222 serverPlayer;
            if (player instanceof class_3222 && (serverPlayer = (class_3222)player) != sender && serverPlayer.method_5858((class_1297)sender) <= radius * radius) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)ANIMATION_PACKET_ID, (class_2540)buf);
            }
        });
    }

    private static void broadcastResetToNearbyPlayers(class_3222 sender) {
        double radius = 64.0;
        class_1937 world = sender.method_37908();
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(sender.method_5667());
        world.method_18456().forEach(player -> {
            class_3222 serverPlayer;
            if (player instanceof class_3222 && (serverPlayer = (class_3222)player) != sender && serverPlayer.method_5858((class_1297)sender) <= radius * radius) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)RESET_ANIMATION_PACKET_ID, (class_2540)buf);
            }
        });
    }

    public static void sendAnimationPacket(String animationName) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(class_310.method_1551().field_1724.method_5667());
        buf.method_10814(animationName);
        ClientPlayNetworking.send((class_2960)ANIMATION_PACKET_ID, (class_2540)buf);
    }

    public static void sendResetAnimationPacket() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(class_310.method_1551().field_1724.method_5667());
        ClientPlayNetworking.send((class_2960)RESET_ANIMATION_PACKET_ID, (class_2540)buf);
    }
}

