/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.simplysneak.client;

import com.saltywater.simplysneak.networking.SimplySneakNetworking;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class SimplySneakClient
implements ClientModInitializer {
    private static class_304 sneakKeyBinding;
    private boolean isSneaking = false;
    private KeyframeAnimationPlayer sneakAnimationPlayer;
    private static final float SNEAK_SPEED_MULTIPLIER = 0.05f;
    private class_2960 lastAnimationId;

    public void onInitializeClient() {
        System.out.println("[SimplySneak] Initializing client-side networking");
        SimplySneakNetworking.registerClientReceiver();
        SimplySneakNetworking.registerServerReceiver();
        sneakKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.simplysneak.toggle", 90, "category.simplysneak"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (sneakKeyBinding.method_1436()) {
                this.toggleSneakState(client);
            }
            if (this.isSneaking && client.field_1724 != null) {
                if (this.isPlayerMoving(client)) {
                    if (client.field_1724.field_6250 < 0.0f) {
                        this.triggerBackCreepWalkAnimation(client);
                    } else {
                        this.triggerCreepWalkAnimation(client);
                    }
                    this.applySneakingVelocity(client);
                } else {
                    this.triggerHidingAnimation(client);
                }
            }
        });
        WorldRenderEvents.START.register(context -> {
            class_310 client = class_310.method_1551();
            if (this.isSneaking) {
                Matrix4f matrix = context.matrixStack().method_23760().method_23761();
                matrix.translate(0.0f, 0.3f, 0.0f);
            }
        });
    }

    private void toggleSneakState(class_310 client) {
        this.isSneaking = !this.isSneaking;
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBoolean(this.isSneaking);
        SimplySneakNetworking.sendSneakingPacket(buf);
        if (client.field_1724 != null) {
            if (this.isSneaking) {
                System.out.println("[SimplySneak] Sneaking enabled");
                this.triggerHidingAnimation(client);
            } else {
                this.stopSneakAnimation(client);
                System.out.println("[SimplySneak] Sneaking disabled");
            }
        }
    }

    private void applySneakingVelocity(class_310 client) {
        if (client.field_1724 != null) {
            client.field_1724.method_18800(client.field_1724.method_18798().field_1352 * (double)0.05f, client.field_1724.method_18798().field_1351, client.field_1724.method_18798().field_1350 * (double)0.05f);
            client.field_1724.field_6037 = true;
        }
    }

    private void triggerHidingAnimation(class_310 client) {
        if (client.field_1724 != null) {
            class_746 player = client.field_1724;
            class_2960 animationId = new class_2960("simplysneak", "hiding");
            if (!animationId.equals((Object)this.lastAnimationId)) {
                this.stopSneakAnimation(client);
                KeyframeAnimation hidingAnimation = PlayerAnimationRegistry.getAnimation((class_2960)animationId);
                if (hidingAnimation != null) {
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
                    this.sneakAnimationPlayer = new KeyframeAnimationPlayer(hidingAnimation);
                    animationStack.addAnimLayer(0, (IAnimation)this.sneakAnimationPlayer);
                    SimplySneakNetworking.sendAnimationPacket(animationId.method_12832());
                    this.lastAnimationId = animationId;
                }
            }
        }
    }

    private void triggerCreepWalkAnimation(class_310 client) {
        if (client.field_1724 != null) {
            class_746 player = client.field_1724;
            class_2960 animationId = new class_2960("simplysneak", "creepwalk");
            if (!animationId.equals((Object)this.lastAnimationId)) {
                this.stopSneakAnimation(client);
                KeyframeAnimation creepWalkAnimation = PlayerAnimationRegistry.getAnimation((class_2960)animationId);
                if (creepWalkAnimation != null) {
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
                    this.sneakAnimationPlayer = new KeyframeAnimationPlayer(creepWalkAnimation);
                    animationStack.addAnimLayer(0, (IAnimation)this.sneakAnimationPlayer);
                    SimplySneakNetworking.sendAnimationPacket(animationId.method_12832());
                    this.lastAnimationId = animationId;
                }
            }
        }
    }

    private void triggerBackCreepWalkAnimation(class_310 client) {
        if (client.field_1724 != null) {
            class_746 player = client.field_1724;
            class_2960 animationId = new class_2960("simplysneak", "backcreepwalk");
            if (!animationId.equals((Object)this.lastAnimationId)) {
                this.stopSneakAnimation(client);
                KeyframeAnimation backCreepWalkAnimation = PlayerAnimationRegistry.getAnimation((class_2960)animationId);
                if (backCreepWalkAnimation != null) {
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
                    this.sneakAnimationPlayer = new KeyframeAnimationPlayer(backCreepWalkAnimation);
                    animationStack.addAnimLayer(0, (IAnimation)this.sneakAnimationPlayer);
                    SimplySneakNetworking.sendAnimationPacket(animationId.method_12832());
                    this.lastAnimationId = animationId;
                }
            }
        }
    }

    private void stopSneakAnimation(class_310 client) {
        if (client.field_1724 != null) {
            class_746 player = client.field_1724;
            AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
            if (this.sneakAnimationPlayer != null) {
                animationStack.removeLayer((IAnimation)this.sneakAnimationPlayer);
                this.sneakAnimationPlayer = null;
                this.lastAnimationId = null;
                SimplySneakNetworking.sendResetAnimationPacket();
            }
        }
    }

    private boolean isPlayerMoving(class_310 client) {
        return client.field_1724 != null && (client.field_1724.field_6250 != 0.0f || client.field_1724.field_6212 != 0.0f);
    }
}

