/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosinteractiveblocks;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class BlockActionListener {
    private static class_2338 lastBlockPos = null;

    public static void register() {
        BlockActionListener.registerLeftClickListener();
        BlockActionListener.registerRightClickListener();
        BlockActionListener.registerPlayerTickListener();
        BlockActionListener.registerRedstoneListener();
        BlockActionListener.registerBlockBreakListener();
    }

    public static void registerLeftClickListener() {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (!world.field_9236) {
                class_3222 serverPlayer = (class_3222)player;
                File blockFile = new File(((class_3218)world).method_8503().method_27728().method_150(), "BlockActions/" + pos.method_10263() + "_" + pos.method_10264() + "_" + pos.method_10260() + ".txt");
                if (blockFile.exists()) {
                    try {
                        List<String> lines = Files.readAllLines(blockFile.toPath(), StandardCharsets.UTF_8);
                        for (String line : lines) {
                            if (!line.contains("Action: L") || serverPlayer.method_5715()) continue;
                            String command = line.substring(line.indexOf("Command: ") + 9).trim();
                            command = command.replace("<player>", serverPlayer.method_5477().getString());
                            if (line.contains("Side: C")) {
                                serverPlayer.method_5682().method_3734().method_44252(serverPlayer.method_5671(), command);
                            } else if (line.contains("Side: S")) {
                                serverPlayer.method_5682().method_3734().method_44252(serverPlayer.method_5682().method_3739(), command);
                            }
                            return class_1269.field_5812;
                        }
                    }
                    catch (Exception e) {
                        return class_1269.field_5814;
                    }
                }
            }
            return class_1269.field_5811;
        });
    }

    public static void registerRightClickListener() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (!world.field_9236) {
                class_3222 serverPlayer = (class_3222)player;
                class_2338 pos = hitResult.method_17777();
                File blockFile = new File(((class_3218)world).method_8503().method_27728().method_150(), "BlockActions/" + pos.method_10263() + "_" + pos.method_10264() + "_" + pos.method_10260() + ".txt");
                if (blockFile.exists()) {
                    try {
                        List<String> lines = Files.readAllLines(blockFile.toPath(), StandardCharsets.UTF_8);
                        for (String line : lines) {
                            if (!line.contains("Action: R")) continue;
                            String command = line.substring(line.indexOf("Command: ") + 9).trim();
                            command = command.replace("<player>", serverPlayer.method_5477().getString());
                            if (line.contains("Side: C")) {
                                serverPlayer.method_5682().method_3734().method_44252(serverPlayer.method_5671(), command);
                            } else if (line.contains("Side: S")) {
                                serverPlayer.method_5682().method_3734().method_44252(serverPlayer.method_5682().method_3739(), command);
                            }
                            return class_1269.field_5812;
                        }
                    }
                    catch (Exception e) {
                        return class_1269.field_5814;
                    }
                }
            }
            return class_1269.field_5811;
        });
    }

    public static void registerBlockBreakListener() {
        ServerTickEvents.START_SERVER_TICK.register(server -> server.method_3760().method_14571().forEach(player -> {
            if (!player.method_37908().method_8608()) {
                class_3218 world = (class_3218)player.method_37908();
                world.method_18456().forEach(serverPlayer -> {
                    File blockFile;
                    class_2338 pos = serverPlayer.method_24515();
                    if (world.method_8320(pos).method_26215() && (blockFile = new File(world.method_8503().method_27728().method_150(), "BlockActions/" + pos.method_10263() + "_" + pos.method_10264() + "_" + pos.method_10260() + ".txt")).exists()) {
                        if (blockFile.delete()) {
                            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"The configuration for the block has been deleted.").method_27694(style -> style.method_10977(class_124.field_1061)), false);
                        } else {
                            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"Failed to delete the block configuration.").method_27694(style -> style.method_10977(class_124.field_1061)), false);
                        }
                    }
                });
            }
        }));
    }

    public static void registerRedstoneListener() {
        ServerTickEvents.START_SERVER_TICK.register(server -> server.method_3738().forEach(world -> world.method_18456().forEach(player -> {
            if (!world.field_9236) {
                class_2338 playerPos = player.method_24515();
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            File blockFile;
                            class_2338 pos = playerPos.method_10069(dx, dy, dz);
                            if (!world.method_49803(pos) || !(blockFile = new File(world.method_8503().method_27728().method_150(), "BlockActions/" + pos.method_10263() + "_" + pos.method_10264() + "_" + pos.method_10260() + ".txt")).exists()) continue;
                            try {
                                List<String> lines = Files.readAllLines(blockFile.toPath(), StandardCharsets.UTF_8);
                                for (String line : lines) {
                                    if (!line.contains("Action: S")) continue;
                                    String command = line.substring(line.indexOf("Command: ") + 9).trim();
                                    command = command.replace("<player>", player.method_5477().getString());
                                    if (line.contains("Side: C")) {
                                        player.method_5682().method_3734().method_44252(player.method_5671(), command);
                                        continue;
                                    }
                                    if (!line.contains("Side: S")) continue;
                                    player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), command);
                                }
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        })));
    }

    public static void registerPlayerTickListener() {
        ServerTickEvents.START_SERVER_TICK.register(server -> server.method_3760().method_14571().forEach(player -> {
            if (!player.method_37908().field_9236) {
                class_3222 serverPlayer = player;
                class_2338 currentBlockPos = new class_2338(serverPlayer.method_31477(), serverPlayer.method_31478() - 1, serverPlayer.method_31479());
                if (serverPlayer.method_24828()) {
                    if (lastBlockPos == null || !currentBlockPos.equals((Object)lastBlockPos)) {
                        class_3218 world = (class_3218)serverPlayer.method_37908();
                        File blockFile = new File(world.method_8503().method_27728().method_150(), "BlockActions/" + currentBlockPos.method_10263() + "_" + currentBlockPos.method_10264() + "_" + currentBlockPos.method_10260() + ".txt");
                        if (blockFile.exists()) {
                            try {
                                List<String> lines = Files.readAllLines(blockFile.toPath(), StandardCharsets.UTF_8);
                                for (String line : lines) {
                                    if (!line.contains("Action: T")) continue;
                                    String command = line.substring(line.indexOf("Command: ") + 9).trim();
                                    command = command.replace("<player>", serverPlayer.method_5477().getString());
                                    if (line.contains("Side: C")) {
                                        serverPlayer.method_5682().method_3734().method_44252(serverPlayer.method_5671(), command);
                                        continue;
                                    }
                                    if (!line.contains("Side: S")) continue;
                                    serverPlayer.method_5682().method_3734().method_44252(serverPlayer.method_5682().method_3739(), command);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        lastBlockPos = currentBlockPos;
                    }
                } else {
                    lastBlockPos = null;
                }
            }
        }));
    }
}

