/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosinteractiveblocks;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class BlockActionCommand {
    private static final Map<class_2338, File> blockActionCache = new HashMap<class_2338, File>();

    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> BlockActionCommand.register((CommandDispatcher<class_2168>)dispatcher));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blockaction").then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"side", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"S", "C"}, (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"R", "L", "T", "S"}, (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            try {
                return BlockActionCommand.createBlockAction((CommandContext<class_2168>)context);
            }
            catch (IOException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Failed to create block action: " + e.getMessage())));
                return 1;
            }
        })))))).then(class_2170.method_9247((String)"delete").executes(context -> {
            try {
                return BlockActionCommand.deleteBlockAction((CommandContext<class_2168>)context);
            }
            catch (IOException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Failed to delete block action: " + e.getMessage())));
                return 1;
            }
        }))).then(class_2170.method_9247((String)"info").executes(context -> {
            try {
                return BlockActionCommand.infoBlockAction((CommandContext<class_2168>)context);
            }
            catch (IOException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Failed to retrieve block action info: " + e.getMessage())));
                return 1;
            }
        })));
    }

    private static class_2338 getPlayerLookAtPos(class_3222 player) {
        class_239 hitResult = player.method_5745(20.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)hitResult;
            return blockHitResult.method_17777();
        }
        return null;
    }

    private static int createBlockAction(CommandContext<class_2168> context) throws IOException {
        File blockFile;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        class_2338 pos = BlockActionCommand.getPlayerLookAtPos(player);
        if (pos == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You are not looking at a block!"));
            return 1;
        }
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        String side = StringArgumentType.getString(context, (String)"side");
        String action = StringArgumentType.getString(context, (String)"action");
        String command = StringArgumentType.getString(context, (String)"command");
        File blockActionFolder = new File(world.method_8503().method_27728().method_150(), "BlockActions");
        if (!blockActionFolder.exists()) {
            blockActionFolder.mkdirs();
        }
        List<Object> lines = (blockFile = new File(blockActionFolder, pos.method_10263() + "_" + pos.method_10264() + "_" + pos.method_10260() + ".txt")).exists() ? Files.readAllLines(blockFile.toPath(), StandardCharsets.UTF_8) : new ArrayList();
        lines.add("Side: " + side + ", Action: " + action + ", Command: " + command);
        Files.write(blockFile.toPath(), lines, new OpenOption[0]);
        player.method_7353((class_2561)class_2561.method_43470((String)("Block action created at X: " + pos.method_10263() + ", Y: " + pos.method_10264() + ", Z: " + pos.method_10260() + ", Side: " + side + ", " + action + " with command: " + command)).method_27692(class_124.field_1060), false);
        blockActionCache.put(pos, blockFile);
        return 1;
    }

    private static int deleteBlockAction(CommandContext<class_2168> context) throws IOException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        class_2338 pos = BlockActionCommand.getPlayerLookAtPos(player);
        if (pos == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You are not looking at a block!"));
            return 1;
        }
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        File blockActionFolder = new File(world.method_8503().method_27728().method_150(), "BlockActions");
        File blockFile = new File(blockActionFolder, pos.method_10263() + "_" + pos.method_10264() + "_" + pos.method_10260() + ".txt");
        if (!blockFile.exists()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("BlockAction does not exist at " + pos.method_10263() + ", Y: " + pos.method_10264() + ", Z: " + pos.method_10260())));
            return 1;
        }
        Files.delete(blockFile.toPath());
        blockActionCache.remove(pos);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("BlockAction deleted at " + pos.method_10263() + ", Y: " + pos.method_10264() + ", Z: " + pos.method_10260())).method_27692(class_124.field_1061), true);
        return 1;
    }

    private static int infoBlockAction(CommandContext<class_2168> context) throws IOException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        class_2338 pos = BlockActionCommand.getPlayerLookAtPos(player);
        if (pos == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You are not looking at a block!"));
            return 1;
        }
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        File blockActionFolder = new File(world.method_8503().method_27728().method_150(), "BlockActions");
        File blockFile = new File(blockActionFolder, pos.method_10263() + "_" + pos.method_10264() + "_" + pos.method_10260() + ".txt");
        if (blockFile.exists()) {
            List<String> lines = Files.readAllLines(blockFile.toPath());
            for (String line : lines) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)line).method_27692(class_124.field_1075), true);
            }
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("BlockAction does not exist at " + pos.method_10263() + ", Y: " + pos.method_10264() + ", Z: " + pos.method_10260())));
        }
        return 1;
    }
}

