/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.network.packet;

import com.blackgear.platform.Platform;
import com.blackgear.platform.core.network.base.Packet;
import com.blackgear.platform.core.network.base.PacketContext;
import com.blackgear.platform.core.network.base.PacketHandler;
import com.blackgear.platform.core.util.config.ConfigLoader;
import com.blackgear.platform.core.util.config.ConfigTracker;
import com.blackgear.platform.core.util.config.ModConfig;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public record ConfigSyncPacket(String name, byte[] data) implements Packet<ConfigSyncPacket>
{
    public static final class_2960 ID = Platform.resource("config_sync");
    public static final Handler HANDLER = new Handler();

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public PacketHandler<ConfigSyncPacket> getHandler() {
        return HANDLER;
    }

    public static final class Handler
    implements PacketHandler<ConfigSyncPacket> {
        @Override
        public void encode(ConfigSyncPacket message, class_2540 buf) {
            buf.method_10814(message.name);
            buf.method_10813(message.data);
        }

        @Override
        public ConfigSyncPacket decode(class_2540 buf) {
            return new ConfigSyncPacket(buf.method_19772(), buf.method_10795());
        }

        @Override
        public PacketContext handle(ConfigSyncPacket message) {
            return (player, level) -> {
                ModConfig config = ConfigTracker.INSTANCE.fileMap().get(message.name);
                if (config != null) {
                    config.acceptSyncedConfig(message.data);
                } else {
                    ConfigLoader.LOGGER.error("Received config data for unknown config: {}", (Object)message.name);
                }
            };
        }
    }
}

