/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.wind.WindChunk;
import tictim.paraglider.wind.WindNode;

public final class Wind {
    private static final int XZ_RAD_HALF = 4;
    private static final int GROUND_Y_MIN = -2;
    private static final int GROUND_Y_MAX = 4;
    private static final int PARAGLIDING_Y_MIN = -11;
    private static final int PARAGLIDING_Y_MAX = 1;
    private static final Map<class_1936, Wind> windInstances = new Object2ObjectOpenHashMap();
    private final Long2ObjectMap<WindChunk> windChunks = new Long2ObjectOpenHashMap();
    private final LongSet dirtyWindChunks = new LongOpenHashSet();
    private final class_2338.class_2339 mpos = new class_2338.class_2339();
    @Nullable
    private WindChunk windChunkCache;

    public static void registerLevel(@NotNull class_1936 level) {
        windInstances.computeIfAbsent(level, l -> new Wind());
    }

    public static void unregisterLevel(@NotNull class_1936 level) {
        windInstances.remove(level);
    }

    @Nullable
    public static Wind of(@NotNull class_1936 level) {
        return windInstances.get(level);
    }

    private Wind() {
    }

    @NotNull
    public @NotNull @Unmodifiable Collection<@NotNull WindChunk> windChunks() {
        return Collections.unmodifiableCollection(this.windChunks.values());
    }

    @NotNull
    public LongSet dirtyWindChunks() {
        return this.dirtyWindChunks;
    }

    @Nullable
    public WindChunk getChunk(@NotNull class_1923 chunkPos) {
        return this.getChunk(chunkPos.field_9181, chunkPos.field_9180);
    }

    @Nullable
    public WindChunk getChunk(int chunkX, int chunkZ) {
        return this.getChunk(class_1923.method_8331((int)chunkX, (int)chunkZ));
    }

    @Nullable
    public WindChunk getChunk(long chunkPos) {
        return (WindChunk)this.windChunks.get(chunkPos);
    }

    @NotNull
    public WindChunk getOrCreate(@NotNull class_1923 chunkPos) {
        return this.getOrCreate(chunkPos.method_8324());
    }

    @NotNull
    public WindChunk getOrCreate(int chunkX, int chunkZ) {
        return this.getOrCreate(class_1923.method_8331((int)chunkX, (int)chunkZ));
    }

    @NotNull
    public WindChunk getOrCreate(long chunkPos) {
        return (WindChunk)this.windChunks.computeIfAbsent(chunkPos, cp -> new WindChunk(new class_1923(cp)));
    }

    @Nullable
    public WindChunk remove(int chunkX, int chunkZ) {
        return this.remove(class_1923.method_8331((int)chunkX, (int)chunkZ));
    }

    @Nullable
    public WindChunk remove(@NotNull class_1923 chunkPos) {
        return this.remove(chunkPos.method_8324());
    }

    @Nullable
    public WindChunk remove(long chunkPos) {
        WindChunk removed = (WindChunk)this.windChunks.remove(chunkPos);
        if (removed != null) {
            removed.setRemoved();
        }
        return removed;
    }

    public void put(@NotNull WindChunk windChunk) {
        if (windChunk.isRemoved()) {
            throw new IllegalArgumentException("Cannot add back a removed wind chunk!");
        }
        this.windChunks.put(windChunk.chunkPos.method_8324(), (Object)windChunk);
    }

    public void writeWind(int x, int y, int z, int height, long gameTime) {
        long chunkPos = class_1923.method_8331((int)class_4076.method_18675((int)x), (int)class_4076.method_18675((int)z));
        if (this.windChunkCache == null || this.windChunkCache.isRemoved() || this.windChunkCache.chunkPos.method_8324() != chunkPos) {
            this.windChunkCache = this.getOrCreate(chunkPos);
        }
        if (this.windChunkCache.add(x, y, z, height, gameTime)) {
            this.dirtyWindChunks().add(chunkPos);
        }
    }

    public void placeAround(@NotNull class_1657 player) {
        int x = class_3532.method_15357((double)player.method_23317());
        int y = class_3532.method_15357((double)player.method_23318());
        int z = class_3532.method_15357((double)player.method_23321());
        this.place(player.method_37908(), x - 4, y + (player.method_24828() ? -2 : -11), z - 4, x + 4, y + (player.method_24828() ? 4 : 1), z + 4);
    }

    private void place(@NotNull class_1937 level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                if (!level.method_8398().method_12123(class_4076.method_18675((int)x), class_4076.method_18675((int)z))) continue;
                boolean hasFireY = false;
                int fireY = 0;
                int y = minY;
                while (true) {
                    block9: {
                        boolean isWindSource;
                        block8: {
                            this.mpos.method_10103(x, y, z);
                            class_2680 state = level.method_8320((class_2338)this.mpos);
                            isWindSource = Cfg.get().isWindSource(state);
                            if (!hasFireY) break block8;
                            int height = y - fireY;
                            if (height < 10 && !isWindSource && !state.method_51366() && !class_2248.method_20044((class_4538)level, (class_2338)this.mpos, (class_2350)class_2350.field_11033) && !class_2248.method_20044((class_4538)level, (class_2338)this.mpos, (class_2350)class_2350.field_11036)) break block9;
                            if (height > 2) {
                                this.writeWind(x, fireY, z, height, level.method_8510());
                            }
                            hasFireY = false;
                        }
                        if (y > maxY) continue block1;
                        if (isWindSource) {
                            fireY = y;
                            hasFireY = true;
                        }
                    }
                    ++y;
                }
            }
        }
    }

    public void checkPlacedWind(@NotNull class_1937 level) {
        for (WindChunk windChunk : this.windChunks()) {
            Collection<WindNode> allRootNodes = windChunk.getAllRootNodes();
            for (WindNode node : allRootNodes.toArray(new WindNode[0])) {
                WindNode updated = this.validate(windChunk, node, level);
                if (updated == node) continue;
                if (updated == null) {
                    windChunk.removeAllNodesInXZ(node.x, node.z);
                    continue;
                }
                windChunk.putNode(updated);
            }
        }
    }

    @Nullable
    private WindNode validate(@NotNull WindChunk windChunk, @NotNull WindNode node, @NotNull class_1937 level) {
        long gameTime = level.method_8510();
        if (node.updatedTime != gameTime) {
            if (node.isExpired(gameTime) || !Cfg.get().isWindSource(level.method_8320((class_2338)this.mpos.method_10103(node.x, node.y, node.z)))) {
                this.dirtyWindChunks().add(windChunk.chunkPos.method_8324());
                return node.next != null ? this.validate(windChunk, node.next, level) : null;
            }
            node.updatedTime = gameTime;
        }
        if (node.next != null) {
            node.next = this.validate(windChunk, node.next, level);
        }
        return node;
    }

    public static boolean isInside(@NotNull class_1937 level, @NotNull class_238 boundingBox) {
        return Wind.isInside(level, class_3532.method_15357((double)boundingBox.field_1323), class_3532.method_15357((double)boundingBox.field_1322), class_3532.method_15357((double)boundingBox.field_1321), class_3532.method_15384((double)boundingBox.field_1320), class_3532.method_15384((double)boundingBox.field_1325), class_3532.method_15384((double)boundingBox.field_1324));
    }

    public static boolean isInside(@NotNull class_1937 level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Wind wind = Wind.of((class_1936)level);
        if (wind == null) {
            return false;
        }
        int chunkXStart = minX >> 4;
        int chunkXEnd = maxX >> 4;
        int chunkZStart = minZ >> 4;
        int chunkZEnd = maxZ >> 4;
        for (int x = chunkXStart; x <= chunkXEnd; ++x) {
            for (int z = chunkZStart; z <= chunkZEnd; ++z) {
                WindChunk windChunk = wind.getChunk(x, z);
                if (windChunk == null || !windChunk.isInsideWind(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                return true;
            }
        }
        return false;
    }
}

