/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.BargainResult;
import tictim.paraglider.bargain.BargainContext;
import tictim.paraglider.bargain.BargainHandler;
import tictim.paraglider.network.Kind;
import tictim.paraglider.network.ParagliderNetwork;
import tictim.paraglider.network.message.BargainEndMsg;
import tictim.paraglider.network.message.BargainMsg;
import tictim.paraglider.network.message.Msg;

public final class ServerPacketHandler {
    private ServerPacketHandler() {
    }

    public static void handleBargain(@NotNull class_3222 player, @NotNull BargainMsg msg) {
        class_2561 c;
        class_2960 advancement;
        ServerPacketHandler.trace(Kind.BARGAIN, player, msg);
        BargainContext ctx = BargainHandler.getBargain(player);
        if (ctx == null || ctx.sessionId() != msg.sessionId()) {
            return;
        }
        Bargain bargain = ctx.bargains().get(msg.bargain());
        if (bargain == null) {
            return;
        }
        BargainResult result = bargain.bargain((class_1657)player, false);
        if (result.isSuccess() && (advancement = ctx.advancement()) != null) {
            ParagliderUtils.giveAdvancement(player, advancement, "bargain");
        }
        class_2561 class_25612 = c = result.isSuccess() ? ctx.type().dialog().randomSuccessDialog(ParagliderUtils.DIALOG_RNG, bargain.getBargainTags()) : ctx.type().dialog().randomFailDialog(ParagliderUtils.DIALOG_RNG, bargain.getBargainTags(), result.failReasons());
        if (c != null) {
            ParagliderNetwork.get().displayBargainDialog(ctx, c);
        }
    }

    public static void handleBargainEnd(@NotNull class_3222 player, @NotNull BargainEndMsg msg) {
        ServerPacketHandler.trace(Kind.BARGAIN, player, msg);
        BargainContext ctx = BargainHandler.getBargain(player);
        if (ctx != null && ctx.sessionId() == msg.sessionId()) {
            ctx.markFinished();
        }
    }

    private static void trace(@NotNull Kind kind, @NotNull class_3222 player, @NotNull Msg msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Received {} from client {}", (Object)msg, (Object)player);
        }
    }
}

