/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.bargain.BargainCatalog;
import tictim.paraglider.bargain.BargainContext;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.network.Kind;
import tictim.paraglider.network.ParagliderNetwork;
import tictim.paraglider.network.message.BargainDialogMsg;
import tictim.paraglider.network.message.BargainEndMsg;
import tictim.paraglider.network.message.BargainInitMsg;
import tictim.paraglider.network.message.BargainMsg;
import tictim.paraglider.network.message.Msg;
import tictim.paraglider.network.message.SyncCatalogMsg;
import tictim.paraglider.network.message.SyncLookAtMsg;
import tictim.paraglider.network.message.SyncMovementMsg;
import tictim.paraglider.network.message.SyncPlayerStateMapMsg;
import tictim.paraglider.network.message.SyncRemoteMovementMsg;
import tictim.paraglider.network.message.SyncVesselMsg;
import tictim.paraglider.network.message.SyncWindMsg;
import tictim.paraglider.wind.WindChunk;

public abstract class ParagliderNetworkBase
implements ParagliderNetwork {
    @Override
    public void syncStateMap(@NotNull class_3222 player, @NotNull PlayerStateMap stateMap) {
        SyncPlayerStateMapMsg msg = new SyncPlayerStateMapMsg(stateMap);
        ParagliderNetworkBase.traceSendToPlayer(Kind.MOVEMENT, player, msg);
        this.sendToPlayer(player, msg);
    }

    protected abstract void sendToAll(@NotNull MinecraftServer var1, @NotNull Msg var2);

    protected abstract void sendToPlayer(@NotNull class_3222 var1, @NotNull Msg var2);

    protected abstract void sendToTracking(@NotNull MinecraftServer var1, @NotNull class_1297 var2, @NotNull Msg var3);

    protected abstract void sendToTracking(@NotNull MinecraftServer var1, @NotNull class_2818 var2, @NotNull Msg var3);

    protected abstract void sendToServer(@NotNull Msg var1);

    @Override
    public void syncStateMapToAll(@NotNull MinecraftServer server, @NotNull PlayerStateMap stateMap) {
        SyncPlayerStateMapMsg msg = new SyncPlayerStateMapMsg(stateMap);
        ParagliderNetworkBase.traceSendToAll(Kind.MOVEMENT, msg);
        this.sendToAll(server, msg);
    }

    @Override
    public void syncMovement(@NotNull class_3222 player, @NotNull class_2960 state, int stamina, boolean depleted, int recoveryDelay, double reductionRate) {
        SyncMovementMsg msg = new SyncMovementMsg(state, stamina, depleted, recoveryDelay, reductionRate);
        ParagliderNetworkBase.traceSendToPlayer(Kind.MOVEMENT, player, msg);
        this.sendToPlayer(player, msg);
        this.syncRemoteMovement(player.field_13995, (class_1297)player, state);
    }

    @Override
    public void syncRemoteMovement(@NotNull MinecraftServer server, @NotNull class_1297 entity, @NotNull class_2960 state) {
        SyncRemoteMovementMsg msg = new SyncRemoteMovementMsg(entity.method_5667(), state);
        ParagliderNetworkBase.traceSendToTracking(Kind.MOVEMENT, entity, (Msg)msg);
        this.sendToTracking(server, entity, (Msg)msg);
    }

    @Override
    public void syncRemoteMovement(@NotNull class_1297 entity, @NotNull class_3222 target, @NotNull class_2960 state) {
        SyncRemoteMovementMsg msg = new SyncRemoteMovementMsg(entity.method_5667(), state);
        ParagliderNetworkBase.traceSendToPlayer(Kind.MOVEMENT, target, msg);
        this.sendToPlayer(target, msg);
    }

    @Override
    public void syncVessels(@NotNull class_3222 player, int stamina, int heartContainers, int staminaVessels) {
        SyncVesselMsg msg = new SyncVesselMsg(stamina, heartContainers, staminaVessels);
        ParagliderNetworkBase.traceSendToPlayer(Kind.VESSEL, player, msg);
        this.sendToPlayer(player, msg);
    }

    @Override
    public void initBargain(@NotNull BargainContext ctx, @Nullable class_2561 dialog) {
        BargainInitMsg msg = new BargainInitMsg(ctx.sessionId(), ctx.makeCatalog(), ctx.lookAt(), dialog);
        ParagliderNetworkBase.traceSendToPlayer(Kind.BARGAIN, ctx.player(), msg);
        this.sendToPlayer(ctx.player(), msg);
    }

    @Override
    public void syncBargainCatalog(@NotNull BargainContext ctx, @NotNull Map<class_2960, BargainCatalog> catalog) {
        SyncCatalogMsg msg = new SyncCatalogMsg(ctx.sessionId(), catalog);
        ParagliderNetworkBase.traceSendToPlayer(Kind.BARGAIN, ctx.player(), msg);
        this.sendToPlayer(ctx.player(), msg);
    }

    @Override
    public void syncBargainLookAt(@NotNull BargainContext ctx, @Nullable class_243 lookAt) {
        SyncLookAtMsg msg = new SyncLookAtMsg(ctx.sessionId(), lookAt);
        ParagliderNetworkBase.traceSendToPlayer(Kind.BARGAIN, ctx.player(), msg);
        this.sendToPlayer(ctx.player(), msg);
    }

    @Override
    public void displayBargainDialog(@NotNull BargainContext ctx, @NotNull class_2561 dialog) {
        BargainDialogMsg msg = new BargainDialogMsg(ctx.sessionId(), dialog);
        ParagliderNetworkBase.traceSendToPlayer(Kind.BARGAIN, ctx.player(), msg);
        this.sendToPlayer(ctx.player(), msg);
    }

    @Override
    public void bargain(int sessionId, @NotNull class_2960 bargain) {
        BargainMsg msg = new BargainMsg(sessionId, bargain);
        ParagliderNetworkBase.traceSendToServer(Kind.BARGAIN, msg);
        this.sendToServer(msg);
    }

    @Override
    public void bargainEndToClient(@NotNull BargainContext ctx) {
        BargainEndMsg msg = new BargainEndMsg(ctx.sessionId());
        ParagliderNetworkBase.traceSendToPlayer(Kind.BARGAIN, ctx.player(), msg);
        this.sendToPlayer(ctx.player(), msg);
    }

    @Override
    public void bargainEndToServer(int sessionId) {
        BargainEndMsg msg = new BargainEndMsg(sessionId);
        ParagliderNetworkBase.traceSendToServer(Kind.BARGAIN, msg);
        this.sendToServer(msg);
    }

    @Override
    public void syncWind(@NotNull MinecraftServer server, @NotNull class_2818 chunk, @NotNull WindChunk windChunk) {
        SyncWindMsg msg = new SyncWindMsg(windChunk);
        ParagliderNetworkBase.traceSendToTracking(Kind.WIND, chunk, (Msg)msg);
        this.sendToTracking(server, chunk, (Msg)msg);
    }

    protected static void traceSendToAll(@NotNull Kind kind, @NotNull Msg msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Dispatching {} to clients", (Object)msg);
        }
    }

    protected static void traceSendToPlayer(@NotNull Kind kind, @NotNull class_3222 player, @NotNull Msg msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Dispatching {} to {}", (Object)msg, (Object)player);
        }
    }

    protected static void traceSendToTracking(@NotNull Kind kind, @NotNull class_1297 entity, @NotNull Msg msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Dispatching {} to clients tracking entity {}", (Object)msg, (Object)entity);
        }
    }

    protected static void traceSendToTracking(@NotNull Kind kind, @NotNull class_2818 chunk, @NotNull Msg msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Dispatching {} to clients tracking chunk {}", (Object)msg, (Object)chunk);
        }
    }

    protected static void traceSendToServer(@NotNull Kind kind, @NotNull Msg msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Dispatching {} to server", (Object)msg);
        }
    }
}

