/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.fabric.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.client.player.ClientPreAttackCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_5272;
import net.minecraft.class_6395;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.client.ParagliderClientSettings;
import tictim.paraglider.client.ParagliderItemColor;
import tictim.paraglider.client.ParagliderItemProperty;
import tictim.paraglider.client.render.InGameStaminaWheelRenderer;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.fabric.FabricParagliderMod;
import tictim.paraglider.fabric.FabricParagliderNetwork;
import tictim.paraglider.fabric.event.ParagliderClientEventHandler;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.wind.Wind;
import tictim.paraglider.wind.WindUtils;

public final class FabricParagliderClient
implements ClientModInitializer {
    private static FabricParagliderClient instance;
    private final ParagliderClientSettings clientSettings = new ParagliderClientSettings(FabricLoader.getInstance().getGameDir());
    @Nullable
    private class_304 settingsKey;
    @Nullable
    private PlayerStateMap syncedStateMap;

    @NotNull
    public static FabricParagliderClient get() {
        if (instance == null) {
            throw new IllegalStateException("Mod instance not ready yet");
        }
        return instance;
    }

    public FabricParagliderClient() {
        if (instance != null) {
            throw new IllegalStateException("Paraglider mod instantiated twice");
        }
        instance = this;
    }

    public void onInitializeClient() {
        FabricParagliderNetwork.clientInit();
        Contents contents = Contents.get();
        ColorProviderRegistry.ITEM.register((Object)new ParagliderItemColor(contents.paraglider()), (Object[])new class_1935[]{contents.paraglider()});
        ColorProviderRegistry.ITEM.register((Object)new ParagliderItemColor(contents.dekuLeaf()), (Object[])new class_1935[]{contents.dekuLeaf()});
        class_5272.method_27879((class_1792)Contents.get().paraglider(), (class_2960)ParagliderItemProperty.KEY_PARAGLIDING, (class_6395)ParagliderItemProperty.get());
        class_5272.method_27879((class_1792)Contents.get().dekuLeaf(), (class_2960)ParagliderItemProperty.KEY_PARAGLIDING, (class_6395)ParagliderItemProperty.get());
        this.settingsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.paraglider.paragliderSettings", 80, "key.categories.misc"));
        HudRenderCallback.EVENT.register((guiGraphics, delta) -> ParagliderClientEventHandler.renderHUD(guiGraphics));
        ClientPreAttackCallback.EVENT.register((mc, player, clickCount) -> ParagliderClientEventHandler.beforeAttack(player));
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((ctx, hitResult) -> ParagliderClientEventHandler.beforeBlockOutline());
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> InGameStaminaWheelRenderer.get().reset());
        ClientTickEvents.END_WORLD_TICK.register(level -> {
            Wind wind = Wind.of((class_1936)level);
            if (wind != null) {
                WindUtils.placeWindParticles((class_1937)level, wind);
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.syncedStateMap = null;
        });
    }

    @NotNull
    public ParagliderClientSettings getClientSettings() {
        return this.clientSettings;
    }

    public class_304 getParagliderSettingsKey() {
        if (this.settingsKey == null) {
            throw new IllegalStateException("Key not available yet");
        }
        return this.settingsKey;
    }

    @NotNull
    public PlayerStateMap getPlayerStateMap() {
        return this.syncedStateMap == null ? FabricParagliderMod.get().getLocalPlayerStateMap() : this.syncedStateMap;
    }

    public void setSyncedPlayerStateMap(@Nullable PlayerStateMap stateMap) {
        this.syncedStateMap = stateMap;
    }
}

