/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.config;

import net.minecraftforge.common.ForgeConfigSpec;
import tictim.paraglider.config.DebugCfg;
import tictim.paraglider.config.FeatureCfg;

public class CommonConfig
implements FeatureCfg,
DebugCfg {
    protected final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue enableSpiritOrbGens;
    private final ForgeConfigSpec.BooleanValue enableHeartContainers;
    private final ForgeConfigSpec.BooleanValue enableStaminaVessels;
    private final ForgeConfigSpec.BooleanValue enableStructures;
    private final ForgeConfigSpec.BooleanValue debugPlayerMovement;
    private final ForgeConfigSpec.BooleanValue traceMovementPacket;
    private final ForgeConfigSpec.BooleanValue traceVesselPacket;
    private final ForgeConfigSpec.BooleanValue traceBargainPacket;
    private final ForgeConfigSpec.BooleanValue traceWindPacket;

    public CommonConfig() {
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        common.comment("Easy to access switches to toggle side features on and off.\nMost of them requires server restart or datapack reload. All of them, actually.").push("features");
        this.enableSpiritOrbGens = common.comment("For those who wants to remove Spirit Orbs generated in the world, more specifically...\n  * Spirit Orbs generated in various chests\n  * Spirit Orbs dropped by spawners and such\nNote that bargain recipe for Heart Containers/Stamina Vessels will persist, even if this option is disabled.").define("spiritOrbGens", true);
        this.enableHeartContainers = common.comment("For those who wants to remove entirety of Heart Containers from the game, more specifically...\n  * Heart Containers obtained by \"challenges\" (i.e. Killing dragon, wither, raid)\n  * Bargains using Heart Containers (custom recipes won't be affected)\nNote that if this option is disabled while staminaVessels is enabled, \"challenges\" will drop stamina vessels instead.").define("heartContainers", true);
        this.enableStaminaVessels = common.comment("For those who wants to remove entirety of Stamina Vessels from the game, more specifically...\n  * Bargains using Stamina Vessels (custom recipes won't be affected)").define("staminaVessels", true);
        this.enableStructures = common.comment("For those who wants to remove all structures added by this mod. Requires restart.").define("structures", true);
        common.pop();
        common.push("debug");
        this.debugPlayerMovement = common.define("debugPlayerMovement", false);
        this.traceMovementPacket = common.define("traceMovementPacket", false);
        this.traceVesselPacket = common.define("traceVesselPacket", false);
        this.traceBargainPacket = common.define("traceBargainPacket", false);
        this.traceWindPacket = common.define("traceWindPacket", false);
        common.pop();
        this.spec = common.build();
    }

    @Override
    public boolean enableSpiritOrbGens() {
        return (Boolean)this.enableSpiritOrbGens.get();
    }

    @Override
    public boolean enableHeartContainers() {
        return (Boolean)this.enableHeartContainers.get();
    }

    @Override
    public boolean enableStaminaVessels() {
        return (Boolean)this.enableStaminaVessels.get();
    }

    @Override
    public boolean enableStructures() {
        return (Boolean)this.enableStructures.get();
    }

    @Override
    public boolean debugPlayerMovement() {
        return (Boolean)this.debugPlayerMovement.get();
    }

    @Override
    public boolean traceMovementPacket() {
        return (Boolean)this.traceMovementPacket.get();
    }

    @Override
    public boolean traceVesselPacket() {
        return (Boolean)this.traceVesselPacket.get();
    }

    @Override
    public boolean traceBargainPacket() {
        return (Boolean)this.traceBargainPacket.get();
    }

    @Override
    public boolean traceWindPacket() {
        return (Boolean)this.traceWindPacket.get();
    }
}

