/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.bargain.BargainContext;
import tictim.paraglider.bargain.BargainHandler;
import tictim.paraglider.config.PlayerStateMapConfig;
import tictim.paraglider.contents.BargainTypeRegistry;
import tictim.paraglider.impl.movement.PlayerStateMap;

public final class ParagliderCommands {
    private ParagliderCommands() {
    }

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"paraglider").then(ParagliderCommands.queryVessel())).then(ParagliderCommands.setVessel(SetType.set))).then(ParagliderCommands.setVessel(SetType.give))).then(ParagliderCommands.setVessel(SetType.take))).then(ParagliderCommands.bargain())).then(ParagliderCommands.reloadPlayerStates());
    }

    private static LiteralArgumentBuilder<class_2168> queryVessel() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"query").requires(s -> s.method_9259(1))).then(class_2170.method_9247((String)ResourceType.HEART.name).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> ResourceType.HEART.tell((class_2168)ctx.getSource(), (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(class_2170.method_9247((String)ResourceType.STAMINA.name).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> ResourceType.STAMINA.tell((class_2168)ctx.getSource(), (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(class_2170.method_9247((String)ResourceType.ESSENCE.name).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> ResourceType.ESSENCE.tell((class_2168)ctx.getSource(), (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player")))));
    }

    private static LiteralArgumentBuilder<class_2168> setVessel(@NotNull SetType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)type.name()).requires(s -> s.method_9259(2))).then(class_2170.method_9247((String)ResourceType.HEART.name).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ResourceType.HEART.run((class_2168)ctx.getSource(), (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), type)))))).then(class_2170.method_9247((String)ResourceType.STAMINA.name).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ResourceType.STAMINA.run((class_2168)ctx.getSource(), (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), type)))))).then(class_2170.method_9247((String)ResourceType.ESSENCE.name).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ResourceType.ESSENCE.run((class_2168)ctx.getSource(), (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), type)))));
    }

    private static LiteralArgumentBuilder<class_2168> bargain() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bargain").requires(s -> s.method_9259(2))).then(class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"bargainType", (ArgumentType)class_2232.method_9441()).executes(ctx -> ParagliderCommands.startBargain((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), class_2232.method_9443((CommandContext)ctx, (String)"bargainType"), null, null, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(ctx -> ParagliderCommands.startBargain((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), class_2232.method_9443((CommandContext)ctx, (String)"bargainType"), class_2262.method_48299((CommandContext)ctx, (String)"pos"), null, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"advancement", (ArgumentType)class_2232.method_9441()).executes(ctx -> ParagliderCommands.startBargain((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), class_2232.method_9443((CommandContext)ctx, (String)"bargainType"), class_2262.method_48299((CommandContext)ctx, (String)"pos"), class_2232.method_9443((CommandContext)ctx, (String)"advancement"), null))).then(class_2170.method_9244((String)"lookAt", (ArgumentType)class_2277.method_9737()).executes(ctx -> ParagliderCommands.startBargain((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), class_2232.method_9443((CommandContext)ctx, (String)"bargainType"), class_2262.method_48299((CommandContext)ctx, (String)"pos"), class_2232.method_9443((CommandContext)ctx, (String)"advancement"), class_2277.method_9736((CommandContext)ctx, (String)"lookAt")))))))))).then(class_2170.method_9247((String)"end").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> ParagliderCommands.endBargain((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player")))));
    }

    private static LiteralArgumentBuilder<class_2168> reloadPlayerStates() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reloadPlayerStates").requires(s -> s.method_9259(3))).executes(context -> ParagliderCommands.reloadPlayerStates((class_2168)context.getSource()));
    }

    private static int startBargain(@NotNull class_2168 source, @NotNull class_3222 player, @NotNull class_2960 bargainType, @Nullable class_2338 pos, @Nullable class_2960 advancement, @Nullable class_243 lookAt) {
        if (BargainTypeRegistry.get().getFromID(player.method_51469(), bargainType) == null) {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.paraglider.bargain.start.invalid_bargain_type", (Object[])new Object[]{bargainType}));
            return -1;
        }
        if (BargainHandler.initiate((class_1657)player, bargainType, pos, advancement, lookAt)) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.paraglider.bargain.start.success", (Object[])new Object[]{player.method_5476(), bargainType}), true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43469((String)"commands.paraglider.bargain.start.no_bargain", (Object[])new Object[]{player.method_5476(), bargainType, pos}));
        return 0;
    }

    private static int endBargain(@NotNull class_2168 source, @NotNull class_3222 player) {
        BargainContext bargain = BargainHandler.getBargain(player);
        if (bargain != null) {
            if (bargain.isFinished()) {
                source.method_9213((class_2561)class_2561.method_43469((String)"command.paraglider.bargain.end.already_finished", (Object[])new Object[]{player.method_5476()}));
                return 0;
            }
            source.method_9226(() -> class_2561.method_43469((String)"command.paraglider.bargain.end.success", (Object[])new Object[]{player.method_5476()}), true);
            bargain.markFinished();
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43469((String)"command.paraglider.bargain.end.no_bargain", (Object[])new Object[]{player.method_5476()}));
        return -1;
    }

    private static int reloadPlayerStates(final @NotNull class_2168 source) {
        MinecraftServer server = source.method_9211();
        ParagliderMod.instance().getPlayerStateMapConfig().scheduleReload(server, new PlayerStateMapConfig.Callback(){

            @Override
            public void onSuccess(@NotNull PlayerStateMap stateMap, boolean updated) {
                source.method_9226(() -> class_2561.method_43471((String)"commands.paraglider.reload_player_states.success"), true);
            }

            @Override
            public void onFail(@NotNull PlayerStateMap stateMap, @NotNull RuntimeException exception, boolean update) {
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.paraglider.reload_player_states.fail"));
            }
        });
        return 1;
    }

    private static enum SetType {
        set,
        give,
        take;

    }

    private static enum ResourceType {
        HEART("heart_container"),
        STAMINA("stamina_vessel"),
        ESSENCE("essence");

        private final String name;
        private final String getResult;
        private final String setSuccess;
        private final String setNoChange;
        private final String giveSuccess;
        private final String takeSuccess;
        private final String setTooHigh;
        private final String setTooLow;
        private final String setFail;
        private final String giveFail;
        private final String takeFail;

        private ResourceType(String name) {
            this.name = name;
            this.getResult = "commands.paraglider.get." + name + ".result";
            this.setSuccess = "commands.paraglider.set." + name + ".success";
            this.setNoChange = "commands.paraglider.set." + name + ".no_change";
            this.giveSuccess = "commands.paraglider.give." + name + ".success";
            this.takeSuccess = "commands.paraglider.take." + name + ".success";
            this.setTooHigh = "commands.paraglider.set." + name + ".too_high";
            this.setTooLow = "commands.paraglider.set." + name + ".too_low";
            this.setFail = "commands.paraglider.set." + name + ".fail";
            this.giveFail = "commands.paraglider.give." + name + ".fail";
            this.takeFail = "commands.paraglider.take." + name + ".fail";
        }

        private int tell(@NotNull class_2168 source, @NotNull class_1657 player) {
            VesselContainer vessels = VesselContainer.get(player);
            int value = switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEART -> vessels.heartContainer();
                case STAMINA -> vessels.staminaVessel();
                case ESSENCE -> vessels.essence();
            };
            source.method_9226(() -> class_2561.method_43469((String)this.getResult, (Object[])new Object[]{player.method_5476(), value}), false);
            return value;
        }

        private int run(@NotNull class_2168 source, @NotNull class_1657 player, int amount, @NotNull SetType type) {
            VesselContainer vessels = VesselContainer.get(player);
            switch (type) {
                case set: {
                    switch (this.set(vessels, amount, false, true)) {
                        case OK: {
                            source.method_9226(() -> class_2561.method_43469((String)this.setSuccess, (Object[])new Object[]{player.method_5476(), amount}), true);
                            return 1;
                        }
                        case NO_CHANGE: {
                            source.method_9226(() -> class_2561.method_43469((String)this.setNoChange, (Object[])new Object[]{player.method_5476(), amount}), true);
                            return 0;
                        }
                        case TOO_HIGH: {
                            source.method_9213((class_2561)class_2561.method_43469((String)this.setTooHigh, (Object[])new Object[]{amount}));
                            return -1;
                        }
                        case TOO_LOW: {
                            source.method_9213((class_2561)class_2561.method_43469((String)this.setTooLow, (Object[])new Object[]{amount}));
                            return -1;
                        }
                        case FAIL: {
                            source.method_9213((class_2561)class_2561.method_43471((String)this.setFail));
                            return -1;
                        }
                    }
                    break;
                }
                case give: {
                    if (this.give(vessels, amount, true, false) != amount) {
                        source.method_9213((class_2561)class_2561.method_43469((String)this.giveFail, (Object[])new Object[]{player.method_5476(), amount}));
                        return 0;
                    }
                    source.method_9226(() -> class_2561.method_43469((String)this.giveSuccess, (Object[])new Object[]{player.method_5476(), amount}), true);
                    return this.give(vessels, amount, false, true);
                }
                case take: {
                    if (this.take(vessels, amount, true, false) != amount) {
                        source.method_9213((class_2561)class_2561.method_43469((String)this.takeFail, (Object[])new Object[]{player.method_5476(), amount}));
                        return 0;
                    }
                    source.method_9226(() -> class_2561.method_43469((String)this.takeSuccess, (Object[])new Object[]{player.method_5476(), amount}), true);
                    return this.take(vessels, amount, false, true);
                }
            }
            throw new IllegalStateException("Unreachable");
        }

        @NotNull
        private VesselContainer.SetResult set(@NotNull VesselContainer vessels, int amount, boolean simulate, boolean playEffect) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEART -> vessels.setHeartContainer(amount, simulate, playEffect);
                case STAMINA -> vessels.setStaminaVessel(amount, simulate, playEffect);
                case ESSENCE -> vessels.setEssence(amount, simulate, playEffect);
            };
        }

        private int give(@NotNull VesselContainer vessels, int amount, boolean simulate, boolean playEffect) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEART -> vessels.giveHeartContainers(amount, simulate, playEffect);
                case STAMINA -> vessels.giveStaminaVessels(amount, simulate, playEffect);
                case ESSENCE -> vessels.giveEssences(amount, simulate, playEffect);
            };
        }

        private int take(@NotNull VesselContainer vessels, int amount, boolean simulate, boolean playEffect) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEART -> vessels.takeHeartContainers(amount, simulate, playEffect);
                case STAMINA -> vessels.takeStaminaVessels(amount, simulate, playEffect);
                case ESSENCE -> vessels.takeEssences(amount, simulate, playEffect);
            };
        }
    }
}

