/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import net.minecraft.class_1657;
import net.minecraft.class_5253;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.client.render.StaminaWheelConstants;
import tictim.paraglider.client.render.StaminaWheelRenderer;
import tictim.paraglider.config.Cfg;

public class BargainScreenStaminaWheelRenderer
extends StaminaWheelRenderer {
    private int internalStamina;
    private long lastUpdateTimestamp;
    private long timeSinceFull;
    private boolean gainedStamina;
    private boolean initialized;

    @Override
    protected void makeWheel(@NotNull class_1657 player, @NotNull StaminaWheelRenderer.Wheel wheel) {
        VesselContainer vessels = VesselContainer.get(player);
        int maxStamina = Cfg.get().maxStamina(vessels.staminaVessel());
        if (!this.initialized) {
            this.initialized = true;
            this.internalStamina = maxStamina;
            this.lastUpdateTimestamp = ParagliderUtils.ms();
        } else {
            long newTimestamp = ParagliderUtils.ms();
            long timePassed = newTimestamp - this.lastUpdateTimestamp;
            this.lastUpdateTimestamp = newTimestamp;
            if (this.internalStamina > maxStamina) {
                this.internalStamina = Math.max(this.internalStamina - this.getStaminaChange(timePassed), maxStamina);
                this.timeSinceFull = 0L;
                this.gainedStamina = false;
            } else if (this.internalStamina < maxStamina) {
                this.internalStamina = Math.min(this.internalStamina + this.getStaminaChange(timePassed), maxStamina);
                this.timeSinceFull = 0L;
                this.gainedStamina = true;
            } else if (this.timeSinceFull < 250L) {
                this.timeSinceFull += timePassed;
            }
        }
        if (this.internalStamina > maxStamina) {
            wheel.fill(0, maxStamina, StaminaWheelConstants.IDLE);
            wheel.fill(maxStamina, this.internalStamina, StaminaWheelConstants.EVIL_GLOW);
        } else if (this.internalStamina < maxStamina) {
            wheel.fill(0, this.internalStamina, StaminaWheelConstants.IDLE);
        } else if (this.gainedStamina && this.timeSinceFull < 250L) {
            int stamina = Cfg.get().maxStamina(vessels.staminaVessel() - 1);
            wheel.fill(0, stamina, StaminaWheelConstants.IDLE);
            wheel.fill(stamina, maxStamina, class_5253.class_5254.method_48780((float)((float)this.timeSinceFull / 250.0f), (int)StaminaWheelConstants.GLOW, (int)StaminaWheelConstants.IDLE));
        } else {
            wheel.fill(0, maxStamina, StaminaWheelConstants.IDLE);
        }
    }

    private int getStaminaChange(long timePassed) {
        return (int)((double)timePassed * 0.4);
    }
}

