/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.bargain;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1860;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.BargainType;
import tictim.paraglider.bargain.BargainContext;
import tictim.paraglider.contents.BargainTypeRegistry;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.network.ParagliderNetwork;

public final class BargainHandler {
    private static final Map<class_3222, BargainContext> bargains = new Object2ObjectOpenHashMap();
    private static int bargainSessionIncr;

    private BargainHandler() {
    }

    public static boolean initiate(@NotNull class_1657 player, @NotNull class_2960 bargainType, @Nullable class_2338 pos, @Nullable class_2960 advancement, @Nullable class_243 lookAt) {
        BargainContext ctx;
        BargainContext prevCtx;
        Objects.requireNonNull(player, "player == null");
        if (!(player instanceof class_3222)) {
            return false;
        }
        class_3222 serverPlayer = (class_3222)player;
        BargainType type = BargainTypeRegistry.get().getFromID(serverPlayer.method_51469(), Objects.requireNonNull(bargainType, "bargainType == null"));
        if (type == null) {
            return false;
        }
        Object2ObjectOpenHashMap bargains = player.method_37908().method_8433().method_30027(Contents.get().bargainRecipeType()).stream().filter(b -> bargainType.equals((Object)b.getBargainType()) && b.isAvailableFor(player, pos)).collect(Collectors.toMap(class_1860::method_8114, b -> b, (b1, b2) -> b1, Object2ObjectOpenHashMap::new));
        if (bargains.isEmpty()) {
            return false;
        }
        if ((prevCtx = BargainHandler.bargains.put(serverPlayer, ctx = new BargainContext(serverPlayer, bargainSessionIncr++, type, bargainType, (Map<class_2960, Bargain>)bargains, advancement, lookAt))) != null) {
            prevCtx.markFinished();
        }
        ParagliderNetwork.get().initBargain(ctx, type.dialog().randomInitialDialog(ParagliderUtils.DIALOG_RNG));
        return true;
    }

    @NotNull
    public static @NotNull @Unmodifiable Map<@NotNull class_3222, @NotNull BargainContext> bargains() {
        return Collections.unmodifiableMap(bargains);
    }

    @Nullable
    public static BargainContext getBargain(@NotNull class_3222 player) {
        return bargains.get(player);
    }

    @ApiStatus.Internal
    public static void update() {
        Iterator<BargainContext> it = bargains.values().iterator();
        while (it.hasNext()) {
            BargainContext ctx = it.next();
            if (ctx.isFinished()) {
                it.remove();
                ParagliderNetwork.get().bargainEndToClient(ctx);
                continue;
            }
            ctx.checkForUpdates();
            if (!ctx.isFinished()) continue;
            it.remove();
            ParagliderNetwork.get().bargainEndToClient(ctx);
        }
    }
}

