/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.bargain;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.BargainType;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.bargain.BargainCatalog;
import tictim.paraglider.network.ParagliderNetwork;

public final class BargainContext {
    private final class_3222 player;
    private final int sessionId;
    private final BargainType type;
    private final class_2960 typeId;
    private final Map<class_2960, Bargain> bargains;
    @Nullable
    private class_2960 advancement;
    @Nullable
    private class_243 lookAt;
    private int @Nullable [] inventoryHashes;
    private int heartContainerCache;
    private int staminaVesselCache;
    private int essenceCache;
    private boolean catalogRefreshScheduled;
    private boolean finished;

    public BargainContext(@NotNull class_3222 player, int sessionId, @NotNull BargainType type, @NotNull class_2960 typeId, @NotNull @NotNull Map<@NotNull class_2960, @NotNull Bargain> bargains, @Nullable class_2960 advancement, @Nullable class_243 lookAt) {
        this.player = Objects.requireNonNull(player);
        this.sessionId = sessionId;
        this.type = Objects.requireNonNull(type);
        this.typeId = Objects.requireNonNull(typeId);
        this.bargains = Objects.requireNonNull(bargains);
        this.advancement = advancement;
        this.lookAt = lookAt;
    }

    @NotNull
    public class_3222 player() {
        return this.player;
    }

    public int sessionId() {
        return this.sessionId;
    }

    @NotNull
    public BargainType type() {
        return this.type;
    }

    @NotNull
    public class_2960 typeId() {
        return this.typeId;
    }

    @NotNull
    public @NotNull @Unmodifiable Map<@NotNull class_2960, @NotNull Bargain> bargains() {
        return Collections.unmodifiableMap(this.bargains);
    }

    public boolean isFinished() {
        return this.finished;
    }

    @Nullable
    public class_2960 advancement() {
        return this.advancement;
    }

    @Nullable
    public class_243 lookAt() {
        return this.lookAt;
    }

    public void setAdvancement(@Nullable class_2960 advancement) {
        this.advancement = advancement;
    }

    public void setLookAt(@Nullable class_243 lookAt) {
        if (Objects.equals(this.lookAt, lookAt)) {
            return;
        }
        this.lookAt = lookAt;
        ParagliderNetwork.get().syncBargainLookAt(this, lookAt);
    }

    public void scheduleCatalogRefresh() {
        this.catalogRefreshScheduled = true;
    }

    public void markFinished() {
        this.finished = true;
    }

    public void checkForUpdates() {
        if (this.isFinished()) {
            return;
        }
        boolean refreshCatalog = false;
        if (this.catalogRefreshScheduled) {
            refreshCatalog = true;
            this.catalogRefreshScheduled = false;
        }
        if (this.inventoryHashes == null) {
            refreshCatalog = true;
            this.inventoryHashes = new int[this.player.method_31548().method_5439()];
        }
        for (int i = 0; i < this.inventoryHashes.length; ++i) {
            class_1799 stack = this.player.method_31548().method_5438(i);
            int hash = stack.method_7909().hashCode();
            hash = hash * 31 + stack.method_7947();
            if (this.inventoryHashes[i] == (hash = hash * 31 + Objects.hashCode(stack.method_7969()))) continue;
            refreshCatalog = true;
            this.inventoryHashes[i] = hash;
        }
        VesselContainer container = VesselContainer.get((class_1657)this.player);
        if (this.heartContainerCache != container.heartContainer()) {
            refreshCatalog = true;
            this.heartContainerCache = container.heartContainer();
        }
        if (this.staminaVesselCache != container.staminaVessel()) {
            refreshCatalog = true;
            this.staminaVesselCache = container.staminaVessel();
        }
        if (this.essenceCache != container.essence()) {
            refreshCatalog = true;
            this.essenceCache = container.essence();
        }
        if (refreshCatalog) {
            ParagliderNetwork.get().syncBargainCatalog(this, this.makeCatalog());
        }
    }

    @NotNull
    public @NotNull Map<@NotNull class_2960, @NotNull BargainCatalog> makeCatalog() {
        Object2ObjectOpenHashMap demands = new Object2ObjectOpenHashMap();
        for (Map.Entry<class_2960, Bargain> e : this.bargains.entrySet()) {
            Bargain bargain = e.getValue();
            demands.put(e.getKey(), new BargainCatalog(e.getKey(), bargain.previewDemands().stream().mapToInt(demandPreview -> demandPreview.count((class_1657)this.player)).toArray(), bargain.bargain((class_1657)this.player, true).isSuccess()));
        }
        return demands;
    }
}

