/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_2989;
import net.minecraft.class_304;
import net.minecraft.class_3222;
import net.minecraft.class_3675;
import net.minecraft.class_5134;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.bargain.preview.QuantifiedIngredient;
import tictim.paraglider.client.ParagliderClientSettings;
import tictim.paraglider.config.DebugCfg;
import tictim.paraglider.config.FeatureCfg;
import tictim.paraglider.contents.BargainTypeRegistry;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.fabric.ParagliderUtilsImpl;
import tictim.paraglider.impl.movement.ClientPlayerMovement;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.PlayerStateConnectionMap;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.impl.movement.RemotePlayerMovement;
import tictim.paraglider.impl.movement.ServerPlayerMovement;

public final class ParagliderUtils {
    public static final Random DIALOG_RNG = new Random();
    public static final Random PARTICLE_RNG = new Random();
    private static final UUID EXHAUSTION_ATTRIBUTE_UUID = UUID.fromString("65ed2ca4-ceb3-4521-8552-73006dcba58d");
    private static final double EXHAUSTION_AMOUNT = -0.3;
    private static final DecimalFormat PERCENTAGE = new DecimalFormat("#.#%");
    private static final DecimalFormat PERCENTAGE_SIGNED = new DecimalFormat("+#.#%;-#.#%");

    private ParagliderUtils() {
    }

    public static void giveItem(@NotNull class_1657 player, @NotNull class_1799 stack) {
        if (player.method_37908().field_9236) {
            return;
        }
        while (!stack.method_7960()) {
            int slot = player.method_31548().method_7390(stack);
            if (slot == -1) {
                slot = player.method_31548().method_7376();
            }
            if (slot == -1) {
                while (!stack.method_7960()) {
                    class_1542 itemEntity = new class_1542(player.method_37908(), player.method_23317(), player.method_23323(0.5), player.method_23321(), stack.method_7971(stack.method_7914()));
                    itemEntity.method_6982(40);
                    itemEntity.method_18800(0.0, 0.0, 0.0);
                    player.method_37908().method_8649((class_1297)itemEntity);
                }
                break;
            }
            int count = stack.method_7914() - player.method_31548().method_5438(slot).method_7947();
            if (!player.method_31548().method_7367(slot, stack.method_7971(count)) || !(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.field_13987.method_14364((class_2596)new class_2653(-2, 0, slot, player.method_31548().method_5438(slot)));
        }
    }

    @Nullable
    public static class_1792 getAppropriateVessel() {
        FeatureCfg cfg = FeatureCfg.get();
        return cfg.enableHeartContainers() ? Contents.get().heartContainer() : (cfg.enableStaminaVessels() ? Contents.get().staminaVessel() : null);
    }

    public static void addExhaustion(@NotNull class_1309 entity) {
        class_1324 attr = entity.method_5996(class_5134.field_23719);
        if (attr == null || attr.method_6199(EXHAUSTION_ATTRIBUTE_UUID) != null) {
            return;
        }
        attr.method_26835(new class_1322(EXHAUSTION_ATTRIBUTE_UUID, "Exhaustion", -0.3, class_1322.class_1323.field_6331));
    }

    public static void removeExhaustion(@NotNull class_1309 entity) {
        class_1324 attr = entity.method_5996(class_5134.field_23719);
        if (attr == null) {
            return;
        }
        attr.method_6200(EXHAUSTION_ATTRIBUTE_UUID);
    }

    public static boolean giveAdvancement(@NotNull class_3222 player, @NotNull class_2960 advancementName, @NotNull String criterion) {
        class_2985 advancements = player.method_14236();
        class_2989 advancementManager = player.field_13995.method_3851();
        class_161 advancement = advancementManager.method_12896(advancementName);
        return advancement != null && advancements.method_12878(advancement, criterion);
    }

    public static void damageItemWithoutBreaking(@NotNull class_1657 player, @NotNull class_1799 stack) {
        int prevCount = stack.method_7947();
        stack.method_7956(1, (class_1309)player, p -> p.method_20236(class_1268.field_5808));
        if (stack.method_7947() < prevCount) {
            stack.method_7939(prevCount);
            stack.method_7974(stack.method_7936());
        }
    }

    public static void checkBargainRecipes(@NotNull MinecraftServer server) {
        List recipes = server.method_3772().method_30027(Contents.get().bargainRecipeType());
        BargainTypeRegistry typeRegistry = BargainTypeRegistry.get();
        Object2ObjectAVLTreeMap missingBargainTypes = new Object2ObjectAVLTreeMap();
        int count = 0;
        for (Bargain b : recipes) {
            class_2960 bargainType = b.getBargainType();
            if (typeRegistry.getFromID(server, Objects.requireNonNull(bargainType)) != null) continue;
            missingBargainTypes.computeIfAbsent(bargainType, s -> new ArrayList()).add(Objects.requireNonNull(b.method_8114()));
            ++count;
        }
        if (count > 0) {
            ParagliderMod.LOGGER.error("Found {} issues in bargain recipes:\n  {}", (Object)count, (Object)missingBargainTypes.entrySet().stream().map(e -> "Cannot resolve bargain type " + e.getKey() + (((List)e.getValue()).size() == 1 ? " for bargain recipe " + ((List)e.getValue()).get(0) : " for bargain recipes " + ((List)e.getValue()).stream().map(Object::toString).collect(Collectors.joining(", ")))).collect(Collectors.joining("\n  ")));
        }
    }

    public static boolean calculateConsumption(@NotNull QuantifiedIngredient ingredient, @NotNull class_1263 inventory, @NotNull Int2IntOpenHashMap consumptions) {
        int amountLeft = ingredient.quantity();
        for (int i = 0; amountLeft > 0 && i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            int consumption = consumptions.get(i);
            if (consumption >= stack.method_7947() || !ingredient.test(stack)) continue;
            int amountToConsume = Math.min(amountLeft, stack.method_7947() - consumption);
            amountLeft -= amountToConsume;
            consumptions.put(i, consumption + amountToConsume);
        }
        return amountLeft <= 0;
    }

    public static void addDebugText(@NotNull class_1657 p, @NotNull List<String> list) {
        Movement movement = Movement.get(p);
        Stamina stamina = Stamina.get(p);
        VesselContainer vessels = VesselContainer.get(p);
        ParagliderClientSettings clientSettings = ParagliderClientSettings.get();
        PlayerState state = movement.state();
        int actualStaminaDelta = movement.getActualStaminaDelta();
        if (!list.isEmpty()) {
            list.add("");
        }
        if (state.flags().isEmpty()) {
            list.add("State: " + state.id());
        } else {
            list.add("State: " + state.id() + " (" + state.flags().stream().map(Object::toString).collect(Collectors.joining(" ")) + ")");
        }
        list.add((Serializable)(stamina.isDepleted() ? class_124.field_1061 : "") + "Stamina: " + stamina.stamina() + " / " + stamina.maxStamina());
        StringBuilder stb = new StringBuilder().append("Stamina Delta: ");
        if (state.staminaDelta() != actualStaminaDelta) {
            stb.append(state.staminaDelta());
            int diff = actualStaminaDelta - state.staminaDelta();
            if (diff > 0) {
                stb.append("+");
            }
            stb.append(diff);
        } else {
            stb.append(actualStaminaDelta);
        }
        double reductionRate = movement.staminaReductionRate();
        if (reductionRate != 0.0) {
            stb.append(" (").append(PERCENTAGE_SIGNED.format(reductionRate));
        }
        list.add(stb.toString());
        list.add("Recovery Delay: " + state.recoveryDelay());
        list.add(vessels.staminaVessel() + " Stamina Vessels, " + vessels.heartContainer() + " Heart Containers");
        list.add(movement.recoveryDelay() + " Recovery Delay");
        list.add("Stamina Wheel X: " + PERCENTAGE.format(clientSettings.staminaWheelX()) + ", Stamina Wheel Y: " + PERCENTAGE.format(clientSettings.staminaWheelY()));
    }

    public static long ms() {
        return System.nanoTime() / 1000000L;
    }

    @NotNull
    public static PlayerMovement createPlayerMovement(@NotNull class_1657 player) {
        PlayerMovement playerMovement;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            playerMovement = new ServerPlayerMovement(serverPlayer);
        } else {
            playerMovement = ParagliderUtils.isClient() ? ClientImpl.createPlayerMovement(player) : new RemotePlayerMovement(player);
        }
        return playerMovement;
    }

    public static void printPlayerStates(@NotNull PlayerStateMap stateMap, @NotNull PlayerStateConnectionMap connectionMap) {
        if (!DebugCfg.get().debugPlayerMovement()) {
            return;
        }
        ParagliderMod.LOGGER.debug("All Player States: " + stateMap.states().size() + " entries" + stateMap.states().values().stream().map(s -> "\n  " + s.id() + " : staminaDelta=" + s.staminaDelta() + ", recoveryDelay=" + s.recoveryDelay() + (String)(s.flags().isEmpty() ? "" : ", flags=[" + s.flags().stream().map(f -> f.toString()).collect(Collectors.joining(", ")) + "]")).collect(Collectors.joining()));
        StringBuilder stb = new StringBuilder("All Player State Connections: ").append(connectionMap.connections().size()).append(" entries");
        for (Map.Entry<class_2960, PlayerStateConnectionMap.ConnectionList> e : connectionMap.connections().entrySet()) {
            stb.append("\n  ").append(e.getKey());
            for (PlayerStateConnectionMap.Branch branch : e.getValue().branches()) {
                stb.append("\n    -> ").append(branch.state());
            }
            if (e.getValue().fallback() != null) {
                stb.append("\n    fallback: ").append(e.getValue().fallback());
            }
            stb.append('\n');
        }
        ParagliderMod.LOGGER.debug(stb.toString());
    }

    public static int applyReductionToDelta(int staminaDelta, double reduction) {
        if (staminaDelta == 0) {
            return 0;
        }
        if (Double.isNaN(reduction) || reduction == 0.0) {
            return staminaDelta;
        }
        if (staminaDelta > 0) {
            if (reduction <= -1.0) {
                return 0;
            }
            return Math.max(1, (int)Math.round((double)staminaDelta + (double)staminaDelta * reduction));
        }
        if (reduction >= 1.0) {
            return 0;
        }
        return Math.min(-1, (int)Math.round((double)staminaDelta - (double)staminaDelta * reduction));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canBreatheUnderwater(@NotNull class_1657 player) {
        return ParagliderUtilsImpl.canBreatheUnderwater(player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasTag(@NotNull class_2248 block, @NotNull class_6862<class_2248> tagKey) {
        void var1_1;
        return ParagliderUtilsImpl.hasTag(block, (class_6862<class_2248>)var1_1);
    }

    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static class_1792 getItem(@NotNull class_2960 id) {
        return ParagliderUtilsImpl.getItem(id);
    }

    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static class_2960 getKey(@NotNull class_1792 item) {
        return ParagliderUtilsImpl.getKey(item);
    }

    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static class_2248 getBlock(@NotNull class_2960 id) {
        return ParagliderUtilsImpl.getBlock(id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void forRemainingItem(@NotNull class_1799 stack, @NotNull @NotNull Consumer<@NotNull class_1799> forRemainingItem) {
        void var1_1;
        ParagliderUtilsImpl.forRemainingItem(stack, (Consumer<class_1799>)var1_1);
    }

    @ExpectPlatform
    @Environment(value=EnvType.CLIENT)
    @NotNull
    @ExpectPlatform.Transformed
    public static class_3675.class_306 getKey(@NotNull class_304 keyMapping) {
        return ParagliderUtilsImpl.getKey(keyMapping);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @Environment(value=EnvType.CLIENT)
    @ExpectPlatform.Transformed
    public static boolean isActiveAndMatches(@NotNull class_304 keyMapping, @NotNull class_3675.class_306 key) {
        void var1_1;
        return ParagliderUtilsImpl.isActiveAndMatches(keyMapping, (class_3675.class_306)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean isClient() {
        return ParagliderUtilsImpl.isClient();
    }

    private static final class ClientImpl {
        private ClientImpl() {
        }

        @NotNull
        static PlayerMovement createPlayerMovement(@NotNull class_1657 player) {
            RemotePlayerMovement remotePlayerMovement;
            if (player instanceof class_746) {
                class_746 localPlayer = (class_746)player;
                remotePlayerMovement = new ClientPlayerMovement(localPlayer);
            } else {
                remotePlayerMovement = new RemotePlayerMovement(player);
            }
            return remotePlayerMovement;
        }
    }
}

