/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.mixin.DrawContextAccessor;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;

public class OriginDisplayScreen
extends class_437 {
    private static final class_2960 WINDOW = new class_2960("origins", "textures/gui/choose_origin.png");
    private Origin origin;
    private OriginLayer layer;
    private boolean isOriginRandom;
    private class_2561 randomOriginText;
    protected static final int windowWidth = 176;
    protected static final int windowHeight = 182;
    protected int scrollPos = 0;
    private int currentMaxScroll = 0;
    private float time = 0.0f;
    protected int guiTop;
    protected int guiLeft;
    protected final boolean showDirtBackground;
    private final LinkedList<RenderedBadge> renderedBadges = new LinkedList();
    private boolean scrolling = false;
    private int scrollDragStart = 0;
    private double mouseDragStart = 0.0;

    public OriginDisplayScreen(class_2561 title, boolean showDirtBackground) {
        super(title);
        this.showDirtBackground = showDirtBackground;
    }

    public void showOrigin(Origin origin, OriginLayer layer, boolean isRandom) {
        this.origin = origin;
        this.layer = layer;
        this.isOriginRandom = isRandom;
        this.scrollPos = 0;
        this.time = 0.0f;
    }

    public void setRandomOriginText(class_2561 text) {
        this.randomOriginText = text;
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = (this.field_22789 - 176) / 2;
        this.guiTop = (this.field_22790 - 182) / 2;
    }

    public Origin getCurrentOrigin() {
        return this.origin;
    }

    public OriginLayer getCurrentLayer() {
        return this.layer;
    }

    public void method_25420(class_332 context) {
        if (this.showDirtBackground) {
            super.method_25434(context);
        } else {
            super.method_25420(context);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderedBadges.clear();
        this.time += delta;
        this.method_25420(context);
        this.renderOriginWindow(context, mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.origin != null) {
            this.renderScrollbar(context, mouseX, mouseY);
            this.renderBadgeTooltip(context, mouseX, mouseY);
        }
    }

    private void renderScrollbar(class_332 context, int mouseX, int mouseY) {
        if (!this.canScroll()) {
            return;
        }
        context.method_25302(WINDOW, this.guiLeft + 155, this.guiTop + 35, 188, 24, 8, 134);
        int scrollbarY = 36;
        int maxScrollbarOffset = 141;
        int u = 176;
        float part = (float)this.scrollPos / (float)this.currentMaxScroll;
        scrollbarY = (int)((float)scrollbarY + (float)(maxScrollbarOffset - scrollbarY) * part);
        if (this.scrolling) {
            u += 6;
        } else if (mouseX >= this.guiLeft + 156 && mouseX < this.guiLeft + 156 + 6 && mouseY >= this.guiTop + scrollbarY && mouseY < this.guiTop + scrollbarY + 27) {
            u += 6;
        }
        context.method_25302(WINDOW, this.guiLeft + 156, this.guiTop + scrollbarY, u, 24, 6, 27);
    }

    private boolean canScroll() {
        return this.origin != null && this.currentMaxScroll > 0;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.canScroll()) {
            this.scrolling = false;
            int scrollbarY = 36;
            int maxScrollbarOffset = 141;
            float part = (float)this.scrollPos / (float)this.currentMaxScroll;
            scrollbarY = (int)((float)scrollbarY + (float)(maxScrollbarOffset - scrollbarY) * part);
            if (mouseX >= (double)(this.guiLeft + 156) && mouseX < (double)(this.guiLeft + 156 + 6) && mouseY >= (double)(this.guiTop + scrollbarY) && mouseY < (double)(this.guiTop + scrollbarY + 27)) {
                this.scrolling = true;
                this.scrollDragStart = scrollbarY;
                this.mouseDragStart = mouseY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int delta = (int)(mouseY - this.mouseDragStart);
            int newScrollPos = Math.max(36, Math.min(141, this.scrollDragStart + delta));
            float part = (float)(newScrollPos - 36) / 105.0f;
            this.scrollPos = (int)(part * (float)this.currentMaxScroll);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void renderBadgeTooltip(class_332 context, int mouseX, int mouseY) {
        for (RenderedBadge rb : this.renderedBadges) {
            if (mouseX < rb.x || mouseX >= rb.x + 9 || mouseY < rb.y || mouseY >= rb.y + 9 || !rb.hasTooltip()) continue;
            int widthLimit = this.field_22789 - mouseX - 24;
            ((DrawContextAccessor)context).invokeDrawTooltip(this.field_22793, rb.getTooltipComponents(this.field_22793, widthLimit), mouseX, mouseY, class_8001.field_41687);
        }
    }

    protected class_2561 getTitleText() {
        return class_2561.method_30163((String)"Origins");
    }

    private void renderOriginWindow(class_332 context, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        this.renderWindowBackground(context, 16, 0);
        if (this.origin != null) {
            this.renderOriginContent(context, mouseX, mouseY);
        }
        context.method_25291(WINDOW, this.guiLeft, this.guiTop, 1, 0.0f, 0.0f, 176, 182, 256, 256);
        if (this.origin != null) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 5.0f);
            this.renderOriginName(context);
            RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW);
            this.renderOriginImpact(context, mouseX, mouseY);
            context.method_51448().method_22909();
            class_2561 title = this.getTitleText();
            context.method_25300(this.field_22793, title.getString(), this.field_22789 / 2, this.guiTop - 15, 0xFFFFFF);
        }
        RenderSystem.disableBlend();
    }

    private void renderOriginImpact(class_332 context, int mouseX, int mouseY) {
        Impact impact = this.getCurrentOrigin().getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for (int i = 0; i < 3; ++i) {
            if (i < impactValue) {
                context.method_25302(WINDOW, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176 + wOffset, 16, 8, 8);
                continue;
            }
            context.method_25302(WINDOW, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176, 16, 8, 8);
        }
        if (mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27) {
            class_5250 ttc = class_2561.method_43471((String)"origins.gui.impact.impact").method_27693(": ").method_10852((class_2561)impact.getTextComponent());
            context.method_51438(this.field_22793, (class_2561)ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(class_332 context) {
        class_5348 originName = this.field_22793.method_1714((class_5348)this.getCurrentOrigin().getName(), 140);
        context.method_25303(this.field_22793, originName.getString(), this.guiLeft + 39, this.guiTop + 19, 0xFFFFFF);
        class_1799 is = this.getCurrentOrigin().getDisplayItem();
        context.method_51427(is, this.guiLeft + 15, this.guiTop + 15);
    }

    private void renderWindowBackground(class_332 context, int offsetYStart, int offsetYEnd) {
        int border = 13;
        int endX = this.guiLeft + 176 - border;
        int endY = this.guiTop + 182 - border;
        for (int x = this.guiLeft; x < endX; x += 16) {
            for (int y = this.guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                context.method_25302(WINDOW, x, y, 176, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    public boolean method_25401(double x, double y, double z) {
        boolean retValue = super.method_25401(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(class_332 context, int mouseX, int mouseY) {
        int y;
        int textWidth = 128;
        Origin origin = this.getCurrentOrigin();
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        class_5250 orgDesc = origin.getDescription();
        List descLines = this.field_22793.method_1728((class_5348)orgDesc, textWidth);
        for (class_5481 class_54812 : descLines) {
            if (y >= startY - 18 && y <= endY + 12) {
                context.method_51430(this.field_22793, class_54812, x + 2, y - 6, 0xCCCCCC, false);
            }
            y += 12;
        }
        if (this.isOriginRandom) {
            List drawLines = this.field_22793.method_1728((class_5348)this.randomOriginText, textWidth);
            for (class_5481 line : drawLines) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                context.method_51430(this.field_22793, line, x + 2, y, 0xCCCCCC, false);
            }
            y += 14;
        } else {
            for (PowerType powerType : origin.getPowerTypes()) {
                if (powerType.isHidden()) continue;
                class_5481 name = class_2477.method_10517().method_30934(this.field_22793.method_1714((class_5348)powerType.getName().method_27692(class_124.field_1073), textWidth));
                class_5250 desc = powerType.getDescription();
                List drawLines = this.field_22793.method_1728((class_5348)desc, textWidth);
                if (y >= startY - 24 && y <= endY + 12) {
                    context.method_51430(this.field_22793, name, x, y, 0xFFFFFF, false);
                    int tw = this.field_22793.method_30880(name);
                    List<Badge> badges = BadgeManager.getPowerBadges(powerType.getIdentifier());
                    int xStart = x + tw + 4;
                    int bi = 0;
                    for (Badge badge : badges) {
                        RenderedBadge renderedBadge = new RenderedBadge(powerType, badge, xStart + 10 * bi, y - 1);
                        this.renderedBadges.add(renderedBadge);
                        context.method_25290(badge.spriteId(), xStart + 10 * bi, y - 1, 0.0f, 0.0f, 9, 9, 9, 9);
                        ++bi;
                    }
                }
                for (class_5481 line : drawLines) {
                    if ((y += 12) < startY - 24 || y > endY + 12) continue;
                    context.method_51430(this.field_22793, line, x + 2, y, 0xCCCCCC, false);
                }
                y += 14;
            }
        }
        this.currentMaxScroll = (y += this.scrollPos) - 14 - (this.guiTop + 158);
        if (this.currentMaxScroll < 0) {
            this.currentMaxScroll = 0;
        }
    }

    private class RenderedBadge {
        private final PowerType<?> powerType;
        private final Badge badge;
        private final int x;
        private final int y;

        public RenderedBadge(PowerType<?> powerType, Badge badge, int x, int y) {
            this.powerType = powerType;
            this.badge = badge;
            this.x = x;
            this.y = y;
        }

        public boolean hasTooltip() {
            return this.badge.hasTooltip();
        }

        public List<class_5684> getTooltipComponents(class_327 textRenderer, int widthLimit) {
            return this.badge.getTooltipComponents(this.powerType, widthLimit, OriginDisplayScreen.this.time, textRenderer);
        }
    }
}

