/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.hekate;

import com.obscuria.obscureapi.api.hekate.Animation;
import com.obscuria.obscureapi.api.hekate.Easing;
import com.obscuria.obscureapi.api.hekate.EasingFunction;
import com.obscuria.obscureapi.api.tools.ExceptionFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_630;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

@Environment(value=EnvType.CLIENT)
public final class HekateLib {
    public static float getPoint(Animation HAnimation, EasingFunction easingFunction, float partialTicks) {
        return easingFunction.get(HAnimation.getProgress(partialTicks));
    }

    public static float getPoint(int tick, int duration, EasingFunction easingFunction, float partialTicks) {
        return duration == 0 ? 0.0f : ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(easingFunction.get(((float)tick + partialTicks) / (float)duration))).floatValue();
    }

    public static float getPoint(Animation HAnimation, int split, EasingFunction in, EasingFunction out, float partialTicks) {
        return HekateLib.getPoint(HAnimation.getTick(), split, HAnimation.getDuration(), in, out, partialTicks);
    }

    public static float getPoint(int tick, int split, int duration, EasingFunction in, EasingFunction out, float partialTicks) {
        if (tick < split) {
            return HekateLib.getPoint(tick, split, in, partialTicks);
        }
        return HekateLib.getPoint(duration - split - tick, duration - split, out, partialTicks);
    }

    public static float getPoint(int tick, int s1, int s2, int duration, EasingFunction in, EasingFunction out, float partialTicks) {
        if (tick < s1) {
            return HekateLib.getPoint(tick, s1, in, partialTicks);
        }
        if (tick <= s2) {
            return HekateLib.getPoint(1, 1, Easing.FLOOR, partialTicks);
        }
        return HekateLib.getPoint(duration - s2 - tick, duration - s2, out, partialTicks);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static Builder push(float timer, float speed, float mod2, Mode mode) {
        return new Builder(timer, speed, mod2, mode);
    }

    @Contract(value="_, _, _, _ -> new")
    public static AnimationBuilder push(int fadeInTick, int fadeOutTick, EasingFunction fadeIn, EasingFunction fadeOut) {
        return new AnimationBuilder(fadeInTick, fadeOutTick, fadeIn, fadeOut);
    }

    public static void reset(class_630 ... parts) {
        for (class_630 part : parts) {
            part.method_33425(0.0f, 0.0f, 0.0f);
            part.field_37938 = 1.0f;
            part.field_37939 = 1.0f;
            part.field_37940 = 1.0f;
        }
    }

    public static float getPartialTicks() {
        return class_310.method_1551().method_1488();
    }

    public static class Builder {
        private final float TIMER;
        private final float SPEED;
        private final float MOD;
        private final Mode MODE;

        private Builder(float timer, float speed, float mod2, Mode mode) {
            this.SPEED = speed;
            this.MOD = mod2;
            this.TIMER = timer;
            this.MODE = mode;
        }

        public Builder keyframe(class_630 part, Consumer<KeyFrame> animation) {
            animation.accept(new KeyFrame(this, part));
            return this;
        }
    }

    public static enum Mode {
        DEFINITION((old, swing, base, speed, mod2, offset, timer) -> (float)Math.toRadians((double)(swing * mod2) * Math.cos(timer * speed + offset * 6.283f) + (double)(base * mod2)), (old, swing, base, speed, mod2, offset, timer) -> swing * mod2 * (float)Math.cos(timer * speed + offset * 6.283f) + base * mod2),
        SUPPRESSION((old, swing, base, speed, mod2, offset, timer) -> old * (1.0f - mod2) + (float)Math.toRadians((double)(swing * mod2) * Math.cos(timer * speed + offset * 6.283f) + (double)(base * mod2)), (old, swing, base, speed, mod2, offset, timer) -> old * (1.0f - mod2) + (swing * mod2 * (float)Math.cos(timer * speed + offset * 6.283f) + base * mod2)),
        ADDITION((old, swing, base, speed, mod2, offset, timer) -> old + (float)Math.toRadians((double)(swing * mod2) * Math.cos(timer * speed + offset * 6.283f) + (double)(base * mod2)), (old, swing, base, speed, mod2, offset, timer) -> old + (swing * mod2 * (float)Math.cos(timer * speed + offset * 6.283f) + base * mod2)),
        TRANSLATION((old, swing, base, speed, mod2, offset, timer) -> old + ((float)Math.toRadians((double)swing * Math.cos(timer * speed + offset * 6.283f) + (double)base) - old) * mod2, (old, swing, base, speed, mod2, offset, timer) -> old + (swing * (float)Math.cos(timer * speed + offset * 6.283f) + base - old) * mod2);

        private final Function ROTATION_FUNCTION;
        private final Function SCALE_FUNCTION;

        private Mode(Function rotationFunction, Function scaleFunction) {
            this.ROTATION_FUNCTION = rotationFunction;
            this.SCALE_FUNCTION = scaleFunction;
        }

        private float acceptRotation(float old, float swing, float base, float speed, float mod2, float offset, float timer) {
            return this.ROTATION_FUNCTION.accept(old, swing, base, speed, mod2, offset, timer);
        }

        private float acceptScale(float old, float swing, float base, float speed, float mod2, float offset, float timer) {
            return this.SCALE_FUNCTION.accept(old, swing, base, speed, mod2, offset, timer);
        }

        @FunctionalInterface
        private static interface Function {
            public float accept(float var1, float var2, float var3, float var4, float var5, float var6, float var7);
        }
    }

    public static class AnimationBuilder {
        private final List<Pair<Entry, Consumer<Builder>>> POSES = new ArrayList<Pair<Entry, Consumer<Builder>>>();
        private final int FADE_IN_TICK;
        private final int FADE_OUT_TICK;
        private final EasingFunction FADE_IN;
        private final EasingFunction FADE_OUT;

        private AnimationBuilder(int fadeInTick, int fadeOutTick, EasingFunction fadeIn, EasingFunction fadeOut) {
            this.FADE_IN_TICK = fadeInTick;
            this.FADE_OUT_TICK = fadeOutTick;
            this.FADE_IN = fadeIn;
            this.FADE_OUT = fadeOut;
        }

        public AnimationBuilder pose(int start, int end, EasingFunction easing, float timer, float speed, Consumer<Builder> animation) {
            this.POSES.add((Pair<Entry, Consumer<Builder>>)new Pair((Object)new Entry(start, end, easing, timer, speed), animation));
            return this;
        }

        public void animate(Animation animation) {
            this.animate(animation, HekateLib.getPartialTicks());
        }

        public void animate(Animation animation, float partialTicks) {
            if (animation == null || !animation.isPlaying()) {
                return;
            }
            int tick = animation.getTick();
            float mod2 = tick < this.FADE_IN_TICK ? HekateLib.getPoint(tick, this.FADE_IN_TICK, this.FADE_IN, partialTicks) : (tick < animation.getDuration() - this.FADE_OUT_TICK ? 1.0f : 1.0f - HekateLib.getPoint(tick - (animation.getDuration() - this.FADE_OUT_TICK), this.FADE_OUT_TICK, this.FADE_OUT, partialTicks));
            Entry lastEntry = null;
            Consumer lastAnim = null;
            for (Pair<Entry, Consumer<Builder>> pair : this.POSES) {
                Entry entry = (Entry)pair.getA();
                Consumer anim = (Consumer)pair.getB();
                if (tick >= entry.START && tick < entry.END) {
                    if (lastEntry != null) {
                        lastAnim.accept(new Builder(lastEntry.TIMER, lastEntry.SPEED, lastEntry.easing.get(1.0f) * mod2, Mode.SUPPRESSION));
                    }
                    anim.accept(new Builder(entry.TIMER, entry.SPEED, HekateLib.getPoint(tick - entry.START, entry.END - entry.START, entry.easing, partialTicks) * mod2, Mode.TRANSLATION));
                }
                lastEntry = entry;
                lastAnim = anim;
            }
        }

        public static class Entry {
            private final int START;
            private final int END;
            private final EasingFunction easing;
            private final float TIMER;
            private final float SPEED;

            private Entry(int start, int end, EasingFunction easing, float timer, float speed) {
                this.START = start;
                this.END = end;
                this.easing = easing;
                this.TIMER = timer;
                this.SPEED = speed;
            }
        }
    }

    public static class KeyFrame {
        private final Builder BUILDER;
        private final class_630 PART;

        private KeyFrame(Builder builder, class_630 part) {
            this.BUILDER = builder;
            this.PART = part;
        }

        public KeyFrame rotation(float x, float y, float z) {
            return this.rotation(0.0f, x, 0.0f, y, 0.0f, z, 1.0f, 0.0f);
        }

        public KeyFrame rotation(float xs, float x, float ys, float y, float zs, float z) {
            return this.rotation(xs, x, ys, y, zs, z, 1.0f, 0.0f);
        }

        public KeyFrame rotation(float xs, float x, float ys, float y, float zs, float z, float o) {
            return this.rotation(xs, x, ys, y, zs, z, 1.0f, o);
        }

        public KeyFrame rotation(float xs, float x, float ys, float y, float zs, float z, float sp, float o) {
            this.xRot(xs, x, sp, o);
            this.yRot(ys, y, sp, o);
            this.zRot(zs, z, sp, o);
            return this;
        }

        public KeyFrame xRot(float b) {
            return this.xRot(0.0f, b, 1.0f, 0.0f);
        }

        public KeyFrame xRot(float s, float b) {
            return this.xRot(s, b, 1.0f, 0.0f);
        }

        public KeyFrame xRot(float s, float b, float o) {
            return this.xRot(s, b, 1.0f, o);
        }

        public KeyFrame xRot(float s, float b, float sp, float o) {
            this.PART.field_3654 = this.BUILDER.MODE.acceptRotation(this.PART.field_3654, -s, -b, this.BUILDER.SPEED * sp, this.BUILDER.MOD, o, this.BUILDER.TIMER);
            return this;
        }

        public KeyFrame yRot(float b) {
            return this.yRot(0.0f, b, 1.0f, 0.0f);
        }

        public KeyFrame yRot(float s, float b) {
            return this.yRot(s, b, 1.0f, 0.0f);
        }

        public KeyFrame yRot(float s, float b, float o) {
            return this.yRot(s, b, 1.0f, o);
        }

        public KeyFrame yRot(float s, float b, float sp, float o) {
            this.PART.field_3675 = this.BUILDER.MODE.acceptRotation(this.PART.field_3675, -s, -b, this.BUILDER.SPEED * sp, this.BUILDER.MOD, o, this.BUILDER.TIMER);
            return this;
        }

        public KeyFrame zRot(float b) {
            return this.zRot(0.0f, b, 1.0f, 0.0f);
        }

        public KeyFrame zRot(float s, float b) {
            return this.zRot(s, b, 1.0f, 0.0f);
        }

        public KeyFrame zRot(float s, float b, float o) {
            return this.zRot(s, b, 1.0f, o);
        }

        public KeyFrame zRot(float s, float b, float sp, float o) {
            this.PART.field_3674 = this.BUILDER.MODE.acceptRotation(this.PART.field_3674, s, b, this.BUILDER.SPEED * sp, this.BUILDER.MOD, o, this.BUILDER.TIMER);
            return this;
        }

        public KeyFrame scale(float s) {
            return this.scale(0.0f, s, 0.0f, s, 0.0f, s, 1.0f, 0.0f);
        }

        public KeyFrame scale(float x, float y, float z) {
            return this.scale(0.0f, x, 0.0f, y, 0.0f, z, 1.0f, 0.0f);
        }

        public KeyFrame scale(float xs, float x, float ys, float y, float zs, float z) {
            return this.scale(xs, x, ys, y, zs, z, 1.0f, 0.0f);
        }

        public KeyFrame scale(float xs, float x, float ys, float y, float zs, float z, float o) {
            return this.scale(xs, x, ys, y, zs, z, 1.0f, o);
        }

        public KeyFrame scale(float xs, float x, float ys, float y, float zs, float z, float sp, float o) {
            this.xScale(xs, x, sp, o);
            this.yScale(ys, y, sp, o);
            this.zScale(zs, z, sp, o);
            return this;
        }

        public KeyFrame xScale(float b) {
            return this.xScale(0.0f, b, 1.0f, 0.0f);
        }

        public KeyFrame xScale(float s, float b) {
            return this.xScale(s, b, 1.0f, 0.0f);
        }

        public KeyFrame xScale(float s, float b, float o) {
            return this.xScale(s, b, 1.0f, o);
        }

        public KeyFrame xScale(float s, float b, float sp, float o) {
            this.PART.field_37938 = this.BUILDER.MODE.acceptScale(this.PART.field_37938, s, b, this.BUILDER.SPEED * sp, this.BUILDER.MOD, o, this.BUILDER.TIMER);
            return this;
        }

        public KeyFrame yScale(float b) {
            return this.yScale(0.0f, b, 1.0f, 0.0f);
        }

        public KeyFrame yScale(float s, float b) {
            return this.yScale(s, b, 1.0f, 0.0f);
        }

        public KeyFrame yScale(float s, float b, float o) {
            return this.yScale(s, b, 1.0f, o);
        }

        public KeyFrame yScale(float s, float b, float sp, float o) {
            this.PART.field_37939 = this.BUILDER.MODE.acceptScale(this.PART.field_37939, s, b, this.BUILDER.SPEED * sp, this.BUILDER.MOD, o, this.BUILDER.TIMER);
            return this;
        }

        public KeyFrame zScale(float b) {
            return this.zScale(0.0f, b, 1.0f, 0.0f);
        }

        public KeyFrame zScale(float s, float b) {
            return this.zScale(s, b, 1.0f, 0.0f);
        }

        public KeyFrame zScale(float s, float b, float o) {
            return this.zScale(s, b, 1.0f, o);
        }

        public KeyFrame zScale(float s, float b, float sp, float o) {
            this.PART.field_37940 = this.BUILDER.MODE.acceptScale(this.PART.field_37940, s, b, this.BUILDER.SPEED * sp, this.BUILDER.MOD, o, this.BUILDER.TIMER);
            return this;
        }
    }

    public static class math {
        public static float cycle(float timer, float speed) {
            return math.cycle(timer, speed, 0.0f);
        }

        public static float cycle(float timer, float speed, float offset) {
            return 0.5f + (float)Math.cos(timer * speed + offset * 6.283f) * 0.5f;
        }

        public static void i(@NotNull class_630 part, float xSwing, float x, float ySwing, float y, float zSwing, float z, float speed, float offset, float timer) {
            part.field_3654 += math.idle(xSwing, x * -1.0f, speed, offset, timer);
            part.field_3675 += math.idle(ySwing, y * -1.0f, speed, offset, timer);
            part.field_3674 += math.idle(zSwing, z, speed, offset, timer);
        }

        public static void i(@NotNull class_630 part, float xSwing, float x, float ySwing, float y, float zSwing, float z, float speed, float offset, float timer, float mod2) {
            part.field_3654 += math.idle(xSwing, x * -1.0f, speed, offset, timer, mod2);
            part.field_3675 += math.idle(ySwing, y * -1.0f, speed, offset, timer, mod2);
            part.field_3674 += math.idle(zSwing, z, speed, offset, timer, mod2);
        }

        public static void i(@NotNull class_630 part, float xSwing, float x, float ySwing, float y, float zSwing, float z, float speed, float offset, float timer, float mod1, float mod2) {
            part.field_3654 += math.idle(xSwing, x * -1.0f, speed, offset, timer, mod1, mod2);
            part.field_3675 += math.idle(ySwing, y * -1.0f, speed, offset, timer, mod1, mod2);
            part.field_3674 += math.idle(zSwing, z, speed, offset, timer, mod1, mod2);
        }

        public static void m(@NotNull class_630 part, float xSwing, float x, float ySwing, float y, float zSwing, float z, float speed, float offset, float timer, float mod2) {
            part.field_3654 += math.move(xSwing, x * -1.0f, speed, offset, timer, mod2);
            part.field_3675 += math.move(ySwing, y * -1.0f, speed, offset, timer, mod2);
            part.field_3674 += math.move(zSwing, z, speed, offset, timer, mod2);
        }

        public static void m(@NotNull class_630 part, float xSwing, float x, float ySwing, float y, float zSwing, float z, float speed, float offset, float timer, float mod1, float mod2) {
            part.field_3654 += math.move(xSwing, x * -1.0f, speed, offset, timer, mod1, mod2);
            part.field_3675 += math.move(ySwing, y * -1.0f, speed, offset, timer, mod1, mod2);
            part.field_3674 += math.move(zSwing, z, speed, offset, timer, mod1, mod2);
        }

        public static float idle(float swingAngle, float baseAngle, float speed, float offset, float timer) {
            if (swingAngle == 0.0f && baseAngle == 0.0f) {
                return 0.0f;
            }
            return (swingAngle *= (float)Math.PI / 180) * class_3532.method_15362((float)(timer * speed + offset * 6.283f)) + (baseAngle *= (float)Math.PI / 180);
        }

        public static float idle(float swingAngle, float baseAngle, float speed, float offset, float timer, float mod1) {
            if (swingAngle == 0.0f && baseAngle == 0.0f) {
                return 0.0f;
            }
            return mod1 <= 0.0f ? 0.0f : math.idle(swingAngle, baseAngle, speed, offset, timer) * mod1;
        }

        public static float idle(float swingAngle, float baseAngle, float speed, float offset, float timer, float mod1, float mod2) {
            if (swingAngle == 0.0f && baseAngle == 0.0f) {
                return 0.0f;
            }
            return (mod2 = 1.0f - mod2) <= 0.0f ? 0.0f : math.idle(swingAngle, baseAngle, speed, offset, timer, mod1) * mod2;
        }

        public static float move(float swingAngle, float baseAngle, float speed, float offset, float timer, float mod1) {
            if (swingAngle == 0.0f && baseAngle == 0.0f) {
                return 0.0f;
            }
            return (mod1 * (swingAngle *= (float)Math.PI / 180) * class_3532.method_15362((float)(timer * speed + offset * 6.283f)) + (baseAngle *= (float)Math.PI / 180)) * mod1;
        }

        public static float move(float swingAngle, float baseAngle, float speed, float offset, float timer, float mod1, float mod2) {
            if (swingAngle == 0.0f && baseAngle == 0.0f) {
                return 0.0f;
            }
            return (mod2 = 1.0f - mod2) <= 0.0f ? 0.0f : math.move(swingAngle, baseAngle, speed, offset, timer, mod1) * mod2;
        }
    }

    public static class mod {
        public static float idle(float limbSwingAmount, float mod2) {
            return Math.max(1.0f - limbSwingAmount * mod2, 0.0f);
        }

        public static float move(float limbSwingAmount, float mod2) {
            return Math.min(limbSwingAmount * mod2, 1.0f);
        }

        public static float head(float yaw, float mod2) {
            return yaw / 57.295776f * mod2;
        }
    }
}

