/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.animation.AnimationUtils;
import icyllis.modernui.core.Context;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.drawable.ShapeDrawable;
import icyllis.modernui.resources.SystemTheme;
import icyllis.modernui.view.FocusFinder;
import icyllis.modernui.view.KeyEvent;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.VelocityTracker;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewConfiguration;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.view.ViewParent;
import icyllis.modernui.widget.EdgeEffect;
import icyllis.modernui.widget.FrameLayout;
import icyllis.modernui.widget.OverScroller;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NestedScrollView
extends FrameLayout {
    static final int ANIMATED_SCROLL_GAP = 250;
    static final float MAX_SCROLL_FACTOR = 0.5f;
    private static final int DEFAULT_SMOOTH_SCROLL_DURATION = 250;
    private long mLastScroll;
    private final Rect mTempRect = new Rect();
    private final OverScroller mScroller;
    private final EdgeEffect mEdgeGlowTop;
    private final EdgeEffect mEdgeGlowBottom;
    private int mLastMotionY;
    private boolean mIsLayoutDirty = true;
    private boolean mIsLaidOut = false;
    private View mChildToScrollTo = null;
    private boolean mIsBeingDragged = false;
    private VelocityTracker mVelocityTracker;
    private boolean mFillViewport;
    private boolean mSmoothScrollingEnabled = true;
    private final int mTouchSlop;
    private final int mMinimumVelocity;
    private final int mMaximumVelocity;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private int mNestedYOffset;
    private int mLastScrollerY;
    private OnScrollChangeListener mOnScrollChangeListener;

    public NestedScrollView(Context context) {
        super(context);
        this.mEdgeGlowTop = new EdgeEffect();
        this.mEdgeGlowBottom = new EdgeEffect();
        this.mScroller = new OverScroller();
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration configuration = ViewConfiguration.get(context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.setNestedScrollingEnabled(true);
        this.setVerticalScrollBarEnabled(true);
        ShapeDrawable thumb = new ShapeDrawable();
        thumb.setShape(4);
        thumb.setStroke(this.dp(4.0f), SystemTheme.modulateColor(-1, 0.25f));
        thumb.setCornerRadius(1.0f);
        this.setVerticalScrollbarThumbDrawable(thumb);
        ShapeDrawable track = new ShapeDrawable();
        track.setShape(4);
        track.setStroke(this.dp(4.0f), 0x40808080);
        track.setSize(this.dp(4.0f), -1);
        track.setCornerRadius(1.0f);
        this.setVerticalScrollbarTrackDrawable(track);
    }

    @Override
    public void onNestedScroll(@Nonnull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @Nonnull int[] consumed) {
        int oldScrollY = this.getScrollY();
        this.scrollBy(0, dyUnconsumed);
        int myConsumed = this.getScrollY() - oldScrollY;
        if (consumed != null) {
            consumed[1] = consumed[1] + myConsumed;
        }
        int myUnconsumed = dyUnconsumed - myConsumed;
        this.dispatchNestedScroll(0, myConsumed, 0, myUnconsumed, null, type, consumed);
    }

    @Override
    public boolean onStartNestedScroll(@Nonnull View child, @Nonnull View target, int axes, int type) {
        return (axes & 2) != 0;
    }

    @Override
    public void onNestedScrollAccepted(@Nonnull View child, @Nonnull View target, int axes, int type) {
        super.onNestedScrollAccepted(child, target, axes, type);
        this.startNestedScroll(2, type);
    }

    @Override
    public void onStopNestedScroll(@Nonnull View target, int type) {
        super.onStopNestedScroll(target, type);
        this.stopNestedScroll(type);
    }

    @Override
    public void onNestedPreScroll(@Nonnull View target, int dx, int dy, @Nonnull int[] consumed, int type) {
        this.dispatchNestedPreScroll(dx, dy, consumed, null, type);
    }

    @Override
    public boolean onNestedFling(@Nonnull View target, float velocityX, float velocityY, boolean consumed) {
        if (!consumed) {
            this.dispatchNestedFling(0.0f, velocityY, true);
            this.fling((int)velocityY);
            return true;
        }
        return false;
    }

    @Override
    public boolean onNestedPreFling(@Nonnull View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return true;
    }

    public int getMaxScrollAmount() {
        return (int)(0.5f * (float)this.getHeight());
    }

    @Override
    public void addView(@Nonnull View child) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child);
    }

    @Override
    public void addView(@Nonnull View child, int index) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, index);
    }

    @Override
    public void addView(@Nonnull View child, @Nonnull ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, params);
    }

    @Override
    public void addView(@Nonnull View child, int index, @Nonnull ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, index, params);
    }

    public void setOnScrollChangeListener(@Nullable OnScrollChangeListener l) {
        this.mOnScrollChangeListener = l;
    }

    private boolean canScroll() {
        if (this.getChildCount() > 0) {
            int parentSpace;
            View child = this.getChildAt(0);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            int childSize = child.getHeight() + lp.topMargin + lp.bottomMargin;
            return childSize > (parentSpace = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
        }
        return false;
    }

    public boolean isFillViewport() {
        return this.mFillViewport;
    }

    public void setFillViewport(boolean fillViewport) {
        if (fillViewport != this.mFillViewport) {
            this.mFillViewport = fillViewport;
            this.requestLayout();
        }
    }

    public boolean isSmoothScrollingEnabled() {
        return this.mSmoothScrollingEnabled;
    }

    public void setSmoothScrollingEnabled(boolean smoothScrollingEnabled) {
        this.mSmoothScrollingEnabled = smoothScrollingEnabled;
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mOnScrollChangeListener != null) {
            this.mOnScrollChangeListener.onScrollChange(this, l, t, oldl, oldt);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.mFillViewport) {
            return;
        }
        int heightMode = MeasureSpec.getMode(heightMeasureSpec);
        if (heightMode == 0) {
            return;
        }
        if (this.getChildCount() > 0) {
            int parentSpace;
            View child = this.getChildAt(0);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            int childSize = child.getMeasuredHeight();
            if (childSize < (parentSpace = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom() - lp.topMargin - lp.bottomMargin)) {
                int childWidthMeasureSpec = NestedScrollView.getChildMeasureSpec(widthMeasureSpec, this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin, lp.width);
                int childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(parentSpace, 0x40000000);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    @Override
    public boolean dispatchKeyEvent(@Nonnull KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    public boolean executeKeyEvent(@Nonnull KeyEvent event) {
        this.mTempRect.setEmpty();
        if (!this.canScroll()) {
            if (this.isFocused() && event.getKeyCode() != 256) {
                View nextFocused;
                View currentFocused = this.findFocus();
                if (currentFocused == this) {
                    currentFocused = null;
                }
                return (nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, 130)) != null && nextFocused != this && nextFocused.requestFocus(130);
            }
            return false;
        }
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 265: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(33);
                        break;
                    }
                    handled = this.fullScroll(33);
                    break;
                }
                case 264: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(130);
                        break;
                    }
                    handled = this.fullScroll(130);
                    break;
                }
                case 32: {
                    this.pageScroll(event.isShiftPressed() ? 33 : 130);
                }
            }
        }
        return handled;
    }

    private boolean inChild(int x, int y) {
        if (this.getChildCount() > 0) {
            int scrollY = this.getScrollY();
            View child = this.getChildAt(0);
            return y >= child.getTop() - scrollY && y < child.getBottom() - scrollY && x >= child.getLeft() && x < child.getRight();
        }
        return false;
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    @Override
    public boolean onInterceptTouchEvent(@Nonnull MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.mIsBeingDragged) {
            return true;
        }
        switch (action) {
            case 2: {
                int y = (int)ev.getY();
                int yDiff = Math.abs(y - this.mLastMotionY);
                if (yDiff <= this.mTouchSlop || (this.getNestedScrollAxes() & 2) != 0) break;
                this.mIsBeingDragged = true;
                this.mLastMotionY = y;
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(ev);
                this.mNestedYOffset = 0;
                ViewParent parent = this.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 0: {
                int y = (int)ev.getY();
                if (!this.inChild((int)ev.getX(), y)) {
                    this.mIsBeingDragged = this.stopGlowAnimations(ev) || !this.mScroller.isFinished();
                    this.recycleVelocityTracker();
                    break;
                }
                this.mLastMotionY = y;
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                this.mScroller.computeScrollOffset();
                this.mIsBeingDragged = this.stopGlowAnimations(ev) || !this.mScroller.isFinished();
                this.startNestedScroll(2, 0);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.recycleVelocityTracker();
                if (this.mScroller.springBack(this.getScrollX(), this.getScrollY(), 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.stopNestedScroll(0);
            }
        }
        return this.mIsBeingDragged;
    }

    @Override
    public boolean onTouchEvent(@Nonnull MotionEvent ev) {
        this.initVelocityTrackerIfNotExists();
        int action = ev.getAction();
        if (action == 0) {
            this.mNestedYOffset = 0;
        }
        MotionEvent vtev = ev.copy();
        vtev.offsetLocation(0.0f, this.mNestedYOffset);
        switch (action) {
            case 0: {
                ViewParent parent;
                if (this.getChildCount() == 0) {
                    return false;
                }
                if (this.mIsBeingDragged && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.abortAnimatedScroll();
                }
                this.mLastMotionY = (int)ev.getY();
                this.startNestedScroll(2, 0);
                break;
            }
            case 2: {
                int y = (int)ev.getY();
                int deltaY = this.mLastMotionY - y;
                deltaY -= this.releaseVerticalGlow(deltaY, ev.getX());
                if (!this.mIsBeingDragged && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mIsBeingDragged = true;
                    deltaY = deltaY > 0 ? (deltaY -= this.mTouchSlop) : (deltaY += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                if (this.dispatchNestedPreScroll(0, deltaY, this.mScrollConsumed, this.mScrollOffset, 0)) {
                    deltaY -= this.mScrollConsumed[1];
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                this.mLastMotionY = y - this.mScrollOffset[1];
                int oldY = this.getScrollY();
                int range = this.getScrollRange();
                int overscrollMode = this.getOverScrollMode();
                boolean canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
                boolean clearVelocityTracker = this.overScrollByCompat(0, deltaY, 0, this.getScrollY(), 0, range, 0, ViewConfiguration.get(this.getContext()).getScaledOverscrollDistance(), true) && !this.hasNestedScrollingParent(0);
                int scrolledDeltaY = this.getScrollY() - oldY;
                int unconsumedY = deltaY - scrolledDeltaY;
                this.mScrollConsumed[1] = 0;
                this.dispatchNestedScroll(0, scrolledDeltaY, 0, unconsumedY, this.mScrollOffset, 0, this.mScrollConsumed);
                this.mLastMotionY -= this.mScrollOffset[1];
                this.mNestedYOffset += this.mScrollOffset[1];
                if (canOverscroll) {
                    int pulledToY = oldY + (deltaY -= this.mScrollConsumed[1]);
                    if (pulledToY < 0) {
                        this.mEdgeGlowTop.onPullDistance((float)(-deltaY) / (float)this.getHeight(), ev.getX() / (float)this.getWidth());
                        if (!this.mEdgeGlowBottom.isFinished()) {
                            this.mEdgeGlowBottom.onRelease();
                        }
                    } else if (pulledToY > range) {
                        this.mEdgeGlowBottom.onPullDistance((float)deltaY / (float)this.getHeight(), 1.0f - ev.getX() / (float)this.getWidth());
                        if (!this.mEdgeGlowTop.isFinished()) {
                            this.mEdgeGlowTop.onRelease();
                        }
                    }
                    if (!this.mEdgeGlowTop.isFinished() || !this.mEdgeGlowBottom.isFinished()) {
                        this.postInvalidateOnAnimation();
                        clearVelocityTracker = false;
                    }
                }
                if (!clearVelocityTracker) break;
                this.mVelocityTracker.clear();
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getYVelocity();
                if (Math.abs(initialVelocity) >= this.mMinimumVelocity) {
                    if (!this.edgeEffectFling(initialVelocity) && !this.dispatchNestedPreFling(0.0f, -initialVelocity)) {
                        this.dispatchNestedFling(0.0f, -initialVelocity, true);
                        this.fling(-initialVelocity);
                    }
                } else if (this.mScroller.springBack(this.getScrollX(), this.getScrollY(), 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.endDrag();
                break;
            }
            case 3: {
                if (this.mIsBeingDragged && this.getChildCount() > 0 && this.mScroller.springBack(this.getScrollX(), this.getScrollY(), 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.endDrag();
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private boolean edgeEffectFling(int velocityY) {
        boolean consumed = true;
        if (this.mEdgeGlowTop.getDistance() != 0.0f) {
            this.mEdgeGlowTop.onAbsorb(velocityY);
        } else if (this.mEdgeGlowBottom.getDistance() != 0.0f) {
            this.mEdgeGlowBottom.onAbsorb(-velocityY);
        } else {
            consumed = false;
        }
        return consumed;
    }

    private boolean stopGlowAnimations(MotionEvent e) {
        boolean stopped = false;
        if (this.mEdgeGlowTop.getDistance() != 0.0f) {
            this.mEdgeGlowTop.onPullDistance(0.0f, e.getY() / (float)this.getHeight());
            stopped = true;
        }
        if (this.mEdgeGlowBottom.getDistance() != 0.0f) {
            this.mEdgeGlowBottom.onPullDistance(0.0f, 1.0f - e.getY() / (float)this.getHeight());
            stopped = true;
        }
        if (stopped) {
            // empty if block
        }
        return false;
    }

    @Override
    public boolean onGenericMotionEvent(@Nonnull MotionEvent event) {
        if (event.getAction() == 8 && !this.mIsBeingDragged) {
            float axisValue = event.getAxisValue(9);
            int delta = Math.round(axisValue * ViewConfiguration.get(this.getContext()).getScaledVerticalScrollFactor());
            if ((double)Math.abs(axisValue) > 0.9 && Math.abs(delta) * 6 > this.mMinimumVelocity) {
                int deltaY = MathUtil.clamp(delta * 6, -this.mMaximumVelocity, this.mMaximumVelocity);
                if (!this.edgeEffectFling(deltaY) && !this.dispatchNestedPreFling(0.0f, -deltaY)) {
                    this.dispatchNestedFling(0.0f, -deltaY, true);
                    this.fling(-deltaY);
                }
                return true;
            }
            this.smoothScrollBy(-delta, 0);
            return true;
        }
        return false;
    }

    @Override
    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        super.scrollTo(scrollX, scrollY);
    }

    boolean overScrollByCompat(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
        int overScrollMode = this.getOverScrollMode();
        boolean canScrollHorizontal = this.computeHorizontalScrollRange() > this.computeHorizontalScrollExtent();
        boolean canScrollVertical = this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
        boolean overScrollHorizontal = overScrollMode == 0 || overScrollMode == 1 && canScrollHorizontal;
        boolean overScrollVertical = overScrollMode == 0 || overScrollMode == 1 && canScrollVertical;
        int newScrollX = scrollX + deltaX;
        if (!overScrollHorizontal) {
            maxOverScrollX = 0;
        }
        int newScrollY = scrollY + deltaY;
        if (!overScrollVertical) {
            maxOverScrollY = 0;
        }
        int left = -maxOverScrollX;
        int right = maxOverScrollX + scrollRangeX;
        int top = -maxOverScrollY;
        int bottom = maxOverScrollY + scrollRangeY;
        boolean clampedX = false;
        if (newScrollX > right) {
            newScrollX = right;
            clampedX = true;
        } else if (newScrollX < left) {
            newScrollX = left;
            clampedX = true;
        }
        boolean clampedY = false;
        if (newScrollY > bottom) {
            newScrollY = bottom;
            clampedY = true;
        } else if (newScrollY < top) {
            newScrollY = top;
            clampedY = true;
        }
        if (clampedY && !this.hasNestedScrollingParent(1)) {
            this.mScroller.springBack(newScrollX, newScrollY, 0, 0, 0, this.getScrollRange());
        }
        this.onOverScrolled(newScrollX, newScrollY, clampedX, clampedY);
        return clampedX || clampedY;
    }

    int getScrollRange() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            int childSize = child.getHeight() + lp.topMargin + lp.bottomMargin;
            int parentSpace = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            scrollRange = Math.max(0, childSize - parentSpace);
        }
        return scrollRange;
    }

    private View findFocusableViewInBounds(boolean topFocus, int top, int bottom) {
        ArrayList<View> focusables = this.getFocusables(2);
        View focusCandidate = null;
        boolean foundFullyContainedFocusable = false;
        for (View view : focusables) {
            boolean viewIsCloserToBoundary;
            boolean viewIsFullyContained;
            int viewTop = view.getTop();
            int viewBottom = view.getBottom();
            if (top >= viewBottom || viewTop >= bottom) continue;
            boolean bl = viewIsFullyContained = top < viewTop && viewBottom < bottom;
            if (focusCandidate == null) {
                focusCandidate = view;
                foundFullyContainedFocusable = viewIsFullyContained;
                continue;
            }
            boolean bl2 = viewIsCloserToBoundary = topFocus && viewTop < focusCandidate.getTop() || !topFocus && viewBottom > focusCandidate.getBottom();
            if (foundFullyContainedFocusable) {
                if (!viewIsFullyContained || !viewIsCloserToBoundary) continue;
                focusCandidate = view;
                continue;
            }
            if (viewIsFullyContained) {
                focusCandidate = view;
                foundFullyContainedFocusable = true;
                continue;
            }
            if (!viewIsCloserToBoundary) continue;
            focusCandidate = view;
        }
        return focusCandidate;
    }

    public boolean pageScroll(int direction) {
        boolean down = direction == 130;
        int height = this.getHeight();
        if (down) {
            this.mTempRect.top = this.getScrollY() + height;
            int count = this.getChildCount();
            if (count > 0) {
                View view = this.getChildAt(count - 1);
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
                int bottom = view.getBottom() + lp.bottomMargin + this.getPaddingBottom();
                if (this.mTempRect.top + height > bottom) {
                    this.mTempRect.top = bottom - height;
                }
            }
        } else {
            this.mTempRect.top = this.getScrollY() - height;
            if (this.mTempRect.top < 0) {
                this.mTempRect.top = 0;
            }
        }
        this.mTempRect.bottom = this.mTempRect.top + height;
        return this.scrollAndFocus(direction, this.mTempRect.top, this.mTempRect.bottom);
    }

    public boolean fullScroll(int direction) {
        int count;
        boolean down = direction == 130;
        int height = this.getHeight();
        this.mTempRect.top = 0;
        this.mTempRect.bottom = height;
        if (down && (count = this.getChildCount()) > 0) {
            View view = this.getChildAt(count - 1);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
            this.mTempRect.bottom = view.getBottom() + lp.bottomMargin + this.getPaddingBottom();
            this.mTempRect.top = this.mTempRect.bottom - height;
        }
        return this.scrollAndFocus(direction, this.mTempRect.top, this.mTempRect.bottom);
    }

    private boolean scrollAndFocus(int direction, int top, int bottom) {
        boolean handled = true;
        int height = this.getHeight();
        int containerTop = this.getScrollY();
        int containerBottom = containerTop + height;
        boolean up = direction == 33;
        View newFocused = this.findFocusableViewInBounds(up, top, bottom);
        if (newFocused == null) {
            newFocused = this;
        }
        if (top >= containerTop && bottom <= containerBottom) {
            handled = false;
        } else {
            int delta = up ? top - containerTop : bottom - containerBottom;
            this.doScrollY(delta);
        }
        if (newFocused != this.findFocus()) {
            newFocused.requestFocus(direction);
        }
        return handled;
    }

    public boolean arrowScroll(int direction) {
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        }
        View nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, direction);
        int maxJump = this.getMaxScrollAmount();
        if (nextFocused != null && this.isWithinDeltaOfScreen(nextFocused, maxJump, this.getHeight())) {
            nextFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(nextFocused, this.mTempRect);
            scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollY(scrollDelta);
            nextFocused.requestFocus(direction);
        } else {
            scrollDelta = maxJump;
            if (direction == 33 && this.getScrollY() < scrollDelta) {
                scrollDelta = this.getScrollY();
            } else if (direction == 130 && this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
                int daBottom = child.getBottom() + lp.bottomMargin;
                int screenBottom = this.getScrollY() + this.getHeight() - this.getPaddingBottom();
                scrollDelta = Math.min(daBottom - screenBottom, maxJump);
            }
            if (scrollDelta == 0) {
                return false;
            }
            this.doScrollY(direction == 130 ? scrollDelta : -scrollDelta);
        }
        if (currentFocused != null && currentFocused.isFocused() && this.isOffScreen(currentFocused)) {
            int descendantFocusability = this.getDescendantFocusability();
            this.setDescendantFocusability(131072);
            this.requestFocus();
            this.setDescendantFocusability(descendantFocusability);
        }
        return true;
    }

    private boolean isOffScreen(View descendant) {
        return !this.isWithinDeltaOfScreen(descendant, 0, this.getHeight());
    }

    private boolean isWithinDeltaOfScreen(View descendant, int delta, int height) {
        descendant.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendant, this.mTempRect);
        return this.mTempRect.bottom + delta >= this.getScrollY() && this.mTempRect.top - delta <= this.getScrollY() + height;
    }

    private void doScrollY(int delta) {
        if (delta != 0) {
            if (this.mSmoothScrollingEnabled) {
                this.smoothScrollBy(0, delta);
            } else {
                this.scrollBy(0, delta);
            }
        }
    }

    public final void smoothScrollBy(int dx, int dy) {
        this.smoothScrollBy(dx, dy, 250, false);
    }

    public final void smoothScrollBy(int dx, int dy, int scrollDurationMs) {
        this.smoothScrollBy(dx, dy, scrollDurationMs, false);
    }

    private void smoothScrollBy(int dx, int dy, int scrollDurationMs, boolean withNestedScrolling) {
        if (this.getChildCount() == 0) {
            return;
        }
        long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
        if (duration > 250L) {
            View child = this.getChildAt(0);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            int childSize = child.getHeight() + lp.topMargin + lp.bottomMargin;
            int parentSpace = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            int scrollY = this.getScrollY();
            int maxY = Math.max(0, childSize - parentSpace);
            dy = Math.max(0, Math.min(scrollY + dy, maxY)) - scrollY;
            this.mScroller.startScroll(this.getScrollX(), scrollY, 0, dy, scrollDurationMs);
            this.runAnimatedScroll(withNestedScrolling);
        } else {
            if (!this.mScroller.isFinished()) {
                this.abortAnimatedScroll();
            }
            this.scrollBy(dx, dy);
        }
        this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
    }

    public final void smoothScrollTo(int x, int y) {
        this.smoothScrollTo(x, y, 250, false);
    }

    public final void smoothScrollTo(int x, int y, int scrollDurationMs) {
        this.smoothScrollTo(x, y, scrollDurationMs, false);
    }

    void smoothScrollTo(int x, int y, boolean withNestedScrolling) {
        this.smoothScrollTo(x, y, 250, withNestedScrolling);
    }

    void smoothScrollTo(int x, int y, int scrollDurationMs, boolean withNestedScrolling) {
        this.smoothScrollBy(x - this.getScrollX(), y - this.getScrollY(), scrollDurationMs, withNestedScrolling);
    }

    @Override
    public int computeVerticalScrollRange() {
        int count = this.getChildCount();
        int parentSpace = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        if (count == 0) {
            return parentSpace;
        }
        View child = this.getChildAt(0);
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
        int scrollRange = child.getBottom() + lp.bottomMargin;
        int scrollY = this.getScrollY();
        int overscrollBottom = Math.max(0, scrollRange - parentSpace);
        if (scrollY < 0) {
            scrollRange -= scrollY;
        } else if (scrollY > overscrollBottom) {
            scrollRange += scrollY - overscrollBottom;
        }
        return scrollRange;
    }

    @Override
    public int computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    @Override
    public int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    @Override
    public int computeHorizontalScrollRange() {
        return super.computeHorizontalScrollRange();
    }

    @Override
    public int computeHorizontalScrollOffset() {
        return super.computeHorizontalScrollOffset();
    }

    @Override
    public int computeHorizontalScrollExtent() {
        return super.computeHorizontalScrollExtent();
    }

    @Override
    protected void measureChild(@Nonnull View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = NestedScrollView.getChildMeasureSpec(parentWidthMeasureSpec, this.getPaddingLeft() + this.getPaddingRight(), lp.width);
        int childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(0, 0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    @Override
    protected void measureChildWithMargins(@Nonnull View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = NestedScrollView.getChildMeasureSpec(parentWidthMeasureSpec, this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(lp.topMargin + lp.bottomMargin, 0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    @Override
    public void computeScroll() {
        if (this.mScroller.isFinished()) {
            return;
        }
        this.mScroller.computeScrollOffset();
        int y = this.mScroller.getCurrY();
        int unconsumed = y - this.mLastScrollerY;
        this.mLastScrollerY = y;
        this.mScrollConsumed[1] = 0;
        this.dispatchNestedPreScroll(0, unconsumed, this.mScrollConsumed, null, 1);
        int range = this.getScrollRange();
        if ((unconsumed -= this.mScrollConsumed[1]) != 0) {
            int oldScrollY = this.getScrollY();
            this.overScrollByCompat(0, unconsumed, this.getScrollX(), oldScrollY, 0, range, 0, 0, false);
            int scrolledByMe = this.getScrollY() - oldScrollY;
            this.mScrollConsumed[1] = 0;
            this.dispatchNestedScroll(0, scrolledByMe, 0, unconsumed -= scrolledByMe, this.mScrollOffset, 1, this.mScrollConsumed);
            unconsumed -= this.mScrollConsumed[1];
        }
        if (unconsumed != 0) {
            boolean canOverscroll;
            int mode = this.getOverScrollMode();
            boolean bl = canOverscroll = mode == 0 || mode == 1 && range > 0;
            if (canOverscroll) {
                if (unconsumed < 0) {
                    if (this.mEdgeGlowTop.isFinished()) {
                        this.mEdgeGlowTop.onAbsorb((int)this.mScroller.getCurrVelocity());
                    }
                } else if (this.mEdgeGlowBottom.isFinished()) {
                    this.mEdgeGlowBottom.onAbsorb((int)this.mScroller.getCurrVelocity());
                }
            }
            this.abortAnimatedScroll();
        }
        if (!this.mScroller.isFinished()) {
            this.postInvalidateOnAnimation();
        } else {
            this.stopNestedScroll(1);
        }
    }

    private int releaseVerticalGlow(int deltaY, float x) {
        int pixelsConsumed;
        float consumed = 0.0f;
        float displacement = x / (float)this.getWidth();
        float pullDistance = (float)deltaY / (float)this.getHeight();
        if (this.mEdgeGlowTop.getDistance() != 0.0f) {
            consumed = -this.mEdgeGlowTop.onPullDistance(-pullDistance, displacement);
            if (this.mEdgeGlowTop.getDistance() == 0.0f) {
                this.mEdgeGlowTop.onRelease();
            }
        } else if (this.mEdgeGlowBottom.getDistance() != 0.0f) {
            consumed = this.mEdgeGlowBottom.onPullDistance(pullDistance, 1.0f - displacement);
            if (this.mEdgeGlowBottom.getDistance() == 0.0f) {
                this.mEdgeGlowBottom.onRelease();
            }
        }
        if ((pixelsConsumed = Math.round(consumed * (float)this.getHeight())) != 0) {
            this.invalidate();
        }
        return pixelsConsumed;
    }

    private void runAnimatedScroll(boolean participateInNestedScrolling) {
        if (participateInNestedScrolling) {
            this.startNestedScroll(2, 1);
        } else {
            this.stopNestedScroll(1);
        }
        this.mLastScrollerY = this.getScrollY();
        this.postInvalidateOnAnimation();
    }

    private void abortAnimatedScroll() {
        this.mScroller.abortAnimation();
        this.stopNestedScroll(1);
    }

    private void scrollToChild(@Nonnull View child) {
        child.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(child, this.mTempRect);
        int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
        if (scrollDelta != 0) {
            this.scrollBy(0, scrollDelta);
        }
    }

    private boolean scrollToChildRect(Rect rect, boolean immediate) {
        boolean scroll;
        int delta = this.computeScrollDeltaToGetChildRectOnScreen(rect);
        boolean bl = scroll = delta != 0;
        if (scroll) {
            if (immediate) {
                this.scrollBy(0, delta);
            } else {
                this.smoothScrollBy(0, delta);
            }
        }
        return scroll;
    }

    protected int computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        int screenBottom;
        if (this.getChildCount() == 0) {
            return 0;
        }
        int height = this.getHeight();
        int screenTop = this.getScrollY();
        int actualScreenBottom = screenBottom = screenTop + height;
        int fadingEdge = 0;
        if (rect.top > 0) {
            screenTop += fadingEdge;
        }
        View child = this.getChildAt(0);
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
        if (rect.bottom < child.getHeight() + lp.topMargin + lp.bottomMargin) {
            screenBottom -= fadingEdge;
        }
        int scrollYDelta = 0;
        if (rect.bottom > screenBottom && rect.top > screenTop) {
            scrollYDelta = rect.height() > height ? (scrollYDelta += rect.top - screenTop) : (scrollYDelta += rect.bottom - screenBottom);
            int bottom = child.getBottom() + lp.bottomMargin;
            int distanceToBottom = bottom - actualScreenBottom;
            scrollYDelta = Math.min(scrollYDelta, distanceToBottom);
        } else if (rect.top < screenTop && rect.bottom < screenBottom) {
            scrollYDelta = rect.height() > height ? (scrollYDelta -= screenBottom - rect.bottom) : (scrollYDelta -= screenTop - rect.top);
            scrollYDelta = Math.max(scrollYDelta, -this.getScrollY());
        }
        return scrollYDelta;
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        if (!this.mIsLayoutDirty) {
            this.scrollToChild(focused);
        } else {
            this.mChildToScrollTo = focused;
        }
        super.requestChildFocus(child, focused);
    }

    @Override
    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        View nextFocus;
        if (direction == 2) {
            direction = 130;
        } else if (direction == 1) {
            direction = 33;
        }
        View view = nextFocus = previouslyFocusedRect == null ? FocusFinder.getInstance().findNextFocus(this, null, direction) : FocusFinder.getInstance().findNextFocusFromRect(this, previouslyFocusedRect, direction);
        if (nextFocus == null) {
            return false;
        }
        if (this.isOffScreen(nextFocus)) {
            return false;
        }
        return nextFocus.requestFocus(direction, previouslyFocusedRect);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        rectangle.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        return this.scrollToChildRect(rectangle, immediate);
    }

    @Override
    public void requestLayout() {
        this.mIsLayoutDirty = true;
        super.requestLayout();
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mIsLayoutDirty = false;
        if (this.mChildToScrollTo != null && NestedScrollView.isViewDescendantOf(this.mChildToScrollTo, this)) {
            this.scrollToChild(this.mChildToScrollTo);
        }
        this.mChildToScrollTo = null;
        if (!this.mIsLaidOut) {
            int childSize = 0;
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
                childSize = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            }
            int parentSpace = b - t - this.getPaddingTop() - this.getPaddingBottom();
            int currentScrollY = this.getScrollY();
            int newScrollY = NestedScrollView.clamp(currentScrollY, parentSpace, childSize);
            if (newScrollY != currentScrollY) {
                this.scrollTo(this.getScrollX(), newScrollY);
            }
        }
        this.scrollTo(this.getScrollX(), this.getScrollY());
        this.mIsLaidOut = true;
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsLaidOut = false;
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        View currentFocused = this.findFocus();
        if (null == currentFocused || this == currentFocused) {
            return;
        }
        if (this.isWithinDeltaOfScreen(currentFocused, 0, oldh)) {
            currentFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(currentFocused, this.mTempRect);
            int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollY(scrollDelta);
        }
    }

    private static boolean isViewDescendantOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && NestedScrollView.isViewDescendantOf((View)((Object)theParent), parent);
    }

    public void fling(int velocityY) {
        if (this.getChildCount() > 0) {
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), 0, velocityY, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, 0);
            this.runAnimatedScroll(true);
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.recycleVelocityTracker();
        this.stopNestedScroll(0);
        this.mEdgeGlowTop.onRelease();
        this.mEdgeGlowBottom.onRelease();
    }

    @Override
    public void scrollTo(int x, int y) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            int parentSpaceHorizontal = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            int childSizeHorizontal = child.getWidth() + lp.leftMargin + lp.rightMargin;
            int parentSpaceVertical = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            int childSizeVertical = child.getHeight() + lp.topMargin + lp.bottomMargin;
            x = NestedScrollView.clamp(x, parentSpaceHorizontal, childSizeHorizontal);
            y = NestedScrollView.clamp(y, parentSpaceVertical, childSizeVertical);
            if (x != this.getScrollX() || y != this.getScrollY()) {
                super.scrollTo(x, y);
            }
        }
    }

    @Override
    public void onDrawForeground(@Nonnull Canvas canvas) {
        int yTranslation;
        int xTranslation;
        int height;
        int width;
        int restoreCount;
        super.onDrawForeground(canvas);
        int scrollY = this.getScrollY();
        if (!this.mEdgeGlowTop.isFinished()) {
            restoreCount = canvas.save();
            width = this.getWidth();
            height = this.getHeight();
            xTranslation = 0;
            yTranslation = Math.min(0, scrollY);
            if (this.getClipToPadding()) {
                width -= this.getPaddingLeft() + this.getPaddingRight();
                xTranslation += this.getPaddingLeft();
                height -= this.getPaddingTop() + this.getPaddingBottom();
                yTranslation += this.getPaddingTop();
            }
            canvas.translate(xTranslation, yTranslation);
            this.mEdgeGlowTop.setSize(width, height);
            if (this.mEdgeGlowTop.draw(canvas)) {
                this.postInvalidateOnAnimation();
            }
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeGlowBottom.isFinished()) {
            restoreCount = canvas.save();
            width = this.getWidth();
            height = this.getHeight();
            xTranslation = 0;
            yTranslation = Math.max(this.getScrollRange(), scrollY) + height;
            if (this.getClipToPadding()) {
                width -= this.getPaddingLeft() + this.getPaddingRight();
                xTranslation += this.getPaddingLeft();
                height -= this.getPaddingTop() + this.getPaddingBottom();
                yTranslation -= this.getPaddingBottom();
            }
            canvas.translate(xTranslation - width, yTranslation);
            canvas.rotate(180.0f, width, 0.0f);
            this.mEdgeGlowBottom.setSize(width, height);
            if (this.mEdgeGlowBottom.draw(canvas)) {
                this.postInvalidateOnAnimation();
            }
            canvas.restoreToCount(restoreCount);
        }
    }

    private static int clamp(int n, int my, int child) {
        if (my >= child || n < 0) {
            return 0;
        }
        if (my + n > child) {
            return child - my;
        }
        return n;
    }

    @FunctionalInterface
    public static interface OnScrollChangeListener {
        public void onScrollChange(NestedScrollView var1, int var2, int var3, int var4, int var5);
    }
}

