/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.ui;

import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.graphics.drawable.ShapeDrawable;
import icyllis.modernui.graphics.drawable.StateListDrawable;
import icyllis.modernui.util.StateSet;
import icyllis.modernui.view.View;
import javax.annotation.Nonnull;

public class ThemeControl {
    public static final int BACKGROUND_COLOR = -1071044052;
    public static final int THEME_COLOR = -3300456;
    public static final int THEME_COLOR_2 = -3303261;
    private static Drawable.ConstantState sBackgroundState;
    private static int sBackgroundDensity;

    public static synchronized void addBackground(@Nonnull View view) {
        ThemeControl.createBackground(view);
        if (sBackgroundState != null) {
            view.setBackground(sBackgroundState.newDrawable());
        }
    }

    private static synchronized void createBackground(@Nonnull View view) {
        int density = view.getContext().getResources().getDisplayMetrics().densityDpi;
        if (sBackgroundState == null || density != sBackgroundDensity) {
            sBackgroundDensity = density;
            StateListDrawable background = new StateListDrawable();
            ShapeDrawable drawable = new ShapeDrawable();
            drawable.setShape(0);
            drawable.setColor(0x60A0A0A0);
            drawable.setCornerRadius(view.dp(3.0f));
            int dp1 = view.dp(1.0f);
            drawable.setStroke(dp1, -1644826);
            background.addState(StateSet.get(64), drawable);
            background.setEnterFadeDuration(200);
            background.setExitFadeDuration(200);
            sBackgroundState = background.getConstantState();
        }
    }

    public static Drawable makeDivider(@Nonnull View view) {
        ShapeDrawable drawable = new ShapeDrawable();
        drawable.setShape(3);
        drawable.setColor(-3300456);
        drawable.setSize(-1, view.dp(2.0f));
        return drawable;
    }
}

