/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.BidiRun;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;
import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.text.CharArrayIterator;
import icyllis.modernui.graphics.text.CharSequenceBuilder;
import icyllis.modernui.graphics.text.EmojiFont;
import icyllis.modernui.graphics.text.Font;
import icyllis.modernui.graphics.text.FontPaint;
import icyllis.modernui.graphics.text.LineBreaker;
import icyllis.modernui.graphics.text.ShapedText;
import icyllis.modernui.mc.text.BitmapFont;
import icyllis.modernui.mc.text.CharacterStyle;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.TextLayout;
import icyllis.modernui.mc.text.TextLayoutEngine;
import icyllis.modernui.text.TextDirectionHeuristic;
import icyllis.modernui.text.TextDirectionHeuristics;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class TextLayoutProcessor {
    public static final boolean DEBUG = false;
    public static final int DEFAULT_BASE_FONT_SIZE = 8;
    public static volatile float sBaseFontSize = 8.0f;
    public static volatile int sLbStyle = 0;
    public static volatile int sLbWordStyle = 0;
    private final TextLayoutEngine mEngine;
    private final CharSequenceBuilder mBuilder = new CharSequenceBuilder();
    private final IntArrayList mStyles = new IntArrayList();
    private final ArrayList<class_2960> mFontNames = new ArrayList();
    private final IntArrayList mGlyphs = new IntArrayList();
    private final ByteArrayList mFontIndices = new ByteArrayList();
    private final ArrayList<Font> mFontVec = new ArrayList();
    private final HashMap<Font, Byte> mFontMap = new HashMap();
    private final Function<Font, Byte> mNextID = font -> {
        this.mFontVec.add((Font)font);
        return (byte)this.mFontMap.size();
    };
    private final FloatArrayList mPositions = new FloatArrayList();
    private final FloatArrayList mAdvances = new FloatArrayList();
    private final IntArrayList mGlyphFlags = new IntArrayList();
    private final IntArrayList mLineBoundaries = new IntArrayList();
    private float mTotalAdvance;
    private final FontPaint mFontPaint = new FontPaint();
    private boolean mHasEffect;
    private boolean mHasColorEmoji;
    private boolean mComputeAdvances = true;
    private boolean mComputeLineBoundaries = true;
    private final class_5224 mSequenceBuilder = (index, style, codePoint) -> {
        int styleFlags = CharacterStyle.flatten(style);
        int charCount = this.mBuilder.addCodePoint(codePoint);
        while (charCount-- > 0) {
            this.mStyles.add(styleFlags);
            this.mFontNames.add(style.method_27708());
        }
        return true;
    };
    private final class_5348.class_5246<class_3902> mContentBuilder = (style, text) -> class_5223.method_27479((String)text, (class_2583)style, (class_5224)this.mSequenceBuilder) ? Optional.empty() : class_5348.field_25309;

    public TextLayoutProcessor(@Nonnull TextLayoutEngine engine) {
        this.mEngine = engine;
    }

    public static int computeFontSize(float resLevel) {
        return Math.min((int)((double)(sBaseFontSize * resLevel) + 0.5), 96);
    }

    private void reset() {
        this.mBuilder.clear();
        this.mStyles.clear();
        this.mFontNames.clear();
        this.mGlyphs.clear();
        this.mFontIndices.clear();
        this.mFontVec.clear();
        this.mFontMap.clear();
        this.mPositions.clear();
        this.mAdvances.clear();
        this.mGlyphFlags.clear();
        this.mLineBoundaries.clear();
        this.mTotalAdvance = 0.0f;
        this.mHasEffect = false;
        this.mHasColorEmoji = false;
    }

    @Nonnull
    public TextLayout createVanillaLayout(@Nonnull String text, @Nonnull class_2583 style, int resLevel, int computeFlags) {
        class_5223.method_27479((String)text, (class_2583)style, (class_5224)this.mSequenceBuilder);
        TextLayout layout = this.createNewLayout(resLevel, computeFlags);
        this.reset();
        return layout;
    }

    @Nonnull
    public TextLayout createTextLayout(@Nonnull class_5348 text, @Nonnull class_2583 style, int resLevel, int computeFlags) {
        text.method_27658(this.mContentBuilder, style);
        TextLayout layout = this.createNewLayout(resLevel, computeFlags);
        this.reset();
        return layout;
    }

    @Nonnull
    public TextLayout createSequenceLayout(@Nonnull class_5481 sequence, int resLevel, int computeFlags) {
        sequence.accept(this.mSequenceBuilder);
        TextLayout layout = this.createNewLayout(resLevel, computeFlags);
        this.reset();
        return layout;
    }

    @Nonnull
    private TextLayout createNewLayout(int resLevel, int computeFlags) {
        if (!this.mBuilder.isEmpty()) {
            int[] lineBoundaries;
            float[] advances;
            this.mFontPaint.setLocale(ModernUI.getSelectedLocale());
            this.mComputeAdvances = (computeFlags & 1) != 0;
            this.mComputeLineBoundaries = (computeFlags & 4) != 0;
            int fontSize = TextLayoutProcessor.computeFontSize(resLevel);
            this.mFontPaint.setFontSize(fontSize);
            this.mFontPaint.setAntiAlias(GlyphManager.sAntiAliasing);
            this.mFontPaint.setLinearMetrics(GlyphManager.sFractionalMetrics);
            if (this.mComputeAdvances) {
                this.mAdvances.size(this.mBuilder.length());
            }
            char[] textBuf = this.mBuilder.toCharArray();
            this.analyzeBidi(textBuf);
            float[] positions = this.mPositions.toFloatArray();
            int i = 0;
            while (i < positions.length) {
                int n = i++;
                positions[n] = positions[n] / (float)resLevel;
            }
            byte[] fontIndices = this.mFontVec.size() > 1 ? this.mFontIndices.toByteArray() : null;
            if (this.mComputeAdvances) {
                advances = this.mAdvances.toFloatArray();
                int i2 = 0;
                while (i2 < this.mBuilder.length()) {
                    int n = i2++;
                    advances[n] = advances[n] / (float)resLevel;
                }
            } else {
                advances = null;
            }
            if (this.mComputeLineBoundaries) {
                lineBoundaries = this.mLineBoundaries.toIntArray();
                Arrays.sort(lineBoundaries);
            } else {
                lineBoundaries = null;
            }
            this.mTotalAdvance /= (float)resLevel;
            return new TextLayout(textBuf, this.mGlyphs.toIntArray(), positions, fontIndices, this.mFontVec.toArray(new Font[0]), advances, this.mGlyphFlags.toIntArray(), lineBoundaries, this.mTotalAdvance, this.mHasEffect, this.mHasColorEmoji, resLevel, computeFlags);
        }
        return TextLayout.makeEmpty();
    }

    private void analyzeBidi(@Nonnull char[] text) {
        TextDirectionHeuristic dir = this.mEngine.getTextDirectionHeuristic();
        if (!(dir != TextDirectionHeuristics.LTR && dir != TextDirectionHeuristics.FIRSTSTRONG_LTR && dir != TextDirectionHeuristics.ANYRTL_LTR || Bidi.requiresBidi((char[])text, (int)0, (int)text.length))) {
            this.handleBidiRun(text, 0, text.length, false);
        } else {
            boolean isRtl;
            byte paraLevel = dir == TextDirectionHeuristics.LTR ? (byte)0 : (dir == TextDirectionHeuristics.RTL ? (byte)1 : (dir == TextDirectionHeuristics.FIRSTSTRONG_LTR ? (byte)126 : (dir == TextDirectionHeuristics.FIRSTSTRONG_RTL ? (byte)127 : ((isRtl = dir.isRtl(text, 0, text.length)) ? (byte)1 : 0))));
            Bidi bidi = new Bidi(text.length, 0);
            bidi.setPara(text, paraLevel, null);
            if (bidi.isRightToLeft()) {
                this.handleBidiRun(text, 0, text.length, true);
            } else if (bidi.isLeftToRight()) {
                this.handleBidiRun(text, 0, text.length, false);
            } else {
                int runCount = bidi.getRunCount();
                for (int visualIndex = 0; visualIndex < runCount; ++visualIndex) {
                    BidiRun run = bidi.getVisualRun(visualIndex);
                    this.handleBidiRun(text, run.getStart(), run.getLimit(), run.isOddRun());
                }
            }
        }
    }

    private void handleBidiRun(@Nonnull char[] text, int start, int limit, boolean isRtl) {
        assert (start < limit);
        IntArrayList styles = this.mStyles;
        ArrayList<class_2960> fonts = this.mFontNames;
        if (isRtl) {
            int currPos;
            int lastPos = limit - 1;
            int lastStyle = styles.getInt(lastPos);
            class_2960 lastFont = (class_2960)fonts.get(lastPos);
            for (currPos = limit - 2; currPos >= start; --currPos) {
                int currStyle = styles.getInt(currPos);
                class_2960 currFont = (class_2960)fonts.get(currPos);
                if (currStyle == lastStyle && currFont.equals((Object)lastFont)) continue;
                this.handleStyleRun(text, currPos + 1, lastPos + 1, true, lastStyle, lastFont);
                lastPos = currPos;
                lastStyle = currStyle;
                lastFont = currFont;
            }
            assert (currPos + 1 == start);
            this.handleStyleRun(text, currPos + 1, lastPos + 1, true, lastStyle, lastFont);
        } else {
            int currPos;
            int lastPos = start;
            int lastStyle = styles.getInt(lastPos);
            class_2960 lastFont = (class_2960)fonts.get(lastPos);
            for (currPos = start + 1; currPos < limit; ++currPos) {
                int currStyle = styles.getInt(currPos);
                class_2960 currFont = (class_2960)fonts.get(currPos);
                if (currStyle == lastStyle && currFont.equals((Object)lastFont)) continue;
                this.handleStyleRun(text, lastPos, currPos, false, lastStyle, lastFont);
                lastPos = currPos;
                lastStyle = currStyle;
                lastFont = currFont;
            }
            assert (currPos == limit);
            this.handleStyleRun(text, lastPos, currPos, false, lastStyle, lastFont);
        }
    }

    private void handleStyleRun(@Nonnull char[] text, int start, int limit, boolean isRtl, int styleFlags, class_2960 fontName) {
        int fontStyle = 0;
        if ((styleFlags & 0x1000000) != 0) {
            fontStyle |= 1;
        }
        if ((styleFlags & 0x2000000) != 0) {
            fontStyle |= 2;
        }
        this.mFontPaint.setFont(this.mEngine.getFontCollection(fontName));
        this.mFontPaint.setFontStyle(fontStyle);
        int glyphStart = this.mGlyphs.size();
        float advance = ShapedText.doLayoutRun(text, start, limit, start, limit, isRtl, this.mFontPaint, 0, this.mComputeAdvances ? this.mAdvances.elements() : null, this.mTotalAdvance, this.mGlyphs, this.mPositions, this.mFontIndices, f -> this.mFontMap.computeIfAbsent((Font)f, this.mNextID), null, null);
        int glyphEnd = this.mGlyphs.size();
        for (int glyphIndex = glyphStart; glyphIndex < glyphEnd; ++glyphIndex) {
            this.mHasEffect |= (styleFlags & 0xC000000) != 0;
            int glyphFlags = styleFlags;
            Font font = this.mFontVec.get(this.mFontIndices.getByte(glyphIndex) & 0xFF);
            if (font instanceof BitmapFont) {
                glyphFlags |= 0x40000000;
            } else if (font instanceof EmojiFont) {
                glyphFlags |= 0x20000000;
                this.mHasColorEmoji = true;
            }
            this.mGlyphFlags.add(glyphFlags);
        }
        this.mTotalAdvance += advance;
        if (this.mComputeLineBoundaries) {
            int currPos;
            BreakIterator breaker = BreakIterator.getLineInstance((ULocale)LineBreaker.getLocaleWithLineBreakOption(this.mFontPaint.getLocale(), sLbStyle, sLbWordStyle));
            CharArrayIterator charIterator = new CharArrayIterator(text, start, limit);
            breaker.setText((CharacterIterator)charIterator);
            int prevPos = start;
            while ((currPos = breaker.following(prevPos)) != -1) {
                this.mLineBoundaries.add(currPos);
                prevPos = currPos;
            }
        }
    }
}

