/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import icyllis.modernui.graphics.text.Font;
import icyllis.modernui.graphics.text.FontCollection;
import icyllis.modernui.graphics.text.FontFamily;
import icyllis.modernui.graphics.text.FontPaint;
import icyllis.modernui.graphics.text.OutlineFont;
import icyllis.modernui.mc.text.BitmapFont;
import icyllis.modernui.mc.text.GLBakedGlyph;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.ModernTextRenderer;
import icyllis.modernui.mc.text.SpaceFont;
import icyllis.modernui.mc.text.TextLayoutProcessor;
import icyllis.modernui.mc.text.TextRenderType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_377;
import net.minecraft.class_379;
import net.minecraft.class_382;
import net.minecraft.class_383;
import net.minecraft.class_384;
import net.minecraft.class_7191;
import net.minecraft.class_8532;
import net.minecraft.class_8538;
import org.jetbrains.annotations.Unmodifiable;

public class StandardFontSet
extends class_377 {
    private @Unmodifiable List<FontFamily> mFamilies = Collections.emptyList();
    private class_8532<class_382> mGlyphs;
    private final IntFunction<class_382> mCacheGlyph = this::cacheGlyph;
    private class_8532<class_379> mGlyphInfos;
    private final IntFunction<class_379> mCacheGlyphInfo = this::cacheGlyphInfo;
    private float mResLevel = 2.0f;
    private final FontPaint mStandardPaint = new FontPaint();

    public StandardFontSet(@Nonnull class_1060 texMgr, @Nonnull class_2960 fontName) {
        super(texMgr, fontName);
        this.mStandardPaint.setFontStyle(0);
        this.mStandardPaint.setLocale(Locale.ROOT);
    }

    public void reload(@Nonnull FontCollection fontCollection, int newResLevel) {
        super.method_2004(Collections.emptyList());
        this.mFamilies = fontCollection.getFamilies();
        this.invalidateCache(newResLevel);
    }

    public void invalidateCache(int newResLevel) {
        if (this.mGlyphs != null) {
            this.mGlyphs.method_51597();
        }
        if (this.mGlyphInfos != null) {
            this.mGlyphInfos.method_51597();
        }
        int fontSize = TextLayoutProcessor.computeFontSize(newResLevel);
        this.mStandardPaint.setFontSize(fontSize);
        this.mStandardPaint.setAntiAlias(GlyphManager.sAntiAliasing);
        this.mStandardPaint.setLinearMetrics(GlyphManager.sFractionalMetrics);
        this.mResLevel = newResLevel;
    }

    @Nonnull
    private class_379 cacheGlyphInfo(int codePoint) {
        for (FontFamily family : this.mFamilies) {
            OutlineFont outlineFont;
            if (!family.hasGlyph(codePoint)) continue;
            Font font = family.getClosestMatch(0);
            if (font instanceof BitmapFont) {
                BitmapFont bitmapFont = (BitmapFont)font;
                BitmapFont.Glyph glyph = bitmapFont.getGlyph(codePoint);
                if (glyph == null) continue;
                return glyph;
            }
            if (font instanceof SpaceFont) {
                SpaceFont spaceFont = (SpaceFont)font;
                float adv = spaceFont.getAdvance(codePoint);
                if (Float.isNaN(adv)) continue;
                return () -> adv;
            }
            if (!(font instanceof OutlineFont) || !(outlineFont = (OutlineFont)font).hasGlyph(codePoint, 0)) continue;
            char[] chars = Character.toChars(codePoint);
            float adv = outlineFont.doSimpleLayout(chars, 0, chars.length, this.mStandardPaint, null, null, 0.0f, 0.0f);
            return new StandardGlyphInfo((int)(adv / this.mResLevel + 0.95f));
        }
        return class_7191.field_37899;
    }

    @Nonnull
    public class_379 method_2011(int codePoint, boolean notFishy) {
        if (this.mGlyphInfos == null) {
            this.mGlyphInfos = new class_8532(class_379[]::new, x$0 -> new class_379[x$0][]);
        }
        return (class_379)this.mGlyphInfos.method_51600(codePoint, this.mCacheGlyphInfo);
    }

    @Nonnull
    private class_382 cacheGlyph(int codePoint) {
        for (FontFamily family : this.mFamilies) {
            GLBakedGlyph glyph;
            if (!family.hasGlyph(codePoint)) continue;
            Font font = family.getClosestMatch(0);
            if (font instanceof BitmapFont) {
                BitmapFont bitmapFont = (BitmapFont)font;
                GLBakedGlyph glyph2 = GlyphManager.getInstance().lookupGlyph(bitmapFont, (int)this.mStandardPaint.getFontSize(), codePoint);
                if (glyph2 != null) {
                    float up = 10.0f + (float)glyph2.y / 8.0f;
                    float left = (float)glyph2.x / 8.0f;
                    float right = left + (float)glyph2.width / 8.0f;
                    float down = up + (float)glyph2.height / 8.0f;
                    return new StandardBakedGlyph(bitmapFont, glyph2.u1, glyph2.u2, glyph2.v1, glyph2.v2, left, right, up, down);
                }
                return class_384.field_38311;
            }
            if (font instanceof SpaceFont) {
                return class_384.field_38311;
            }
            if (!(font instanceof OutlineFont)) continue;
            OutlineFont outlineFont = (OutlineFont)font;
            char[] chars = Character.toChars(codePoint);
            IntArrayList glyphs = new IntArrayList(1);
            float adv = outlineFont.doSimpleLayout(chars, 0, chars.length, this.mStandardPaint, glyphs, null, 0.0f, 0.0f);
            if (glyphs.size() == 1 && glyphs.getInt(0) != 0 && (glyph = GlyphManager.getInstance().lookupGlyph(outlineFont, (int)this.mStandardPaint.getFontSize(), glyphs.getInt(0))) != null) {
                float up = 10.0f + (float)glyph.y / this.mResLevel;
                float left = (float)glyph.x / this.mResLevel;
                float right = left + (float)glyph.width / this.mResLevel;
                float down = up + (float)glyph.height / this.mResLevel;
                return new StandardBakedGlyph(null, glyph.u1, glyph.u2, glyph.v1, glyph.v2, left, right, up, down);
            }
            if (!(adv > 0.0f)) continue;
            return class_384.field_38311;
        }
        return super.method_2014(codePoint);
    }

    @Nonnull
    public class_382 method_2014(int codePoint) {
        if (this.mGlyphs == null) {
            this.mGlyphs = new class_8532(class_382[]::new, x$0 -> new class_382[x$0][]);
        }
        return (class_382)this.mGlyphs.method_51600(codePoint, this.mCacheGlyph);
    }

    public static class StandardGlyphInfo
    implements class_379 {
        private final float mAdvance;

        public StandardGlyphInfo(int advance) {
            this.mAdvance = advance;
        }

        public float getAdvance() {
            return this.mAdvance;
        }

        public float method_16799() {
            return 0.5f;
        }

        public float method_16800() {
            return ModernTextRenderer.sShadowOffset;
        }

        @Nonnull
        public class_382 bake(@Nonnull Function<class_383, class_382> function) {
            return class_384.field_38311;
        }
    }

    public static class StandardBakedGlyph
    extends class_382 {
        private static final class_8538 EMPTY_TYPES = class_8538.method_51643((class_2960)new class_2960(""));
        @Nullable
        private final BitmapFont mBitmapFont;

        public StandardBakedGlyph(@Nullable BitmapFont bitmapFont, float u0, float u1, float v0, float v1, float left, float right, float up, float down) {
            super(EMPTY_TYPES, u0, u1, v0, v1, left, right, up, down);
            this.mBitmapFont = bitmapFont;
        }

        @Nonnull
        public class_1921 method_24045(@Nonnull class_327.class_6415 mode) {
            if (this.mBitmapFont != null) {
                return TextRenderType.getOrCreate(GlyphManager.getInstance().getCurrentTexture(this.mBitmapFont), mode, true);
            }
            return TextRenderType.getOrCreate(GlyphManager.getInstance().getFontTexture(), mode, false);
        }
    }
}

