/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLTexture;
import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.Bitmap;
import icyllis.modernui.graphics.BitmapFactory;
import icyllis.modernui.graphics.text.EmojiFont;
import icyllis.modernui.graphics.text.OutlineFont;
import icyllis.modernui.mc.text.BitmapFont;
import icyllis.modernui.mc.text.GLBakedGlyph;
import icyllis.modernui.mc.text.GLFontAtlas;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;

public class GlyphManager {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Glyph");
    public static final int GLYPH_BORDER = 2;
    public static final int IMAGE_SIZE = 256;
    private static final Color BG_COLOR = new Color(0, 0, 0, 0);
    public static volatile boolean sAntiAliasing = true;
    public static volatile boolean sFractionalMetrics = true;
    public static final int EMOJI_SIZE = 72;
    public static final int EMOJI_ASCENT = 56;
    public static final int EMOJI_SPACING = 4;
    public static final int EMOJI_BASE = 64;
    private static volatile GlyphManager sInstance;
    private GLFontAtlas mFontAtlas;
    private GLFontAtlas mEmojiAtlas;
    private GLFontAtlas mBitmapAtlas;
    private GLDevice mDevice;
    private HashMap<Font, GlyphStrike> mFontTable = new HashMap();
    private final Function<Font, GlyphStrike> mFontTableMapper = f -> new GlyphStrike(this.mFontTable.size() + 1);
    private final Object2IntOpenHashMap<EmojiFont> mEmojiFontTable = new Object2IntOpenHashMap();
    private final ToIntFunction<EmojiFont> mEmojiFontTableMapper = f -> this.mEmojiFontTable.size() + 1;
    private HashMap<BitmapFont, GlyphStrike> mBitmapFontTable = new HashMap();
    private final Function<BitmapFont, GlyphStrike> mBitmapFontTableMapper = f -> new GlyphStrike(this.mBitmapFontTable.size() + 1);
    private BufferedImage mImage;
    private Graphics2D mGraphics;
    private int[] mImageData;
    private ByteBuffer mImageBuffer;
    private final CopyOnWriteArrayList<Consumer<AtlasInvalidationInfo>> mAtlasInvalidationCallbacks = new CopyOnWriteArrayList();

    private GlyphManager() {
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static GlyphManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<GlyphManager> clazz = GlyphManager.class;
        synchronized (GlyphManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new GlyphManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @RenderThread
    public void closeAtlases() {
        if (this.mFontAtlas != null) {
            this.mFontAtlas.close();
        }
        if (this.mEmojiAtlas != null) {
            this.mEmojiAtlas.close();
        }
        if (this.mBitmapAtlas != null) {
            this.mBitmapAtlas.close();
        }
        this.mFontAtlas = null;
        this.mEmojiAtlas = null;
        this.mBitmapAtlas = null;
    }

    @RenderThread
    public void reload() {
        this.closeAtlases();
        this.mFontTable.values().forEach(s -> s.mFastCharMap.clear());
        this.mFontTable.clear();
        this.mFontTable = new HashMap();
        this.mEmojiFontTable.clear();
        this.mEmojiFontTable.trim();
        this.mBitmapFontTable.values().forEach(s -> s.mFastCharMap.clear());
        this.mBitmapFontTable.clear();
        this.mBitmapFontTable = new HashMap();
        this.allocateImage();
    }

    @Nonnull
    public GlyphVector layoutGlyphVector(@Nonnull Font awtFont, @Nonnull char[] text, int start, int limit, boolean isRtl) {
        return awtFont.layoutGlyphVector(this.mGraphics.getFontRenderContext(), text, start, limit, isRtl ? 1 : 0);
    }

    @Nonnull
    public GlyphVector createGlyphVector(@Nonnull Font awtFont, @Nonnull char[] text) {
        return awtFont.createGlyphVector(this.mGraphics.getFontRenderContext(), text);
    }

    private long computeGlyphKey(@Nonnull Font awtFont, int glyphCode) {
        long fontKey = this.mFontTable.computeIfAbsent((Font)awtFont, this.mFontTableMapper).mStrikeId;
        return fontKey << 32 | (long)glyphCode;
    }

    private long computeEmojiKey(@Nonnull EmojiFont font, int glyphId) {
        long fontKey = this.mEmojiFontTable.computeIfAbsent((Object)font, this.mEmojiFontTableMapper);
        return fontKey << 32 | (long)glyphId;
    }

    private long computeBitmapGlyphKey(@Nonnull BitmapFont font, int glyphId) {
        long fontKey = this.mBitmapFontTable.computeIfAbsent((BitmapFont)font, this.mBitmapFontTableMapper).mStrikeId;
        return fontKey << 32 | (long)glyphId;
    }

    @Nullable
    @RenderThread
    public GLBakedGlyph lookupGlyph(@Nonnull icyllis.modernui.graphics.text.Font font, int fontSize, int glyphId) {
        if (font instanceof OutlineFont) {
            GLBakedGlyph glyph;
            Font awtFont = ((OutlineFont)font).chooseFont(fontSize);
            long key = this.computeGlyphKey(awtFont, glyphId);
            if (this.mFontAtlas == null) {
                ImmediateContext context = Core.requireImmediateContext();
                this.mFontAtlas = new GLFontAtlas(context, 0, 2, true);
                this.mDevice = (GLDevice)context.getDevice();
            }
            if ((glyph = this.mFontAtlas.getGlyph(key)) != null && glyph.x == Integer.MIN_VALUE) {
                return this.cacheGlyph(awtFont, glyphId, this.mFontAtlas, glyph, key);
            }
            return glyph;
        }
        if (font instanceof EmojiFont) {
            GLBakedGlyph glyph;
            EmojiFont emojiFont = (EmojiFont)font;
            long key = this.computeEmojiKey(emojiFont, glyphId);
            if (this.mEmojiAtlas == null) {
                ImmediateContext context = Core.requireImmediateContext();
                this.mEmojiAtlas = new GLFontAtlas(context, 2, 0, true);
                this.mDevice = (GLDevice)context.getDevice();
            }
            if ((glyph = this.mEmojiAtlas.getGlyph(key)) != null && glyph.x == Integer.MIN_VALUE) {
                return this.cacheEmoji(emojiFont, glyphId, this.mEmojiAtlas, glyph, key);
            }
            return glyph;
        }
        if (font instanceof BitmapFont) {
            BitmapFont bitmapFont = (BitmapFont)font;
            if (bitmapFont.nothingToDraw()) {
                return null;
            }
            if (bitmapFont.fitsInAtlas()) {
                GLBakedGlyph glyph;
                long key = this.computeBitmapGlyphKey(bitmapFont, glyphId);
                if (this.mBitmapAtlas == null) {
                    ImmediateContext context = Core.requireImmediateContext();
                    this.mBitmapAtlas = new GLFontAtlas(context, 2, 0, false);
                    this.mDevice = (GLDevice)context.getDevice();
                }
                if ((glyph = this.mBitmapAtlas.getGlyph(key)) != null && glyph.x == Integer.MIN_VALUE) {
                    return this.cacheBitmapGlyph(bitmapFont, glyphId, this.mBitmapAtlas, glyph, key);
                }
                return glyph;
            }
            return bitmapFont.getBakedGlyph(glyphId);
        }
        return null;
    }

    @RenderThread
    public int getCurrentTexture(int maskFormat) {
        GLTexture texture;
        if (maskFormat == 0) {
            GLTexture texture2;
            if (this.mFontAtlas != null && (texture2 = this.mFontAtlas.mTexture) != null) {
                this.mDevice.generateMipmaps(texture2);
                return texture2.getHandle();
            }
        } else if (maskFormat == 2 && this.mEmojiAtlas != null && (texture = this.mEmojiAtlas.mTexture) != null) {
            this.mDevice.generateMipmaps(texture);
            return texture.getHandle();
        }
        return 0;
    }

    public int getFontTexture() {
        return this.getCurrentTexture(0);
    }

    public int getEmojiTexture() {
        return this.getCurrentTexture(2);
    }

    @RenderThread
    public int getCurrentTexture(BitmapFont font) {
        if (font.nothingToDraw()) {
            return 0;
        }
        if (font.fitsInAtlas()) {
            GLTexture texture;
            if (this.mBitmapAtlas != null && (texture = this.mBitmapAtlas.mTexture) != null) {
                return texture.getHandle();
            }
        } else {
            return font.getCurrentTexture();
        }
        return 0;
    }

    @RenderThread
    public void compact() {
        AtlasInvalidationInfo info;
        boolean didWork = false;
        if (this.mFontAtlas != null && this.mFontAtlas.compact()) {
            info = new AtlasInvalidationInfo(0, false);
            for (Consumer<AtlasInvalidationInfo> callback : this.mAtlasInvalidationCallbacks) {
                callback.accept(info);
            }
            didWork = true;
        }
        if (this.mEmojiAtlas != null && this.mEmojiAtlas.compact()) {
            info = new AtlasInvalidationInfo(2, false);
            for (Consumer<AtlasInvalidationInfo> callback : this.mAtlasInvalidationCallbacks) {
                callback.accept(info);
            }
            didWork = true;
        }
        if (this.mBitmapAtlas != null && this.mBitmapAtlas.compact()) {
            info = new AtlasInvalidationInfo(2, false);
            for (Consumer<AtlasInvalidationInfo> callback : this.mAtlasInvalidationCallbacks) {
                callback.accept(info);
            }
            didWork = true;
        }
        if (didWork) {
            for (GlyphStrike glyphStrike : this.mFontTable.values()) {
                for (FastCharSet fastCharSet : glyphStrike.mFastCharMap.values()) {
                    fastCharSet.glyphs.removeIf(glyph -> glyph.x == Integer.MIN_VALUE);
                }
            }
            for (GlyphStrike glyphStrike : this.mBitmapFontTable.values()) {
                for (FastCharSet fastCharSet : glyphStrike.mFastCharMap.values()) {
                    fastCharSet.glyphs.removeIf(glyph -> glyph.x == Integer.MIN_VALUE);
                }
            }
        }
    }

    public void debug() {
        GlyphManager.debug(this.mFontAtlas, "FontAtlas");
        GlyphManager.debug(this.mEmojiAtlas, "EmojiAtlas");
        GlyphManager.debug(this.mBitmapAtlas, "BitmapAtlas");
    }

    private static void debug(GLFontAtlas atlas, String name) {
        if (atlas != null) {
            String path = Bitmap.saveDialogGet(Bitmap.SaveFormat.PNG, null, name);
            atlas.debug(name, path);
        }
    }

    public void dumpInfo(PrintWriter pw) {
        if (this.mFontAtlas != null) {
            this.mFontAtlas.dumpInfo(pw, "FontAtlas");
        }
        if (this.mEmojiAtlas != null) {
            this.mEmojiAtlas.dumpInfo(pw, "EmojiAtlas");
        }
        if (this.mBitmapAtlas != null) {
            this.mBitmapAtlas.dumpInfo(pw, "BitmapAtlas");
        }
    }

    @Nullable
    @RenderThread
    private GLBakedGlyph cacheGlyph(@Nonnull Font font, int glyphCode, @Nonnull GLFontAtlas atlas, @Nonnull GLBakedGlyph glyph, long key) {
        long src;
        boolean invalidated;
        GlyphVector vector = font.createGlyphVector(this.mGraphics.getFontRenderContext(), new int[]{glyphCode});
        Rectangle bounds = vector.getPixelBounds(null, 0.0f, 0.0f);
        if (bounds.width == 0 || bounds.height == 0) {
            atlas.setNoPixels(key);
            return null;
        }
        glyph.x = bounds.x;
        glyph.y = bounds.y;
        glyph.width = (short)bounds.width;
        glyph.height = (short)bounds.height;
        int borderedWidth = bounds.width + 4;
        int borderedHeight = bounds.height + 4;
        if (borderedWidth > this.mImage.getWidth() || borderedHeight > this.mImage.getHeight()) {
            atlas.setNoPixels(key);
            return null;
        }
        this.mGraphics.drawGlyphVector(vector, 2 - bounds.x, 2 - bounds.y);
        this.mImage.getRGB(0, 0, borderedWidth, borderedHeight, this.mImageData, 0, borderedWidth);
        int size = borderedWidth * borderedHeight;
        if (atlas.getMaskFormat() == 0) {
            for (i = 0; i < size; ++i) {
                this.mImageBuffer.put((byte)(this.mImageData[i] >>> 24));
            }
        } else {
            for (i = 0; i < size; ++i) {
                this.mImageBuffer.put((byte)-1).put((byte)-1).put((byte)-1).put((byte)(this.mImageData[i] >>> 24));
            }
        }
        if (invalidated = atlas.stitch(glyph, src = MemoryUtil.memAddress((ByteBuffer)this.mImageBuffer.flip()))) {
            AtlasInvalidationInfo info = new AtlasInvalidationInfo(0, true);
            for (Consumer<AtlasInvalidationInfo> callback : this.mAtlasInvalidationCallbacks) {
                callback.accept(info);
            }
        }
        int standardWidth = GlyphManager.computeStandardWidth(glyph, font.getSize());
        ((FastCharSet)this.mFontTable.get((Object)font).mFastCharMap.computeIfAbsent((int)standardWidth, (Int2ObjectFunction)(Int2ObjectFunction)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$cacheGlyph$7(int ), (I)Licyllis/modernui/mc/text/GlyphManager$FastCharSet;)())).glyphs.add(glyph);
        this.mGraphics.clearRect(0, 0, this.mImage.getWidth(), this.mImage.getHeight());
        this.mImageBuffer.clear();
        return glyph;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @RenderThread
    private GLBakedGlyph cacheEmoji(@Nonnull EmojiFont font, int glyphId, @Nonnull GLFontAtlas atlas, @Nonnull GLBakedGlyph glyph, long key) {
        if (glyphId == 0) {
            atlas.setNoPixels(key);
            return null;
        }
        String path = "emoji/" + font.getFileName(glyphId);
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inPreferredFormat = Bitmap.Format.RGBA_8888;
        try (InputStream inputStream = ModernUI.getInstance().getResourceStream("modernui", path);){
            Bitmap bitmap;
            block21: {
                bitmap = BitmapFactory.decodeStream(inputStream, opts);
                try {
                    if (bitmap.getWidth() != 72 || bitmap.getHeight() != 72) break block21;
                    long src = bitmap.getAddress();
                    glyph.x = 0;
                    glyph.y = -56;
                    glyph.width = (short)72;
                    glyph.height = (short)72;
                    boolean invalidated = atlas.stitch(glyph, src);
                    if (invalidated) {
                        AtlasInvalidationInfo info = new AtlasInvalidationInfo(2, true);
                        for (Consumer<AtlasInvalidationInfo> callback : this.mAtlasInvalidationCallbacks) {
                            callback.accept(info);
                        }
                    }
                    GLBakedGlyph gLBakedGlyph = glyph;
                    if (bitmap != null) {
                        bitmap.close();
                    }
                    return gLBakedGlyph;
                }
                catch (Throwable throwable) {
                    if (bitmap != null) {
                        try {
                            bitmap.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            atlas.setNoPixels(key);
            ModernUI.LOGGER.warn(MARKER, "Emoji is not {}x{}: {} {}", (Object)72, (Object)72, (Object)font.getFamilyName(), (Object)path);
            GLBakedGlyph gLBakedGlyph = null;
            if (bitmap != null) {
                bitmap.close();
            }
            return gLBakedGlyph;
        }
        catch (Exception e) {
            atlas.setNoPixels(key);
            ModernUI.LOGGER.warn(MARKER, "Failed to load emoji: {} {}", (Object)font.getFamilyName(), (Object)path, (Object)e);
            return null;
        }
    }

    @Nullable
    @RenderThread
    private GLBakedGlyph cacheBitmapGlyph(@Nonnull BitmapFont font, int glyphId, @Nonnull GLFontAtlas atlas, @Nonnull GLBakedGlyph glyph, long key) {
        long src = MemoryUtil.memAddress((ByteBuffer)this.mImageBuffer);
        if (!font.getGlyphImage(glyphId, src)) {
            atlas.setNoPixels(key);
            return null;
        }
        glyph.width = (short)font.getSpriteWidth();
        glyph.height = (short)font.getSpriteHeight();
        boolean invalidated = atlas.stitch(glyph, src);
        font.setGlyphMetrics(glyph);
        if (invalidated) {
            AtlasInvalidationInfo info = new AtlasInvalidationInfo(2, true);
            for (Consumer<AtlasInvalidationInfo> callback : this.mAtlasInvalidationCallbacks) {
                callback.accept(info);
            }
        }
        BitmapFont.Glyph glyphInfo = font.getGlyph(glyphId);
        assert (glyphInfo != null);
        int standardWidth = (int)glyphInfo.advance;
        ((FastCharSet)this.mBitmapFontTable.get((Object)font).mFastCharMap.computeIfAbsent((int)standardWidth, (Int2ObjectFunction)(Int2ObjectFunction)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$cacheBitmapGlyph$8(int ), (I)Licyllis/modernui/mc/text/GlyphManager$FastCharSet;)())).glyphs.add(glyph);
        return glyph;
    }

    private void allocateImage() {
        this.mImage = new BufferedImage(256, 256, 2);
        this.mGraphics = this.mImage.createGraphics();
        this.mImageData = new int[65536];
        this.mImageBuffer = BufferUtils.createByteBuffer((int)(this.mImageData.length * 4));
        this.mGraphics.setBackground(BG_COLOR);
        this.mGraphics.setComposite(AlphaComposite.Src);
        this.mGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (sAntiAliasing) {
            this.mGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            this.mGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (sFractionalMetrics) {
            this.mGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else {
            this.mGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
    }

    @Nullable
    public FastCharSet lookupFastChars(@Nonnull icyllis.modernui.graphics.text.Font font, int fontSize, int glyphId) {
        if (!(font instanceof OutlineFont) && !(font instanceof BitmapFont)) {
            return null;
        }
        GLBakedGlyph glyph = this.lookupGlyph(font, fontSize, glyphId);
        if (glyph == null) {
            return null;
        }
        if (font instanceof OutlineFont) {
            Font awtFont = ((OutlineFont)font).chooseFont(fontSize);
            GlyphStrike strike = this.mFontTable.get(awtFont);
            if (!strike.mPreloadedFastChars) {
                this.cacheFastChars(font, fontSize, awtFont);
                strike.mPreloadedFastChars = true;
            }
            int standardWidth = GlyphManager.computeStandardWidth(glyph, awtFont.getSize());
            return (FastCharSet)strike.mFastCharMap.get(standardWidth);
        }
        BitmapFont bitmapFont = (BitmapFont)font;
        GlyphStrike strike = this.mBitmapFontTable.get(bitmapFont);
        if (!strike.mPreloadedFastChars) {
            this.cacheFastChars(bitmapFont);
            strike.mPreloadedFastChars = true;
        }
        BitmapFont.Glyph glyphInfo = bitmapFont.getGlyph(glyphId);
        assert (glyphInfo != null);
        int standardWidth = (int)glyphInfo.advance;
        return (FastCharSet)strike.mFastCharMap.get(standardWidth);
    }

    private void cacheFastChars(@Nonnull icyllis.modernui.graphics.text.Font font, int fontSize, @Nonnull Font awtFont) {
        GlyphManager.forEachRandomGlyph(33, 127, 62, ch -> {
            char[] chars = new char[]{(char)ch};
            GlyphVector vector = this.createGlyphVector(awtFont, chars);
            if (vector.getNumGlyphs() == 1 && vector.getGlyphCode(0) != awtFont.getMissingGlyphCode()) {
                this.lookupGlyph(font, fontSize, vector.getGlyphCode(0));
            }
        });
        GlyphManager.forEachRandomGlyph(0, awtFont.getNumGlyphs(), 127, glyph -> {
            if (glyph != awtFont.getMissingGlyphCode()) {
                this.lookupGlyph(font, fontSize, glyph);
            }
        });
    }

    private void cacheFastChars(@Nonnull BitmapFont font) {
        int[][] grid = font.getCodepointGrid();
        int cols = grid[0].length;
        GlyphManager.forEachRandomGlyph(0, grid.length * cols, 160, idx -> {
            int ch = grid[idx / cols][idx % cols];
            if (ch != 0) {
                this.lookupGlyph(font, 8, ch);
            }
        });
    }

    static int computeStandardWidth(@Nonnull GLBakedGlyph glyph, int fontSize) {
        int multiple = (fontSize + 4) / 8;
        return Math.round((float)glyph.width / (float)multiple) * multiple;
    }

    static void forEachRandomGlyph(int start, int end, int needed, IntConsumer action) {
        assert (needed > 0);
        Random rand = new Random();
        int remaining = end - start;
        for (int glyph = start; glyph < end; ++glyph) {
            if (rand.nextInt(remaining) < needed) {
                action.accept(glyph);
                if (--needed == 0) break;
            }
            --remaining;
        }
    }

    public void addAtlasInvalidationCallback(Consumer<AtlasInvalidationInfo> callback) {
        this.mAtlasInvalidationCallbacks.add(Objects.requireNonNull(callback));
    }

    public void removeAtlasInvalidationCallback(Consumer<AtlasInvalidationInfo> callback) {
        this.mAtlasInvalidationCallbacks.remove(Objects.requireNonNull(callback));
    }

    private static /* synthetic */ FastCharSet lambda$cacheBitmapGlyph$8(int __) {
        return new FastCharSet();
    }

    private static /* synthetic */ FastCharSet lambda$cacheGlyph$7(int __) {
        return new FastCharSet();
    }

    private static class GlyphStrike {
        final int mStrikeId;
        final Int2ObjectOpenHashMap<FastCharSet> mFastCharMap = new Int2ObjectOpenHashMap(1);
        boolean mPreloadedFastChars = false;

        GlyphStrike(int strikeId) {
            this.mStrikeId = strikeId;
        }
    }

    public record AtlasInvalidationInfo(int maskFormat, boolean resize) {
    }

    public static class FastCharSet
    extends GLBakedGlyph {
        public final ArrayList<GLBakedGlyph> glyphs = new ArrayList(1);
    }
}

