/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import icyllis.modernui.core.Core;
import icyllis.modernui.core.Handler;
import icyllis.modernui.graphics.ImageStore;
import icyllis.modernui.mc.BlurHandler;
import icyllis.modernui.mc.FontResourceManager;
import icyllis.modernui.mc.GuiRenderType;
import icyllis.modernui.mc.ModernUIClient;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.OptiFineIntegration;
import icyllis.modernui.mc.UIManager;
import icyllis.modernui.mc.fabric.Config;
import icyllis.modernui.mc.fabric.EventHandler;
import icyllis.modernui.mc.fabric.UIManagerFabric;
import icyllis.modernui.mc.mixin.AccessOptions;
import icyllis.modernui.mc.text.MuiTextCommand;
import icyllis.modernui.mc.text.TextLayoutEngine;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1076;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_5699;
import net.minecraft.class_7172;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Environment(value=EnvType.CLIENT)
public class ModernUIFabricClient
extends ModernUIClient
implements ClientModInitializer {
    public static final Event<Runnable> START_RENDER_TICK = EventFactory.createArrayBacked(Runnable.class, callbacks -> () -> {
        for (Runnable runnable : callbacks) {
            runnable.run();
        }
    });
    public static final Event<Runnable> END_RENDER_TICK = EventFactory.createArrayBacked(Runnable.class, callbacks -> () -> {
        for (Runnable runnable : callbacks) {
            runnable.run();
        }
    });
    private String mSelectedLanguageCode;
    private Locale mSelectedJavaLocale;

    public void onInitializeClient() {
        START_RENDER_TICK.register(EventHandler.Client::onRenderTick);
        END_RENDER_TICK.register(EventHandler.Client::onRenderTick);
        KeyBindingHelper.registerKeyBinding((class_304)UIManagerFabric.OPEN_CENTER_KEY);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return ModernUIMod.location("client");
            }

            public void method_14491(@Nonnull class_3300 resourceManager) {
                ImageStore.getInstance().clear();
                Handler handler = Core.getUiHandlerAsync();
                if (handler != null) {
                    handler.post(() -> UIManager.getInstance().updateLayoutDir((Boolean)Config.CLIENT.mForceRtl.get()));
                }
                BlurHandler.INSTANCE.loadEffect();
            }
        });
        CoreShaderRegistrationCallback.EVENT.register(context -> {
            try {
                context.register(ModernUIMod.location("rendertype_modern_tooltip"), class_290.field_1592, GuiRenderType::setShaderTooltip);
            }
            catch (IOException e) {
                LOGGER.error(MARKER, "Bad tooltip shader", (Throwable)e);
            }
            try {
                context.register(ModernUIMod.location("rendertype_round_rect"), class_290.field_1576, GuiRenderType::setShaderRoundRect);
            }
            catch (IOException e) {
                LOGGER.error(MARKER, "Bad round rect shader", (Throwable)e);
            }
        });
        ModConfigEvents.loading((String)"modernui").register(Config::reloadAnyClient);
        ModConfigEvents.reloading((String)"modernui").register(Config::reloadAnyClient);
        ClientLifecycleEvents.CLIENT_STARTED.register(mc -> {
            UIManagerFabric.initializeRenderer();
            Config.CLIENT.mLastWindowMode.apply();
            if (((Boolean)Config.CLIENT.mUseNewGuiScale.get()).booleanValue()) {
                class_7172 newGuiScale = new class_7172("options.guiScale", class_7172.method_42399(), (caption, value) -> {
                    int r = MuiModApi.calcGuiScales();
                    if (value == 0) {
                        int auto = r >> 4 & 0xF;
                        return class_315.method_41783((class_2561)caption, (class_2561)class_2561.method_43471((String)"options.guiScale.auto").method_10852((class_2561)class_2561.method_43470((String)(" (" + auto + ")"))));
                    }
                    class_5250 valueComponent = class_2561.method_43470((String)value.toString());
                    int min = r >> 8 & 0xF;
                    int max = r & 0xF;
                    if (value < min || value > max) {
                        class_5250 hint = value < min ? class_2561.method_43470((String)(" (<" + min + ")")) : class_2561.method_43470((String)(" (>" + max + ")"));
                        valueComponent.method_10852((class_2561)hint);
                        valueComponent.method_27692(class_124.field_1061);
                    }
                    return class_315.method_41783((class_2561)caption, (class_2561)valueComponent);
                }, (class_7172.class_7178)new GuiScaleValueSet(), (Object)0, value -> class_310.method_1551().method_18858(() -> {
                    class_310 minecraft = class_310.method_1551();
                    if ((int)minecraft.method_22683().method_4495() != minecraft.method_22683().method_4476(value.intValue(), false)) {
                        minecraft.method_15993();
                    }
                }));
                class_315 options = mc.field_1690;
                newGuiScale.method_41748((Object)((Integer)options.method_42474().method_41753()));
                ((AccessOptions)options).setGuiScale((class_7172<Integer>)newGuiScale);
                if (ModernUIMod.isOptiFineLoaded()) {
                    OptiFineIntegration.setGuiScale((class_7172<Integer>)newGuiScale);
                    LOGGER.debug(MARKER, "Override OptiFine Gui Scale");
                }
            }
        });
        Config.initClientConfig(spec -> ForgeConfigRegistry.INSTANCE.register("modernui", ModConfig.Type.CLIENT, (IConfigSpec)spec, "ModernUI/client.toml"));
        Config.initTextConfig(spec -> ForgeConfigRegistry.INSTANCE.register("modernui", ModConfig.Type.CLIENT, (IConfigSpec)spec, "ModernUI/text.toml"));
        FontResourceManager.getInstance();
        if (ModernUIMod.isTextEngineEnabled()) {
            ClientLifecycleEvents.CLIENT_STARTED.register(mc -> MuiModApi.addOnWindowResizeListener(TextLayoutEngine.getInstance()));
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> MuiTextCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
            MuiModApi.addOnDebugDumpListener(TextLayoutEngine.getInstance());
            ClientTickEvents.END_CLIENT_TICK.register(mc -> TextLayoutEngine.getInstance().onEndClientTick());
            LOGGER.info(MARKER, "Initialized Modern UI text engine");
        } else {
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener(new IdentifiableResourceReloadListener(){

                public class_2960 getFabricId() {
                    return ModernUIMod.location("font");
                }

                @Nonnull
                public CompletableFuture<Void> method_25931(@Nonnull class_3302.class_4045 preparationBarrier, @Nonnull class_3300 resourceManager, @Nonnull class_3695 preparationProfiler, @Nonnull class_3695 reloadProfiler, @Nonnull Executor preparationExecutor, @Nonnull Executor reloadExecutor) {
                    return FontResourceManager.getInstance().method_25931(preparationBarrier, resourceManager, preparationProfiler, reloadProfiler, preparationExecutor, reloadExecutor);
                }
            });
        }
        LOGGER.info(MARKER, "Initialized Modern UI client");
    }

    @Override
    @Nonnull
    protected Locale onGetSelectedLocale() {
        class_1076 languageManager;
        class_310 minecraft = class_310.method_1551();
        if (minecraft != null && (languageManager = minecraft.method_1526()) != null) {
            String languageCode = languageManager.method_4669();
            if (!languageCode.equals(this.mSelectedLanguageCode)) {
                this.mSelectedLanguageCode = languageCode;
                String[] langSplit = languageCode.split("_", 2);
                this.mSelectedJavaLocale = langSplit.length == 1 ? new Locale(langSplit[0]) : new Locale(langSplit[0], langSplit[1]);
            }
            return this.mSelectedJavaLocale;
        }
        return super.onGetSelectedLocale();
    }

    static class GuiScaleValueSet
    implements class_7172.class_7275,
    class_7172.class_7306<Integer> {
        GuiScaleValueSet() {
        }

        public int comp_593() {
            return 0;
        }

        public int comp_594() {
            return 8;
        }

        @Nonnull
        public Integer method_42412(double progress) {
            return Math.toIntExact(Math.round(class_3532.method_33722((double)progress, (double)0.0, (double)1.0, (double)this.comp_593(), (double)this.comp_594())));
        }

        @Nonnull
        public Optional<Integer> validateValue(@Nonnull Integer value) {
            return Optional.of(class_3532.method_15340((int)value, (int)this.comp_593(), (int)this.comp_594()));
        }

        @Nonnull
        public Codec<Integer> comp_675() {
            return class_5699.method_48112((Codec)Codec.INT, value -> {
                int max = this.comp_594() + 1;
                if (value.compareTo(this.comp_593()) >= 0 && value.compareTo(max) <= 0) {
                    return DataResult.success((Object)value);
                }
                return DataResult.error(() -> "Value " + value + " outside of range [" + this.comp_593() + ":" + max + "]", (Object)value);
            });
        }

        @Nonnull
        public class_5676.class_5680<Integer> method_42721() {
            return class_5676.class_5680.method_32627(IntStream.range(this.comp_593(), this.comp_594() + 1).boxed().toList());
        }

        public boolean method_42722() {
            return false;
        }
    }
}

