/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.modernui.mc.GuiRenderType;
import icyllis.modernui.mc.TooltipRenderer;
import javax.annotation.Nonnull;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5944;
import org.joml.Matrix4f;

public class ExtendedGuiGraphics {
    private final class_332 guiGraphics;
    private final class_4597.class_4598 bufferSource;
    private int mColorTL = -1;
    private int mColorTR = -1;
    private int mColorBR = -1;
    private int mColorBL = -1;
    private float mDepth = 0.0f;
    private float mWidth = 1.0f;

    public ExtendedGuiGraphics(@Nonnull class_332 guiGraphics) {
        this.guiGraphics = guiGraphics;
        this.bufferSource = guiGraphics.method_51450();
    }

    public class_4587 pose() {
        return this.guiGraphics.method_51448();
    }

    public void setColor(int color) {
        this.mColorTL = color;
        this.mColorTR = color;
        this.mColorBR = color;
        this.mColorBL = color;
    }

    public void setGradient(@Nonnull Orientation orientation, int startColor, int endColor) {
        int midColor = TooltipRenderer.lerpInLinearSpace(0.5f, startColor, endColor);
        switch (orientation) {
            case TOP_BOTTOM: {
                this.mColorTL = startColor;
                this.mColorTR = startColor;
                this.mColorBR = endColor;
                this.mColorBL = endColor;
                break;
            }
            case TR_BL: {
                this.mColorTL = midColor;
                this.mColorTR = startColor;
                this.mColorBR = midColor;
                this.mColorBL = endColor;
                break;
            }
            case RIGHT_LEFT: {
                this.mColorTL = endColor;
                this.mColorTR = startColor;
                this.mColorBR = startColor;
                this.mColorBL = endColor;
                break;
            }
            case BR_TL: {
                this.mColorTL = endColor;
                this.mColorTR = midColor;
                this.mColorBR = startColor;
                this.mColorBL = midColor;
                break;
            }
            case BOTTOM_TOP: {
                this.mColorTL = endColor;
                this.mColorTR = endColor;
                this.mColorBR = startColor;
                this.mColorBL = startColor;
                break;
            }
            case BL_TR: {
                this.mColorTL = midColor;
                this.mColorTR = endColor;
                this.mColorBR = midColor;
                this.mColorBL = startColor;
                break;
            }
            case LEFT_RIGHT: {
                this.mColorTL = startColor;
                this.mColorTR = endColor;
                this.mColorBR = endColor;
                this.mColorBL = startColor;
                break;
            }
            case TL_BR: {
                this.mColorTL = startColor;
                this.mColorTR = midColor;
                this.mColorBR = endColor;
                this.mColorBL = midColor;
            }
        }
    }

    public float getDepth() {
        return this.mDepth;
    }

    public void setDepth(float depth) {
        this.mDepth = depth;
    }

    public float getStrokeWidth() {
        return this.mWidth;
    }

    public void setStrokeWidth(float width) {
        if (width >= 0.0f) {
            this.mWidth = width;
        }
    }

    public void fillCircle(float centerX, float centerY, float radius) {
        this.drawRoundRect(centerX - radius, centerY - radius, centerX + radius, centerY + radius, this.mDepth, radius, -1.0f);
    }

    public void strokeCircle(float centerX, float centerY, float radius) {
        this.drawRoundRect(centerX - radius, centerY - radius, centerX + radius, centerY + radius, this.mDepth, radius, this.mWidth * 0.5f);
    }

    public void fillRoundRect(float left, float top, float right, float bottom, float radius) {
        this.drawRoundRect(left, top, right, bottom, this.mDepth, radius, -1.0f);
    }

    public void strokeRoundRect(float left, float top, float right, float bottom, float radius) {
        this.drawRoundRect(left, top, right, bottom, this.mDepth, radius, this.mWidth * 0.5f);
    }

    private void drawRoundRect(float left, float top, float right, float bottom, float depth, float radius, float thickness) {
        class_5944 shader;
        if (!(left < right) || !(top < bottom)) {
            return;
        }
        if (thickness == 0.0f) {
            return;
        }
        if (!Float.isFinite(radius) || radius < 0.0f) {
            radius = 0.0f;
        }
        if ((shader = GuiRenderType.getShaderRoundRect()) == null) {
            return;
        }
        Matrix4f pose = this.guiGraphics.method_51448().method_23760().method_23761();
        float centerX = (left + right) * 0.5f;
        float centerY = (top + bottom) * 0.5f;
        float extentX = (right - left) * 0.5f;
        float extentY = (bottom - top) * 0.5f;
        radius = Math.min(radius, Math.min(extentX, extentY));
        float outset = 1.0f + thickness;
        if ((pose.properties() & 8) != 0) {
            shader.method_35785("u_Rect").method_1254(centerX + pose.m30(), centerY + pose.m31(), extentX, extentY);
            shader.method_35785("u_Radii").method_1255(radius, thickness);
            class_4588 buffer = this.bufferSource.getBuffer(GuiRenderType.roundRect());
            buffer.method_22918(pose, left - outset, top - outset, depth).method_39415(this.mColorTL).method_1344();
            buffer.method_22918(pose, left - outset, bottom + outset, depth).method_39415(this.mColorBL).method_1344();
            buffer.method_22918(pose, right + outset, bottom + outset, depth).method_39415(this.mColorBR).method_1344();
            buffer.method_22918(pose, right + outset, top - outset, depth).method_39415(this.mColorTR).method_1344();
            this.guiGraphics.method_51452();
        } else {
            this.guiGraphics.method_51452();
            RenderSystem.getModelViewStack().method_22903();
            RenderSystem.getModelViewStack().method_34425(pose);
            RenderSystem.applyModelViewMatrix();
            shader.method_35785("u_Rect").method_1254(centerX, centerY, extentX, extentY);
            shader.method_35785("u_Radii").method_1255(radius, thickness);
            class_4588 buffer = this.bufferSource.getBuffer(GuiRenderType.roundRect());
            buffer.method_22912((double)(left - outset), (double)(top - outset), (double)depth).method_39415(this.mColorTL).method_1344();
            buffer.method_22912((double)(left - outset), (double)(bottom + outset), (double)depth).method_39415(this.mColorBL).method_1344();
            buffer.method_22912((double)(right + outset), (double)(bottom + outset), (double)depth).method_39415(this.mColorBR).method_1344();
            buffer.method_22912((double)(right + outset), (double)(top - outset), (double)depth).method_39415(this.mColorTR).method_1344();
            this.guiGraphics.method_51452();
            RenderSystem.getModelViewStack().method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static enum Orientation {
        TOP_BOTTOM,
        TR_BL,
        RIGHT_LEFT,
        BR_TL,
        BOTTOM_TOP,
        BL_TR,
        LEFT_RIGHT,
        TL_BR;

    }
}

