/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import icyllis.modernui.graphics.text.Emoji;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class EmojiDataGen {
    public static void main(String[] args) {
        String output;
        String google_fonts;
        String joy_pixels;
        String iam_cal;
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filters = stack.mallocPointer(1);
            stack.nUTF8((CharSequence)"*.json", true);
            filters.put(stack.getPointerAddress());
            filters.rewind();
            iam_cal = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Open IamCal", null, (PointerBuffer)filters, (CharSequence)"JSON File", (boolean)false);
            joy_pixels = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Open JoyPixels", null, (PointerBuffer)filters, (CharSequence)"JSON File", (boolean)false);
            google_fonts = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Open GoogleFonts", null, (PointerBuffer)filters, (CharSequence)"JSON File", (boolean)false);
            output = TinyFileDialogs.tinyfd_saveFileDialog(null, (CharSequence)"emoji_data.json", (PointerBuffer)filters, (CharSequence)"JSON File");
        }
        if (iam_cal != null && joy_pixels != null && google_fonts != null && output != null) {
            Gson gson = new Gson();
            EmojiEntry[] iam_cal_data = EmojiDataGen.read(gson, iam_cal, EmojiEntry[].class);
            JsonObject joy_pixels_data = EmojiDataGen.read(gson, joy_pixels, JsonObject.class);
            JsonArray google_fonts_data = EmojiDataGen.read(gson, google_fonts, JsonArray.class);
            LinkedHashMap map = Arrays.stream(iam_cal_data).collect(Collectors.toMap(e -> e.unified.toLowerCase(Locale.ROOT), Function.identity(), (x, y) -> x, LinkedHashMap::new));
            for (Map.Entry e2 : joy_pixels_data.entrySet()) {
                JsonObject o = ((JsonElement)e2.getValue()).getAsJsonObject();
                JsonObject ci = o.getAsJsonObject("code_points");
                EmojiEntry emoji = map.computeIfAbsent(ci.get("fully_qualified").getAsString(), EmojiEntry::new);
                emoji.short_names.add(EmojiDataGen.stripColons(o.get("shortname").getAsString()));
                for (JsonElement s : o.get("shortname_alternates").getAsJsonArray()) {
                    emoji.short_names.add(EmojiDataGen.stripColons(s.getAsString()));
                }
            }
            for (Map.Entry e2 : google_fonts_data) {
                for (JsonElement e1 : e2.getAsJsonObject().get("emoji").getAsJsonArray()) {
                    JsonObject o = e1.getAsJsonObject();
                    JsonArray ci = o.get("base").getAsJsonArray();
                    int[] cps = new int[ci.size()];
                    for (int i = 0; i < cps.length; ++i) {
                        cps[i] = Integer.parseInt(ci.get(i).getAsString());
                    }
                    EmojiEntry emoji = map.computeIfAbsent(Arrays.stream(cps).mapToObj(Integer::toHexString).collect(Collectors.joining("-")), EmojiEntry::new);
                    for (JsonElement s : o.get("shortcodes").getAsJsonArray()) {
                        emoji.short_names.add(EmojiDataGen.stripColons(s.getAsString()));
                    }
                }
            }
            List output_data = map.values().stream().filter(EmojiEntry::validate).map(EmojiEntry::flatten).collect(Collectors.toList());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8));){
                gson.toJson(output_data, (Appendable)writer);
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T read(Gson gson, String file, Class<T> type) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            Object object = gson.fromJson((Reader)reader, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String stripColons(String s) {
        return s.substring(1, s.length() - 1);
    }

    public static class EmojiEntry {
        public String unified;
        public String name;
        public Set<String> short_names;
        public String category;
        public String subcategory;
        public int sort_order;
        public String added_in;

        public EmojiEntry(String unified) {
            this.unified = unified;
            this.short_names = new LinkedHashSet<String>();
        }

        public boolean validate() {
            return !Emoji.isRegionalIndicatorSymbol(Integer.parseInt(this.unified.split("-")[0], 16));
        }

        public Object[] flatten() {
            int[] cps = Arrays.stream(this.unified.split("-")).mapToInt(c -> Integer.parseInt(c, 16)).toArray();
            Object[] row = new Object[]{new String(cps, 0, cps.length), this.name, this.short_names, this.category, this.subcategory, this.sort_order, this.added_in};
            return row;
        }
    }
}

