/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.material;

import icyllis.modernui.core.Context;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.drawable.ShapeDrawable;
import icyllis.modernui.graphics.drawable.StateListDrawable;
import icyllis.modernui.material.MaterialDrawable;
import icyllis.modernui.util.ColorStateList;
import icyllis.modernui.util.StateSet;
import icyllis.modernui.view.View;
import icyllis.modernui.widget.CheckBox;
import javax.annotation.Nonnull;

public class MaterialCheckBox
extends CheckBox {
    private static final int[][] ENABLED_CHECKED_STATES = new int[][]{{16842910, 0x10100A0}, {16842910, -16842912}, StateSet.WILD_CARD};
    private static final int[] COLORS = new int[]{-5579536, -7697782, -10395295};

    public MaterialCheckBox(Context context) {
        super(context);
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(CHECKED_STATE_SET, new CheckedDrawable(this));
        drawable.addState(StateSet.WILD_CARD, new UncheckedDrawable(this));
        drawable.setEnterFadeDuration(300);
        drawable.setExitFadeDuration(300);
        this.setButtonDrawable(drawable);
        this.setButtonTintList(new ColorStateList(ENABLED_CHECKED_STATES, COLORS));
    }

    private static class CheckedDrawable
    extends MaterialDrawable {
        private final float mRadius;

        CheckedDrawable(View view) {
            this.mRadius = view.dp(4.0f);
        }

        @Override
        public void draw(@Nonnull Canvas canvas) {
            Rect r = this.getBounds();
            Paint paint = Paint.obtain();
            paint.setColor(this.mColor);
            paint.setAlpha(ShapeDrawable.modulateAlpha(paint.getAlpha(), this.mAlpha));
            int alpha = paint.getAlpha();
            if (alpha != 0) {
                float inner = this.mRadius * 0.5f;
                paint.setStyle(1);
                paint.setStrokeWidth(this.mRadius * 0.75f);
                canvas.drawRoundRect((float)r.left + inner, (float)r.top + inner, (float)r.right - inner, (float)r.bottom - inner, this.mRadius, paint);
                paint.setStyle(0);
                canvas.drawLine(this.mRadius * 1.5f, this.mRadius * 3.5f, this.mRadius * 2.5f, this.mRadius * 4.5f, this.mRadius * 0.75f, paint);
                canvas.drawLine(this.mRadius * 2.5f, this.mRadius * 4.5f, this.mRadius * 4.5f, this.mRadius * 2.0f, this.mRadius * 0.75f, paint);
            }
            paint.recycle();
        }

        @Override
        public int getIntrinsicWidth() {
            return (int)(this.mRadius * 6.0f);
        }

        @Override
        public int getIntrinsicHeight() {
            return (int)(this.mRadius * 6.0f);
        }
    }

    private static class UncheckedDrawable
    extends MaterialDrawable {
        private final float mRadius;

        UncheckedDrawable(View view) {
            this.mRadius = view.dp(4.0f);
        }

        @Override
        public void draw(@Nonnull Canvas canvas) {
            Rect r = this.getBounds();
            Paint paint = Paint.obtain();
            paint.setColor(this.mColor);
            paint.setAlpha(ShapeDrawable.modulateAlpha(paint.getAlpha(), this.mAlpha));
            if (paint.getAlpha() != 0) {
                float inner = this.mRadius * 0.5f;
                paint.setStyle(1);
                paint.setStrokeWidth(this.mRadius * 0.75f);
                canvas.drawRoundRect((float)r.left + inner, (float)r.top + inner, (float)r.right - inner, (float)r.bottom - inner, this.mRadius, paint);
            }
            paint.recycle();
        }

        @Override
        public int getIntrinsicWidth() {
            return (int)(this.mRadius * 6.0f);
        }

        @Override
        public int getIntrinsicHeight() {
            return (int)(this.mRadius * 6.0f);
        }
    }
}

