/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.lifecycle;

import icyllis.modernui.annotation.UiThread;
import icyllis.modernui.lifecycle.LifecycleObserver;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Lifecycle {
    @UiThread
    public abstract void addObserver(@Nonnull LifecycleObserver var1);

    @UiThread
    public abstract void removeObserver(@Nonnull LifecycleObserver var1);

    @Nonnull
    @UiThread
    public abstract State getCurrentState();

    public static enum State {
        DESTROYED,
        INITIALIZED,
        CREATED,
        STARTED,
        RESUMED;


        public boolean isAtLeast(@Nonnull State state) {
            return this.compareTo(state) >= 0;
        }
    }

    public static enum Event {
        ON_CREATE,
        ON_START,
        ON_RESUME,
        ON_PAUSE,
        ON_STOP,
        ON_DESTROY;


        @Nullable
        public static Event downFrom(@Nonnull State state) {
            return switch (state) {
                case State.CREATED -> ON_DESTROY;
                case State.STARTED -> ON_STOP;
                case State.RESUMED -> ON_PAUSE;
                default -> null;
            };
        }

        @Nullable
        public static Event downTo(@Nonnull State state) {
            return switch (state) {
                case State.DESTROYED -> ON_DESTROY;
                case State.CREATED -> ON_STOP;
                case State.STARTED -> ON_PAUSE;
                default -> null;
            };
        }

        @Nullable
        public static Event upFrom(@Nonnull State state) {
            return switch (state) {
                case State.INITIALIZED -> ON_CREATE;
                case State.CREATED -> ON_START;
                case State.STARTED -> ON_RESUME;
                default -> null;
            };
        }

        @Nullable
        public static Event upTo(@Nonnull State state) {
            return switch (state) {
                case State.CREATED -> ON_CREATE;
                case State.STARTED -> ON_START;
                case State.RESUMED -> ON_RESUME;
                default -> null;
            };
        }

        @Nonnull
        public State getTargetState() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case ON_CREATE, ON_STOP -> State.CREATED;
                case ON_START, ON_PAUSE -> State.STARTED;
                case ON_RESUME -> State.RESUMED;
                case ON_DESTROY -> State.DESTROYED;
            };
        }
    }
}

