/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.text;

import javax.annotation.Nonnull;

public class FontMetricsInt {
    public int ascent;
    public int descent;
    public int leading;

    public void reset() {
        this.leading = 0;
        this.descent = 0;
        this.ascent = 0;
    }

    public void extendBy(@Nonnull FontMetricsInt fm) {
        this.extendBy(fm.ascent, fm.descent, fm.leading);
    }

    public void extendBy(int ascent, int descent) {
        this.ascent = Math.min(this.ascent, ascent);
        this.descent = Math.max(this.descent, descent);
    }

    public void extendBy(int ascent, int descent, int leading) {
        this.extendBy(ascent, descent);
        this.leading = Math.max(this.leading, leading);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontMetricsInt that = (FontMetricsInt)o;
        if (this.ascent != that.ascent) {
            return false;
        }
        if (this.descent != that.descent) {
            return false;
        }
        return this.leading == that.leading;
    }

    public int hashCode() {
        int result = this.ascent;
        result = 31 * result + this.descent;
        result = 31 * result + this.leading;
        return result;
    }

    public String toString() {
        return "FontMetricsInt{ascent=" + this.ascent + ", descent=" + this.descent + ", leading=" + this.leading + "}";
    }
}

