/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics;

import icyllis.arc3d.core.Font;
import icyllis.arc3d.core.RefCnt;
import icyllis.modernui.annotation.ColorInt;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.annotation.Size;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.BlendMode;
import icyllis.modernui.graphics.ColorFilter;
import icyllis.modernui.graphics.Shader;
import icyllis.modernui.graphics.text.FontPaint;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.ApiStatus;

public class Paint {
    public static final int FILL = 0;
    public static final int STROKE = 1;
    public static final int STROKE_AND_FILL = 2;
    public static final int FILL_AND_STROKE = 2;
    private static final int STYLE_SHIFT = 0;
    private static final int STYLE_MASK = 3;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 4;
    public static final int CAP_SQUARE = 8;
    private static final int CAP_SHIFT = 2;
    private static final int CAP_MASK = 12;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 16;
    public static final int JOIN_BEVEL = 32;
    private static final int JOIN_SHIFT = 4;
    private static final int JOIN_MASK = 48;
    @ApiStatus.Experimental
    public static final int ALIGN_CENTER = 0;
    @ApiStatus.Experimental
    public static final int ALIGN_INSIDE = 64;
    @ApiStatus.Experimental
    public static final int ALIGN_OUTSIDE = 128;
    private static final int ALIGN_SHIFT = 6;
    private static final int ALIGN_MASK = 192;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    static final int TEXT_STYLE_MASK = 3;
    static final int TEXT_ANTI_ALIAS_DEFAULT = 0;
    static final int TEXT_ANTI_ALIAS_OFF = 4;
    static final int TEXT_ANTI_ALIAS_ON = 8;
    static final int TEXT_ANTI_ALIAS_MASK = 12;
    static final int LINEAR_TEXT_FLAG = 16;
    static final int FILTER_MODE_SHIFT = 5;
    static final int FILTER_MODE_MASK = 32;
    static final int MIPMAP_MODE_SHIFT = 6;
    static final int MIPMAP_MODE_MASK = 192;
    static final int DEFAULT_FLAGS = 48;
    private static final Paint[] sPool = new Paint[8];
    @GuardedBy(value="sPool")
    private static int sPoolSize;
    private final icyllis.arc3d.core.Paint mPaint;
    private Shader mShader;
    private ColorFilter mColorFilter;
    protected int mFlags;
    private float mFontSize;

    public Paint() {
        this.mPaint = new icyllis.arc3d.core.Paint();
        this.internalReset();
        Core.registerNativeResource((Object)this, this.mPaint);
    }

    public Paint(@Nullable Paint paint) {
        if (paint == null) {
            this.mPaint = new icyllis.arc3d.core.Paint();
            this.internalReset();
        } else {
            this.mPaint = new icyllis.arc3d.core.Paint(paint.mPaint);
            this.internalSetFrom(paint);
        }
        Core.registerNativeResource((Object)this, this.mPaint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Paint obtain() {
        Paint[] paintArray = sPool;
        synchronized (sPool) {
            if (sPoolSize != 0) {
                int i = --sPoolSize;
                Paint p = sPool[i];
                Paint.sPool[i] = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return p;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new Paint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        this.reset();
        Paint[] paintArray = sPool;
        synchronized (sPool) {
            if (sPoolSize != sPool.length) {
                Paint.sPool[Paint.sPoolSize++] = this;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void reset() {
        this.mPaint.reset();
        this.internalReset();
    }

    public void set(@Nullable Paint paint) {
        if (paint == null) {
            this.reset();
        } else if (this != paint) {
            this.mPaint.set(paint.mPaint);
            this.internalSetFrom(paint);
        }
    }

    private void internalReset() {
        this.mShader = null;
        this.mColorFilter = null;
        this.mFlags = 48;
        this.mFontSize = 16.0f;
    }

    private void internalSetFrom(@NonNull Paint paint) {
        this.mShader = paint.mShader;
        this.mColorFilter = paint.mColorFilter;
        this.mFlags = paint.mFlags;
        this.mFontSize = paint.mFontSize;
    }

    public int getColor() {
        return this.mPaint.getColor();
    }

    public void setColor(@ColorInt int color) {
        this.mPaint.setColor(color);
    }

    @NonNull
    @Size(value=4L)
    public float[] getColor4f() {
        return new float[]{this.mPaint.r(), this.mPaint.g(), this.mPaint.b(), this.mPaint.a()};
    }

    @NonNull
    @Size(value=4L)
    public float[] getColor4f(@NonNull @Size(value=4L) float[] dst) {
        this.mPaint.getColor4f(dst);
        return dst;
    }

    public void setColor4f(float r, float g, float b, float a) {
        this.mPaint.setColor4f(r, g, b, a);
    }

    public int getAlpha() {
        return this.mPaint.getAlpha();
    }

    public void setAlpha(int a) {
        this.mPaint.setAlpha(a);
    }

    public float getAlphaF() {
        return this.mPaint.getAlphaF();
    }

    public void setAlphaF(float a) {
        this.mPaint.setAlphaF(a);
    }

    public final void setRGBA(float r, float g, float b, float a) {
        this.setColor4f(r, g, b, a);
    }

    public void setRGBA(int r, int g, int b, int a) {
        this.mPaint.setRGBA(r, g, b, a);
    }

    public void setARGB(int a, int r, int g, int b) {
        this.mPaint.setARGB(a, r, g, b);
    }

    public boolean isAntiAlias() {
        return this.mPaint.isAntiAlias();
    }

    public void setAntiAlias(boolean aa) {
        this.mPaint.setAntiAlias(aa);
    }

    public boolean isDither() {
        return this.mPaint.isDither();
    }

    public void setDither(boolean dither) {
        this.mPaint.setDither(dither);
    }

    public int getStyle() {
        return this.mPaint.getStyle() << 0;
    }

    public void setStyle(@NonNull Style style) {
        this.mPaint.setStyle(style.nativeInt);
    }

    public void setStyle(int style) {
        this.mPaint.setStyle((style & 3) >>> 0);
    }

    public void setStroke(boolean stroke) {
        this.setStyle(stroke ? 1 : 0);
    }

    public int getStrokeCap() {
        return this.mPaint.getStrokeCap() << 2;
    }

    public void setStrokeCap(@NonNull Cap cap) {
        this.mPaint.setStrokeCap(cap.nativeInt);
    }

    public void setStrokeCap(int cap) {
        this.mPaint.setStrokeCap((cap & 0xC) >>> 2);
    }

    public int getStrokeJoin() {
        return this.mPaint.getStrokeJoin() << 4;
    }

    public void setStrokeJoin(@NonNull Join join) {
        this.mPaint.setStrokeJoin(join.nativeInt);
    }

    public void setStrokeJoin(int join) {
        this.mPaint.setStrokeJoin((join & 0x30) >>> 4);
    }

    public int getStrokeAlign() {
        return this.mPaint.getStrokeAlign() << 6;
    }

    @ApiStatus.Experimental
    public void setStrokeAlign(@NonNull Align align) {
        this.mPaint.setStrokeAlign(align.nativeInt);
    }

    @ApiStatus.Experimental
    public void setStrokeAlign(int align) {
        this.mPaint.setStrokeAlign((align & 0xC0) >>> 6);
    }

    public float getStrokeWidth() {
        return this.mPaint.getStrokeWidth();
    }

    public void setStrokeWidth(float width) {
        this.mPaint.setStrokeWidth(width);
    }

    public float getStrokeMiter() {
        return this.mPaint.getStrokeMiter();
    }

    public void setStrokeMiter(float miter) {
        this.mPaint.setStrokeMiter(miter);
    }

    @Nullable
    public Shader getShader() {
        return this.mShader;
    }

    public void setShader(@Nullable Shader shader) {
        if (this.mShader != shader) {
            this.mShader = shader;
            this.mPaint.setShader(shader != null ? RefCnt.create(shader.getNativeShader()) : null);
        }
    }

    @Nullable
    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        if (this.mColorFilter != colorFilter) {
            this.mColorFilter = colorFilter;
            this.mPaint.setColorFilter(colorFilter != null ? RefCnt.create(colorFilter.getNativeColorFilter()) : null);
        }
    }

    @Nullable
    public BlendMode getBlendMode() {
        icyllis.arc3d.core.BlendMode mode = this.mPaint.getBlendMode();
        return mode != null ? BlendMode.VALUES[mode.ordinal()] : null;
    }

    public void setBlendMode(@Nullable BlendMode mode) {
        this.mPaint.setBlendMode(mode != null ? mode.getNativeBlendMode() : null);
    }

    public int getTextStyle() {
        return this.mFlags & 3;
    }

    public void setTextStyle(int textStyle) {
        this.mFlags = this.mFlags & 0xFFFFFFFC | textStyle & 3;
    }

    public float getTextSize() {
        return this.mFontSize;
    }

    public void setTextSize(float textSize) {
        if (textSize >= 0.0f) {
            this.mFontSize = textSize;
        }
    }

    public boolean isTextAntiAlias() {
        return switch (this.mFlags & 0xC) {
            case 8 -> true;
            case 4 -> false;
            default -> this.isAntiAlias();
        };
    }

    public void setTextAntiAlias(boolean textAA) {
        this.mFlags = this.mFlags & 0xFFFFFFF3 | (textAA ? 8 : 4);
    }

    public boolean isLinearText() {
        return (this.mFlags & 0x10) != 0;
    }

    public void setLinearText(boolean linearText) {
        this.mFlags = linearText ? (this.mFlags |= 0x10) : (this.mFlags &= 0xFFFFFFEF);
    }

    public final int getFilterMode() {
        return (this.mFlags & 0x20) >>> 5;
    }

    public final void setFilterMode(int filter) {
        this.mFlags = this.mFlags & 0xFFFFFFDF | filter << 5 & 0x20;
    }

    public boolean isFilter() {
        return (this.mFlags & 0x20) != 0;
    }

    public void setFilter(boolean filter) {
        this.mFlags = this.mFlags & 0xFFFFFFDF | (filter ? 32 : 0);
    }

    public final int getMipmapMode() {
        return (this.mFlags & 0xC0) >>> 6;
    }

    public final void setMipmapMode(int mipmap) {
        this.mFlags = this.mFlags & 0xFFFFFF3F | mipmap << 6 & 0xC0;
    }

    @ApiStatus.Internal
    public icyllis.arc3d.core.Paint getNativePaint() {
        return this.mPaint;
    }

    @ApiStatus.Internal
    public void getNativeFont(@NonNull Font nativeFont) {
        nativeFont.setSize(FontPaint.getCanonicalFontSize(this.getTextSize()));
        nativeFont.setEdging(this.isTextAntiAlias() ? 1 : 0);
        nativeFont.setLinearMetrics(this.isLinearText());
    }

    public int hashCode() {
        int result = this.mPaint.hashCode();
        result = 31 * result + this.mFlags;
        result = 31 * result + Float.floatToIntBits(this.mFontSize);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Paint)) {
            return false;
        }
        Paint paint = (Paint)o;
        return this.mPaint.equals((Object)paint.mPaint) && this.mFlags == paint.mFlags && this.mFontSize == paint.mFontSize;
    }

    public static enum Style {
        FILL(0),
        STROKE(1),
        FILL_AND_STROKE(2);

        final int nativeInt;

        private Style(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Cap {
        BUTT(0),
        ROUND(1),
        SQUARE(2);

        final int nativeInt;

        private Cap(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Join {
        MITER(0),
        ROUND(1),
        BEVEL(2);

        final int nativeInt;

        private Join(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    @ApiStatus.Experimental
    public static enum Align {
        CENTER(0),
        INSIDE(1),
        OUTSIDE(2);

        final int nativeInt;

        private Align(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @ApiStatus.Internal
    public static @interface TextStyle {
    }
}

