/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core;

import icyllis.arc3d.core.RefCounted;
import icyllis.arc3d.engine.ContextOptions;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.opengl.GLCaps;
import icyllis.arc3d.opengl.GLUtil;
import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.MainThread;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.annotation.UiThread;
import icyllis.modernui.core.Handler;
import icyllis.modernui.core.Looper;
import icyllis.modernui.core.VulkanManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Cleaner;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.opengl.GLDebugMessageAMDCallbackI;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public final class Core {
    private static final Cleaner sCleaner = Cleaner.create();
    private static volatile Thread sMainThread;
    private static volatile Thread sRenderThread;
    private static volatile Thread sUiThread;
    private static volatile Handler sMainHandlerAsync;
    private static volatile Handler sUiHandler;
    private static volatile Handler sUiHandlerAsync;
    private static final ConcurrentLinkedQueue<Runnable> sMainCalls;
    private static final Executor sMainThreadExecutor;
    private static final Executor sUiThreadExecutor;
    private static volatile ImmediateContext sImmediateContext;
    private static volatile RecordingContext sUiRecordingContext;

    private Core() {
    }

    @NonNull
    public static Cleaner.Cleanable registerCleanup(@NonNull Object target, @NonNull Runnable action) {
        return sCleaner.register(target, action);
    }

    @ApiStatus.Internal
    @NonNull
    public static Cleaner.Cleanable registerNativeResource(@NonNull Object target, @NonNull RefCounted resource) {
        return sCleaner.register(target, resource::unref);
    }

    @ApiStatus.Internal
    @NonNull
    public static Cleaner.Cleanable registerNativeResource(@NonNull Object target, @NonNull AutoCloseable resource) {
        return sCleaner.register(target, () -> {
            try {
                resource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void initialize() {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            if (sMainThread == null) {
                GLFWErrorCallback cb = GLFW.glfwSetErrorCallback(null);
                if (cb != null) {
                    GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)cb);
                } else {
                    ModernUI.LOGGER.info(ModernUI.MARKER, "Backend Library: LWJGL {}", (Object)Version.getVersion());
                    GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)new GLFWErrorCallback(){

                        public void invoke(int error, long description) {
                            ModernUI.LOGGER.error(ModernUI.MARKER, "GLFW Error: 0x{} {}", (Object)Integer.toHexString(error), (Object)MemoryUtil.memUTF8Safe((long)description));
                        }
                    });
                }
                if (!GLFW.glfwInit()) {
                    Objects.requireNonNull(GLFW.glfwSetErrorCallback(null)).free();
                    throw new UnsupportedOperationException("Failed to initialize GLFW");
                }
                sMainThread = Thread.currentThread();
            } else assert (false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @MainThread
    public static void terminate() {
        Core.checkMainThread();
        GLFWErrorCallback cb = GLFW.glfwSetErrorCallback(null);
        if (cb != null) {
            cb.close();
        }
        GLFW.glfwTerminate();
        ModernUI.LOGGER.info(ModernUI.MARKER, "Terminated GLFW");
    }

    public static void checkMainThread() {
        if (Thread.currentThread() != sMainThread) {
            throw new IllegalStateException("Not called from the main thread, current " + Thread.currentThread());
        }
    }

    public static Thread getMainThread() {
        return sMainThread;
    }

    public static boolean isOnMainThread() {
        return Thread.currentThread() == sMainThread;
    }

    @NonNull
    private static ContextOptions initContextOptions(@NonNull ContextOptions options) {
        if (options.mLogger == null || options.mLogger == NOPLogger.NOP_LOGGER) {
            options.mLogger = LoggerFactory.getLogger((String)"Arc3D");
        }
        return options;
    }

    @RenderThread
    public static boolean initOpenGL() {
        return Core.initOpenGL(new ContextOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderThread
    public static boolean initOpenGL(@NonNull ContextOptions options) {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            if (sImmediateContext != null) {
                if (sImmediateContext.getBackend() != 0) {
                    throw new IllegalStateException();
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return true;
            }
            if (sRenderThread == null) {
                sRenderThread = Thread.currentThread();
            } else if (Thread.currentThread() != sRenderThread) {
                throw new IllegalStateException();
            }
            Core.initContextOptions(options);
            ImmediateContext dc = GLUtil.makeOpenGL(options);
            if (dc == null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return false;
            }
            sImmediateContext = dc;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            String glVendor = GL11C.glGetString((int)7936);
            String glRenderer = GL11C.glGetString((int)7937);
            String glVersion = GL11C.glGetString((int)7938);
            ModernUI.LOGGER.info(ModernUI.MARKER, "OpenGL vendor: {}", (Object)glVendor);
            ModernUI.LOGGER.info(ModernUI.MARKER, "OpenGL renderer: {}", (Object)glRenderer);
            ModernUI.LOGGER.info(ModernUI.MARKER, "OpenGL version: {}", (Object)glVersion);
            StringBuilder sb = new StringBuilder("\n");
            ((GLCaps)dc.getCaps()).dump(sb, false);
            ModernUI.LOGGER.info(ModernUI.MARKER, "OpenGL caps: {}", (Object)sb);
            return true;
        }
    }

    @RenderThread
    public static void glSetupDebugCallback() {
        GLCapabilities caps = GL.getCapabilities();
        if (GL43C.glGetPointer((int)33348) == 0L) {
            if (caps.OpenGL43 || caps.GL_KHR_debug) {
                ModernUI.LOGGER.debug(ModernUI.MARKER, "Using OpenGL 4.3 for debug logging");
                GL43C.glDebugMessageCallback(Core::glDebugMessage, (long)0L);
                GL43C.glEnable((int)37600);
            } else if (caps.GL_ARB_debug_output) {
                ModernUI.LOGGER.debug(ModernUI.MARKER, "Using ARB_debug_output for debug logging");
                GLDebugMessageARBCallback proc = new GLDebugMessageARBCallback(){

                    public void invoke(int source, int type, int id2, int severity, int length, long message, long userParam) {
                        ModernUI.LOGGER.info(ModernUI.MARKER, "0x{}[{},{},{}]: {}", (Object)Integer.toHexString(id2), (Object)GLUtil.getSourceARB(source), (Object)GLUtil.getTypeARB(type), (Object)GLUtil.getSeverityARB(severity), (Object)GLDebugMessageARBCallback.getMessage((int)length, (long)message));
                    }
                };
                ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)proc, (long)0L);
            } else if (caps.GL_AMD_debug_output) {
                ModernUI.LOGGER.debug(ModernUI.MARKER, "Using AMD_debug_output for debug logging");
                GLDebugMessageAMDCallback proc = new GLDebugMessageAMDCallback(){

                    public void invoke(int id2, int category, int severity, int length, long message, long userParam) {
                        ModernUI.LOGGER.info(ModernUI.MARKER, "0x{}[{},{}]: {}", (Object)Integer.toHexString(id2), (Object)GLUtil.getCategoryAMD(category), (Object)GLUtil.getSeverityAMD(severity), (Object)GLDebugMessageAMDCallback.getMessage((int)length, (long)message));
                    }
                };
                AMDDebugOutput.glDebugMessageCallbackAMD((GLDebugMessageAMDCallbackI)proc, (long)0L);
            } else {
                ModernUI.LOGGER.debug(ModernUI.MARKER, "No debug callback function was used...");
            }
        } else {
            ModernUI.LOGGER.debug(ModernUI.MARKER, "The debug callback function is already set.");
        }
    }

    public static void glDebugMessage(int source, int type, int id2, int severity, int length, long message, long userParam) {
        switch (severity) {
            case 37190: {
                ModernUI.LOGGER.error(ModernUI.MARKER, "({}|{}|0x{}) {}", (Object)GLUtil.getDebugSource(source), (Object)GLUtil.getDebugType(type), (Object)Integer.toHexString(id2), (Object)GLDebugMessageCallback.getMessage((int)length, (long)message));
                break;
            }
            case 37191: {
                ModernUI.LOGGER.warn(ModernUI.MARKER, "({}|{}|0x{}) {}", (Object)GLUtil.getDebugSource(source), (Object)GLUtil.getDebugType(type), (Object)Integer.toHexString(id2), (Object)GLDebugMessageCallback.getMessage((int)length, (long)message));
                break;
            }
            case 37192: {
                ModernUI.LOGGER.info(ModernUI.MARKER, "({}|{}|0x{}) {}", (Object)GLUtil.getDebugSource(source), (Object)GLUtil.getDebugType(type), (Object)Integer.toHexString(id2), (Object)GLDebugMessageCallback.getMessage((int)length, (long)message));
                break;
            }
            case 33387: {
                ModernUI.LOGGER.debug(ModernUI.MARKER, "({}|{}|0x{}) {}", (Object)GLUtil.getDebugSource(source), (Object)GLUtil.getDebugType(type), (Object)Integer.toHexString(id2), (Object)GLDebugMessageCallback.getMessage((int)length, (long)message));
            }
        }
    }

    @RenderThread
    public static void glShowCapsErrorDialog() {
        Core.checkRenderThread();
        if (sImmediateContext != null) {
            return;
        }
        String glVendor = GL11C.glGetString((int)7936);
        String glRenderer = GL11C.glGetString((int)7937);
        String glVersion = GL11C.glGetString((int)7938);
        new Thread(() -> {
            String solution = "Please make sure you have up-to-date GPU drivers. Also make sure Java applications run with the discrete GPU if you have multiple GPUs.";
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Failed to launch Modern UI", (CharSequence)("GPU: " + glVendor + " " + glRenderer + ", OpenGL: " + glVersion + ". OpenGL 3.3 or OpenGL ES 3.0 is required.\n" + solution), (CharSequence)"ok", (CharSequence)"error", (boolean)true);
        }, "GL-Error-Dialog").start();
    }

    @RenderThread
    public static boolean initVulkan() {
        return Core.initVulkan(new ContextOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderThread
    public static boolean initVulkan(@NonNull ContextOptions options) {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            ImmediateContext dc;
            if (sImmediateContext != null) {
                if (sImmediateContext.getBackend() != 1) {
                    throw new IllegalStateException();
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return true;
            }
            if (sRenderThread == null) {
                sRenderThread = Thread.currentThread();
            } else if (Thread.currentThread() != sRenderThread) {
                throw new IllegalStateException();
            }
            try {
                VulkanManager vkManager = VulkanManager.getInstance();
                vkManager.initialize();
                Core.initContextOptions(options);
                dc = vkManager.createContext(options);
                if (dc == null) {
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return false;
            }
            sImmediateContext = dc;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return true;
        }
    }

    public static void checkRenderThread() {
        if (Thread.currentThread() != sRenderThread) {
            Class<Core> clazz = Core.class;
            synchronized (Core.class) {
                if (sRenderThread == null) {
                    throw new IllegalStateException("The render thread has not been initialized yet.");
                }
                throw new IllegalStateException("Not called from the render thread " + sRenderThread + ", current " + Thread.currentThread());
            }
        }
    }

    public static Thread getRenderThread() {
        return sRenderThread;
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == sRenderThread;
    }

    @NonNull
    @RenderThread
    public static ImmediateContext requireImmediateContext() {
        Core.checkRenderThread();
        return Objects.requireNonNull(sImmediateContext, "Immediate context has not been created yet, or creation failed");
    }

    public static ImmediateContext peekImmediateContext() {
        return sImmediateContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static Handler getMainHandlerAsync() {
        if (sMainHandlerAsync != null) return sMainHandlerAsync;
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            if (sMainHandlerAsync != null) return sMainHandlerAsync;
            if (Looper.getMainLooper() == null) {
                throw new IllegalStateException("The main event loop does not exist.");
            }
            sMainHandlerAsync = Handler.createAsync(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sMainHandlerAsync;
        }
    }

    public static void postOnMainThread(@NonNull Runnable r) {
        if (Looper.getMainLooper() == null) {
            sMainCalls.offer(r);
        } else {
            Core.getMainHandlerAsync().post(r);
        }
    }

    public static void executeOnMainThread(@NonNull Runnable r) {
        if (Core.isOnMainThread()) {
            r.run();
        } else {
            Core.postOnMainThread(r);
        }
    }

    @NonNull
    public static Executor getMainThreadExecutor() {
        return sMainThreadExecutor;
    }

    public static void flushMainCalls() {
        Runnable r;
        ConcurrentLinkedQueue<Runnable> queue = sMainCalls;
        while ((r = queue.poll()) != null) {
            r.run();
        }
    }

    @NonNull
    @UiThread
    public static Looper initUiThread() {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            if (sUiThread == null) {
                sUiThread = Thread.currentThread();
                Looper looper = sUiThread == sMainThread ? Looper.getMainLooper() : Looper.prepare();
                sUiHandler = new Handler(looper);
                sUiHandlerAsync = Handler.createAsync(looper);
                if (sImmediateContext != null) {
                    sUiRecordingContext = sImmediateContext.makeRecordingContext();
                    Objects.requireNonNull(sUiRecordingContext);
                } else {
                    ModernUI.LOGGER.warn(ModernUI.MARKER, "UI thread initializing without a GPU device");
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return looper;
            }
            throw new IllegalStateException();
        }
    }

    public static void checkUiThread() {
        if (Thread.currentThread() != sUiThread) {
            Class<Core> clazz = Core.class;
            synchronized (Core.class) {
                if (sUiThread == null) {
                    throw new IllegalStateException("The UI thread has not been initialized yet.");
                }
                throw new IllegalStateException("Not called from the UI thread " + sRenderThread + ", current " + Thread.currentThread());
            }
        }
    }

    public static Thread getUiThread() {
        return sUiThread;
    }

    public static boolean isOnUiThread() {
        return Thread.currentThread() == sUiThread;
    }

    @NonNull
    @UiThread
    public static RecordingContext requireUiRecordingContext() {
        Core.checkUiThread();
        return Objects.requireNonNull(sUiRecordingContext, "UI recording context has not been created yet, or creation failed");
    }

    public static RecordingContext peekUiRecordingContext() {
        return sUiRecordingContext;
    }

    public static Handler getUiHandler() {
        return sUiHandler;
    }

    public static Handler getUiHandlerAsync() {
        return sUiHandlerAsync;
    }

    public static void postOnUiThread(@NonNull Runnable r) {
        Core.getUiHandlerAsync().post(r);
    }

    public static void executeOnUiThread(@NonNull Runnable r) {
        if (Core.isOnUiThread()) {
            r.run();
        } else {
            Core.postOnUiThread(r);
        }
    }

    @NonNull
    public static Executor getUiThreadExecutor() {
        return sUiThreadExecutor;
    }

    public static long timeNanos() {
        return (long)(GLFW.glfwGetTime() * 1.0E9);
    }

    public static long timeMillis() {
        return (long)(GLFW.glfwGetTime() * 1000.0);
    }

    @NonNull
    public static ByteBuffer readIntoNativeBuffer(@NonNull ReadableByteChannel channel) throws IOException {
        ByteBuffer p;
        block6: {
            p = null;
            try {
                if (channel instanceof SeekableByteChannel) {
                    SeekableByteChannel ch = (SeekableByteChannel)channel;
                    long rem = ch.size() - ch.position() + 1L;
                    p = MemoryUtil.memAlloc((int)((int)Math.min(rem, Integer.MAX_VALUE)));
                    while (ch.read(p) > 0) {
                    }
                    break block6;
                }
                p = MemoryUtil.memAlloc((int)4096);
                while (channel.read(p) != -1) {
                    if (p.hasRemaining()) continue;
                    long cap = p.capacity();
                    if (cap != Integer.MAX_VALUE) {
                        p = MemoryUtil.memRealloc((ByteBuffer)p, (int)((int)Math.min(cap + (cap >> 1), Integer.MAX_VALUE)));
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                MemoryUtil.memFree(p);
                throw t;
            }
        }
        return p;
    }

    @NonNull
    public static ByteBuffer readIntoNativeBuffer(@NonNull InputStream stream) throws IOException {
        return Core.readIntoNativeBuffer(Channels.newChannel(stream));
    }

    public static boolean openURI(@NonNull URI uri) {
        try {
            String[] stringArray;
            String s = uri.toString();
            switch (Platform.get()) {
                case WINDOWS: {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "rundll32";
                    stringArray2[1] = "url.dll,FileProtocolHandler";
                    stringArray = stringArray2;
                    stringArray2[2] = s;
                    break;
                }
                case MACOSX: {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "open";
                    stringArray = stringArray3;
                    stringArray3[1] = s;
                    break;
                }
                default: {
                    String[] stringArray4 = new String[2];
                    stringArray4[0] = "xdg-open";
                    stringArray = stringArray4;
                    stringArray4[1] = "file".equals(uri.getScheme()) ? s.replace("file:", "file://") : s;
                }
            }
            String[] cmd = stringArray;
            Process proc = Runtime.getRuntime().exec(cmd);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
                reader.lines().forEach(line -> ModernUI.LOGGER.error(ModernUI.MARKER, line));
            }
            return true;
        }
        catch (Exception e) {
            ModernUI.LOGGER.error(ModernUI.MARKER, "Failed to open URI: {}", (Object)uri, (Object)e);
            return false;
        }
    }

    public static boolean openURI(@NonNull String uri) {
        try {
            return Core.openURI(URI.create(uri));
        }
        catch (Exception e) {
            ModernUI.LOGGER.error(ModernUI.MARKER, "Failed to open URI: {}", (Object)uri, (Object)e);
            return false;
        }
    }

    static {
        sMainCalls = new ConcurrentLinkedQueue();
        sMainThreadExecutor = Core::executeOnMainThread;
        sUiThreadExecutor = Core::executeOnUiThread;
    }
}

