/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.audio;

import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.MainThread;
import icyllis.modernui.audio.Track;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.ALUtil;

public class AudioManager
implements AutoCloseable {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Audio");
    public static final int TICK_PERIOD = 20;
    private static final AudioManager sInstance = new AudioManager();
    private final ScheduledExecutorService mExecutorService = Executors.newSingleThreadScheduledExecutor(this::createThread);
    private final List<String> mDeviceList = new ArrayList<String>();
    private final CopyOnWriteArrayList<Track> mTracks = new CopyOnWriteArrayList();
    private boolean mInitialized;
    private boolean mIntegrated;
    private int mTimer;

    private AudioManager() {
    }

    @Nonnull
    public static AudioManager getInstance() {
        return sInstance;
    }

    @Nonnull
    private Thread createThread(Runnable target) {
        Thread t = new Thread(target, "Audio-Thread");
        t.setDaemon(true);
        return t;
    }

    @MainThread
    public void initialize() {
        this.initialize(false);
    }

    @MainThread
    public synchronized void initialize(boolean integrated) {
        if (this.mInitialized) {
            return;
        }
        this.mIntegrated = integrated;
        if (!integrated) {
            this.setDevice(null);
            List devices = ALUtil.getStringList((long)0L, (int)4115);
            if (devices != null) {
                this.mDeviceList.addAll(devices);
            }
        }
        this.mExecutorService.scheduleAtFixedRate(this::tick, 0L, 20L, TimeUnit.MILLISECONDS);
        this.mInitialized = true;
    }

    public void setDevice(@Nullable String name) {
        long context = ALC11.alcGetCurrentContext();
        if (context == 0L) {
            long device = ALC11.alcOpenDevice((CharSequence)name);
            if (device == 0L && name != null) {
                device = ALC11.nalcOpenDevice((long)0L);
            }
            if (device != 0L) {
                context = ALC11.nalcCreateContext((long)device, (long)0L);
                ALC11.alcMakeContextCurrent((long)context);
                if (context != 0L) {
                    ALCCapabilities alcCapabilities = ALC.createCapabilities((long)device);
                    ALCapabilities alCapabilities = AL.createCapabilities((ALCCapabilities)alcCapabilities);
                    if (!alcCapabilities.OpenALC11 || !alCapabilities.OpenAL11) {
                        ModernUI.LOGGER.fatal(MARKER, "OpenAL 1.1 is not supported");
                    }
                    String devName = ALC11.alcGetString((long)device, (int)4101);
                    ModernUI.LOGGER.info(MARKER, "Open audio device {}", (Object)devName);
                } else {
                    ModernUI.LOGGER.error(MARKER, "Failed to create audio context");
                }
            } else {
                ModernUI.LOGGER.info(MARKER, "No suitable audio device was found");
            }
        }
    }

    private void tick() {
        int timer = this.mTimer + 1 & 0x7F;
        try {
            Object devices;
            if (timer == 0 && !this.mIntegrated && !this.mDeviceList.equals(devices = ALUtil.getStringList((long)0L, (int)4115))) {
                this.mDeviceList.clear();
                if (devices != null) {
                    this.mDeviceList.addAll((Collection<String>)devices);
                }
                this.destroy();
                this.setDevice(null);
                ModernUI.LOGGER.info(MARKER, "Device list changed");
            }
            for (Track track : this.mTracks) {
                track.tick();
            }
        }
        catch (Throwable t) {
            ModernUI.LOGGER.error(MARKER, "Caught an exception on audio thread", t);
        }
        this.mTimer = timer;
    }

    public void destroy() {
        long context = ALC11.alcGetCurrentContext();
        if (context != 0L) {
            long device = ALC11.alcGetContextsDevice((long)context);
            ALC11.alcMakeContextCurrent((long)0L);
            ALC11.alcDestroyContext((long)context);
            if (device != 0L) {
                ALC11.alcCloseDevice((long)device);
            }
        }
    }

    public void addTrack(@Nonnull Track track) {
        this.mTracks.add(track);
    }

    public void removeTrack(@Nonnull Track track) {
        this.mTracks.remove(track);
    }

    @Override
    public void close() {
        this.mExecutorService.shutdown();
        ArrayList<Track> tracks = new ArrayList<Track>(this.mTracks);
        for (Track track : tracks) {
            try {
                track.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.mIntegrated) {
            this.destroy();
        }
    }
}

