/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.vulkan;

import icyllis.arc3d.engine.ManagedResource;
import icyllis.arc3d.vulkan.VKUtil;
import icyllis.arc3d.vulkan.VulkanDevice;
import icyllis.arc3d.vulkan.VulkanPrimaryCommandBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK11;
import org.lwjgl.vulkan.VkCommandPoolCreateInfo;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkFenceCreateInfo;

public class VulkanCommandPool
extends ManagedResource {
    private VulkanPrimaryCommandBuffer mPrimaryCommandBuffer;
    private long mCommandPool;
    private boolean mSubmitted;
    private final long[] mSubmitFence = new long[1];

    private VulkanCommandPool(VulkanDevice device, long handle, VulkanPrimaryCommandBuffer primaryCommandBuffer) {
        super(device);
        this.mCommandPool = handle;
        this.mPrimaryCommandBuffer = primaryCommandBuffer;
    }

    @Nullable
    public static VulkanCommandPool create(VulkanDevice device) {
        long commandPool;
        int cmdPoolCreateFlags = 1;
        if (device.isProtectedContext()) {
            cmdPoolCreateFlags |= 4;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer pCommandPool = stack.mallocLong(1);
            int result = VK11.vkCreateCommandPool((VkDevice)device.vkDevice(), (VkCommandPoolCreateInfo)VkCommandPoolCreateInfo.malloc((MemoryStack)stack).sType$Default().pNext(0L).flags(cmdPoolCreateFlags).queueFamilyIndex(device.getQueueIndex()), null, (LongBuffer)pCommandPool);
            if (result != 0) {
                VulkanCommandPool vulkanCommandPool = null;
                return vulkanCommandPool;
            }
            commandPool = pCommandPool.get(0);
        }
        VulkanPrimaryCommandBuffer primaryCommandBuffer = VulkanPrimaryCommandBuffer.create(device, commandPool);
        if (primaryCommandBuffer == null) {
            VK11.vkDestroyCommandPool((VkDevice)device.vkDevice(), (long)commandPool, null);
            return null;
        }
        return new VulkanCommandPool(device, commandPool, primaryCommandBuffer);
    }

    @Override
    protected void deallocate() {
        VK11.vkDestroyCommandPool((VkDevice)this.getDevice().vkDevice(), (long)this.mCommandPool, null);
    }

    public boolean submit() {
        assert (!this.mPrimaryCommandBuffer.isRecording());
        if (this.mSubmitFence[0] == 0L) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                int result = VK11.vkCreateFence((VkDevice)this.getDevice().vkDevice(), (VkFenceCreateInfo)VkFenceCreateInfo.calloc((MemoryStack)stack).sType$Default(), null, (long[])this.mSubmitFence);
                if (result != 0) {
                    boolean bl = false;
                    return bl;
                }
                this.mSubmitFence[0] = 0L;
            }
        } else {
            VKUtil._CHECK_ERROR_(VK11.vkResetFences((VkDevice)this.getDevice().vkDevice(), (long[])this.mSubmitFence));
        }
        return false;
    }

    public boolean check() {
        if (!this.mSubmitted) {
            return false;
        }
        if (this.mSubmitFence[0] == 0L) {
            return true;
        }
        int result = VK11.vkGetFenceStatus((VkDevice)this.getDevice().vkDevice(), (long)this.mSubmitFence[0]);
        if (result == 0 || result == -4) {
            return true;
        }
        if (result == 1) {
            return false;
        }
        throw new RuntimeException(VKUtil.getResultMessage(result));
    }

    public void reset() {
        assert (this.isSubmitted());
        VK11.vkResetCommandPool((VkDevice)this.getDevice().vkDevice(), (long)this.mCommandPool, (int)0);
        this.mSubmitted = false;
    }

    public boolean isSubmitted() {
        return this.mSubmitted;
    }

    @Override
    protected VulkanDevice getDevice() {
        return (VulkanDevice)super.getDevice();
    }
}

