/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.vulkan;

import icyllis.arc3d.engine.ContextOptions;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.vulkan.VulkanBackendContext;
import icyllis.arc3d.vulkan.VulkanDevice;
import icyllis.arc3d.vulkan.VulkanQueueManager;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.NativeType;

public final class VKUtil {
    public static final int kAMD_VendorID = 4098;
    public static final int kImgTec_VendorID = 4112;
    public static final int kApple_VendorID = 4203;
    public static final int kNVIDIA_VendorID = 4318;
    public static final int kARM_VendorID = 5045;
    public static final int kBroadcom_VendorID = 5348;
    public static final int kGoogle_VendorID = 6880;
    public static final int kMooreThreads_VendorID = 7893;
    public static final int kQualcomm_VendorID = 20803;
    public static final int kIntel_VendorID = 32902;
    public static final int LAST_COLOR_FORMAT_INDEX = 3;

    @Nullable
    public static ImmediateContext makeVulkan(VulkanBackendContext backendContext) {
        return VKUtil.makeVulkan(backendContext, new ContextOptions());
    }

    @Nullable
    public static ImmediateContext makeVulkan(VulkanBackendContext backendContext, ContextOptions options) {
        VulkanDevice device = VulkanDevice.make(backendContext, options);
        if (device == null) {
            return null;
        }
        VulkanQueueManager queueManager = new VulkanQueueManager(device);
        ImmediateContext context = new ImmediateContext(device, queueManager);
        if (context.init()) {
            return context;
        }
        context.unref();
        return null;
    }

    public static void _CHECK_(@NativeType(value="VkResult") int vkResult) {
        if (vkResult != 0) {
            throw new AssertionError((Object)VKUtil.getResultMessage(vkResult));
        }
    }

    public static void _CHECK_ERROR_(@NativeType(value="VkResult") int vkResult) {
        if (vkResult < 0) {
            throw new AssertionError((Object)VKUtil.getResultMessage(vkResult));
        }
    }

    public static String getResultMessage(int result) {
        return switch (result) {
            case 0 -> "Command successfully completed.";
            case 1 -> "A fence or query has not yet completed.";
            case 2 -> "A wait operation has not completed in the specified time.";
            case 3 -> "An event is signaled.";
            case 4 -> "An event is unsignaled.";
            case 5 -> "A return array was too small for the result.";
            case 1000001003 -> "A swap-chain no longer matches the surface properties exactly, but can still be used to present to the surface successfully.";
            case -1 -> "A host memory allocation has failed.";
            case -2 -> "A device memory allocation has failed.";
            case -3 -> "Initialization of an object could not be completed for implementation-specific reasons.";
            case -4 -> "The logical or physical device has been lost.";
            case -5 -> "Mapping of a memory object has failed.";
            case -6 -> "A requested layer is not present or could not be loaded.";
            case -7 -> "A requested extension is not supported.";
            case -8 -> "A requested feature is not supported.";
            case -9 -> "The requested version of Vulkan is not supported by the driver or is otherwise incompatible for implementation-specific reasons.";
            case -10 -> "Too many objects of the type have already been created.";
            case -11 -> "A requested format is not supported on this device.";
            case -1000000000 -> "A surface is no longer available.";
            case -1000000001 -> "The requested window is already connected to a VkSurfaceKHR, or to some other non-Vulkan API.";
            case -1000001004 -> "A surface has changed in such a way that it is no longer compatible with the swap-chain, and further presentation requests using the swap-chain will fail. Applications must query the new surface properties and recreate their swap-chain if they wishto continue presenting to the surface.";
            case -1000003001 -> "The display used by a swap-chain does not use the same presentable image layout, or is incompatible in a way that prevents sharing an image.";
            case -1000011001 -> "A validation layer found an error.";
            default -> String.format("%s [%d]", "Unknown", result);
        };
    }

    public static String getVendorIDName(int vkVendorID) {
        return switch (vkVendorID) {
            case 4098 -> "AMD";
            case 4112 -> "ImgTec";
            case 4203 -> "Apple";
            case 4318 -> "NVIDIA";
            case 5045 -> "ARM";
            case 5348 -> "Broadcom";
            case 6880 -> "Google";
            case 7893 -> "Moore Threads";
            case 20803 -> "Qualcomm";
            case 32902 -> "Intel";
            case 65541 -> "Mesa";
            default -> APIUtil.apiUnknownToken((int)vkVendorID);
        };
    }

    public static String getPhysicalDeviceTypeName(@NativeType(value="VkPhysicalDeviceType") int vkPhysicalDeviceType) {
        return switch (vkPhysicalDeviceType) {
            case 1 -> "Integrated GPU";
            case 2 -> "Discrete GPU";
            case 3 -> "Virtual GPU";
            case 4 -> "CPU";
            default -> "Other";
        };
    }

    public static int vkFormatToIndex(@NativeType(value="VkFormat") int vkFormat) {
        return switch (vkFormat) {
            case 37 -> 1;
            case 9 -> 2;
            case 4 -> 3;
            default -> 0;
        };
    }

    public static boolean vkFormatIsSupported(@NativeType(value="VkFormat") int vkFormat) {
        return switch (vkFormat) {
            case 4, 9, 37 -> true;
            default -> false;
        };
    }

    public static int vkFormatChannels(@NativeType(value="VkFormat") int vkFormat) {
        return switch (vkFormat) {
            case 2, 3, 37, 43, 44, 58, 64, 91, 97, 133 -> 15;
            case 9, 70, 76 -> 1;
            case 4, 23, 131, 147 -> 7;
            case 16, 77, 83 -> 3;
            default -> 0;
        };
    }

    public static int vkFormatCompressionType(@NativeType(value="VkFormat") int vkFormat) {
        return switch (vkFormat) {
            case 147 -> 1;
            case 131 -> 2;
            case 133 -> 3;
            default -> 0;
        };
    }

    public static int vkFormatBytesPerBlock(@NativeType(value="VkFormat") int vkFormat) {
        return switch (vkFormat) {
            case 37, 43, 44, 58, 64, 77, 83, 129 -> 4;
            case 9, 127 -> 1;
            case 2, 3, 4, 16, 70, 76 -> 2;
            case 91, 97, 130, 131, 133, 147 -> 8;
            case 23, 1000156002, 1000156003 -> 3;
            default -> 0;
        };
    }

    public static int vkFormatDepthBits(@NativeType(value="VkFormat") int vkFormat) {
        return switch (vkFormat) {
            case 124, 128 -> 16;
            case 125, 129 -> 24;
            case 126, 130 -> 32;
            default -> 0;
        };
    }

    public static int vkFormatStencilBits(@NativeType(value="VkFormat") int vkFormat) {
        return switch (vkFormat) {
            case 127, 128, 129, 130 -> 8;
            default -> 0;
        };
    }

    public static String vkFormatName(@NativeType(value="VkFormat") int vkFormat) {
        return switch (vkFormat) {
            case 37 -> "R8G8B8A8_UNORM";
            case 9 -> "R8_UNORM";
            case 44 -> "B8G8R8A8_UNORM";
            case 4 -> "R5G6B5_UNORM_PACK16";
            case 97 -> "R16G16B16A16_SFLOAT";
            case 76 -> "R16_SFLOAT";
            case 23 -> "R8G8B8_UNORM";
            case 16 -> "R8G8_UNORM";
            case 64 -> "A2B10G10R10_UNORM_PACK32";
            case 58 -> "A2R10G10B10_UNORM_PACK32";
            case 3 -> "B4G4R4A4_UNORM_PACK16";
            case 2 -> "R4G4B4A4_UNORM_PACK16";
            case 109 -> "R32G32B32A32_SFLOAT";
            case 43 -> "R8G8B8A8_SRGB";
            case 147 -> "ETC2_R8G8B8_UNORM_BLOCK";
            case 131 -> "BC1_RGB_UNORM_BLOCK";
            case 133 -> "BC1_RGBA_UNORM_BLOCK";
            case 70 -> "R16_UNORM";
            case 77 -> "R16G16_UNORM";
            case 91 -> "R16G16B16A16_UNORM";
            case 83 -> "R16G16_SFLOAT";
            case 127 -> "S8_UINT";
            case 129 -> "D24_UNORM_S8_UINT";
            case 130 -> "D32_SFLOAT_S8_UINT";
            default -> "Unknown";
        };
    }

    public static int toVkSampleCount(int sampleCount) {
        assert (sampleCount >= 1);
        return switch (sampleCount) {
            case 1 -> 1;
            case 2 -> 2;
            case 4 -> 4;
            case 8 -> 8;
            case 16 -> 16;
            case 32 -> 32;
            case 64 -> 64;
            default -> 0;
        };
    }
}

