/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Context;
import icyllis.arc3d.engine.ImageMutableState;
import icyllis.arc3d.opengl.GLCaps;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLImage;
import icyllis.arc3d.opengl.GLImageDesc;
import icyllis.arc3d.opengl.GLInterface;
import icyllis.arc3d.opengl.GLTextureMutableState;
import icyllis.arc3d.opengl.GLUtil;
import javax.annotation.Nullable;

public final class GLTexture
extends GLImage {
    private volatile int mHandle;
    private final boolean mOwnership;

    GLTexture(Context context, GLImageDesc desc, GLTextureMutableState mutableState, int handle, boolean budgeted) {
        super(context, budgeted, false, desc, (ImageMutableState)mutableState);
        assert (GLUtil.glFormatIsSupported(desc.mFormat));
        this.mOwnership = true;
        this.mHandle = handle;
        if (GLUtil.glFormatIsCompressed(desc.mFormat)) {
            this.mFlags |= 0x100;
        }
        this.getGLMutableState().mMaxMipmapLevel = this.getMipLevelCount() - 1;
        if (this.mHandle == 0) {
            this.getDevice().recordRenderCall(dev -> {
                if (this.isDestroyed()) {
                    return;
                }
                this.mHandle = GLTexture.internalCreateTexture(dev, this.getGLDesc());
                if (this.mHandle == 0) {
                    this.setNonCacheable();
                }
            });
        }
    }

    @Nullable
    @SharedPtr
    public static GLTexture make(Context context, GLImageDesc desc, boolean budgeted) {
        int handle;
        GLDevice device = (GLDevice)context.getDevice();
        if (device.isOnExecutingThread()) {
            handle = GLTexture.internalCreateTexture(device, desc);
            if (handle == 0) {
                return null;
            }
        } else {
            handle = 0;
        }
        return new GLTexture(context, desc, new GLTextureMutableState(), handle, budgeted);
    }

    static int internalCreateTexture(GLDevice device, GLImageDesc desc) {
        int height;
        assert (desc.mTarget != 36161);
        int width = desc.getWidth();
        int handle = GLTexture.internalCreateTexture2D(device, width, height = desc.getHeight(), desc.mFormat, desc.getMipLevelCount());
        if (handle != 0) {
            device.getStats().incImageCreates();
            if (desc.isSampledImage()) {
                device.getStats().incTextureCreates();
            }
        }
        return handle;
    }

    static int internalCreateTexture2D(GLDevice device, int width, int height, int format, int levels) {
        int texture;
        assert (GLUtil.glFormatIsSupported(format));
        assert (!GLUtil.glFormatIsCompressed(format));
        GLCaps caps = device.getCaps();
        int internalFormat = caps.getTextureInternalFormat(format);
        if (internalFormat == 0) {
            return 0;
        }
        GLInterface gl = device.getGL();
        assert (caps.isFormatTexturable(format));
        if (caps.hasDSASupport() && caps.getVendor() == GLUtil.GLVendor.NVIDIA) {
            assert (caps.isTextureStorageCompatible(format));
            texture = gl.glCreateTextures(3553);
            if (texture == 0) {
                return 0;
            }
            gl.glTextureParameteri(texture, 33085, levels - 1);
            if (caps.skipErrorChecks()) {
                gl.glTextureStorage2D(texture, levels, internalFormat, width, height);
            } else {
                device.clearErrors();
                gl.glTextureStorage2D(texture, levels, internalFormat, width, height);
                if (device.getError() != 0) {
                    gl.glDeleteTextures(texture);
                    return 0;
                }
            }
        } else {
            texture = device.getGL().glGenTextures();
            if (texture == 0) {
                return 0;
            }
            int boundTexture = gl.glGetInteger(32873);
            gl.glBindTexture(3553, texture);
            gl.glTexParameteri(3553, 33085, levels - 1);
            if (caps.isTextureStorageCompatible(format)) {
                if (caps.skipErrorChecks()) {
                    gl.glTexStorage2D(3553, levels, internalFormat, width, height);
                } else {
                    device.clearErrors();
                    gl.glTexStorage2D(3553, levels, internalFormat, width, height);
                    if (device.getError() != 0) {
                        gl.glDeleteTextures(texture);
                        texture = 0;
                    }
                }
            } else {
                boolean checkError;
                int error = 0;
                boolean bl = checkError = !caps.skipErrorChecks();
                if (checkError) {
                    device.clearErrors();
                }
                int externalFormat = caps.getFormatDefaultExternalFormat(format);
                int externalType = caps.getFormatDefaultExternalType(format);
                for (int level = 0; level < levels; ++level) {
                    int currentWidth = Math.max(1, width >> level);
                    int currentHeight = Math.max(1, height >> level);
                    gl.glTexImage2D(3553, level, internalFormat, currentWidth, currentHeight, 0, externalFormat, externalType, 0L);
                    if (!checkError) continue;
                    error |= device.getError();
                }
                if (error != 0) {
                    gl.glDeleteTextures(texture);
                    texture = 0;
                }
            }
            gl.glBindTexture(3553, boundTexture);
        }
        return texture;
    }

    public GLTextureMutableState getGLMutableState() {
        return (GLTextureMutableState)this.getMutableState();
    }

    @Override
    public int getHandle() {
        return this.mHandle;
    }

    @Override
    protected void onSetLabel(@Nullable String label) {
        this.getDevice().executeRenderCall(dev -> {
            if (dev.getCaps().hasDebugSupport()) {
                assert (this.mHandle != 0);
                if (label == null) {
                    dev.getGL().glObjectLabel(5890, this.mHandle, 0, 0L);
                } else {
                    Object subLabel = "Arc3D_TEX_" + label;
                    subLabel = ((String)subLabel).substring(0, Math.min(((String)subLabel).length(), dev.getCaps().maxLabelLength()));
                    dev.getGL().glObjectLabel(5890, this.mHandle, (CharSequence)subLabel);
                }
            }
        });
    }

    @Override
    protected void onRelease() {
        if (this.mOwnership) {
            this.getDevice().executeRenderCall(dev -> {
                if (this.mHandle != 0) {
                    dev.getGL().glDeleteTextures(this.mHandle);
                }
                this.mHandle = 0;
            });
        }
        super.onRelease();
    }

    public String toString() {
        return "GLTexture{mDesc=" + this.getDesc() + ", mHandle=" + this.mHandle + ", mDestroyed=" + this.isDestroyed() + ", mOwnership=" + this.mOwnership + ", mLabel=" + this.getLabel() + ", mMemorySize=" + this.getMemorySize() + "}";
    }
}

