/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine.trash.ops;

import icyllis.arc3d.core.Matrix;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Buffer;
import icyllis.arc3d.engine.ImageProxyView;
import icyllis.arc3d.engine.MeshDrawTarget;
import icyllis.arc3d.engine.OpFlushState;
import icyllis.arc3d.engine.OpsRenderPass;
import icyllis.arc3d.engine.trash.GraphicsPipelineDesc_Old;
import icyllis.arc3d.engine.trash.ops.MeshDrawOp;
import icyllis.arc3d.engine.trash.ops.Op;
import icyllis.arc3d.granite.geom.AnalyticSimpleBoxStep;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.lwjgl.system.MemoryUtil;

@Deprecated
public class RoundRectOp
extends MeshDrawOp {
    private Buffer mVertexBuffer;
    private int mBaseVertex;
    private Buffer mInstanceBuffer;
    private int mBaseInstance;
    private float[] mColor;
    private Rect2f mLocalRect;
    private float mCornerRadius;
    private float mStrokeRadius;
    private Matrix mViewMatrix;
    private boolean mStroke;
    private int mNumInstances = 1;

    public RoundRectOp(float[] color, Rect2f localRect, float cornerRadius, float strokeRadius, Matrix viewMatrix, boolean stroke) {
        this.mColor = color;
        this.mLocalRect = localRect;
        this.mCornerRadius = cornerRadius;
        this.mStrokeRadius = strokeRadius;
        this.mViewMatrix = viewMatrix;
        this.mStroke = stroke;
        viewMatrix.mapRect((Rect2fc)localRect, this);
    }

    @Override
    protected boolean onMayChain(@Nonnull Op __) {
        RoundRectOp op = (RoundRectOp)__;
        if (op.mStroke == this.mStroke) {
            ++this.mNumInstances;
            return true;
        }
        return false;
    }

    @Override
    public void onExecute(OpFlushState state, Rect2f chainBounds) {
        OpsRenderPass opsRenderPass = state.getOpsRenderPass();
        opsRenderPass.bindPipeline(this.getPipelineInfo(), this.getPipelineState(), chainBounds);
        opsRenderPass.bindTextures(null);
        opsRenderPass.bindBuffers(null, 0, this.mVertexBuffer, 0, this.mInstanceBuffer, 0);
        opsRenderPass.drawInstanced(this.getInstanceCount(), this.mBaseInstance, this.getVertexCount(), this.mBaseVertex);
    }

    @Override
    @Nonnull
    protected GraphicsPipelineDesc_Old onCreatePipelineInfo(ImageProxyView writeView, int pipelineFlags) {
        return new GraphicsPipelineDesc_Old(writeView, new AnalyticSimpleBoxStep(true), null, null, null, null, pipelineFlags);
    }

    @Override
    public int getVertexCount() {
        return 4;
    }

    @Override
    public int getInstanceCount() {
        return this.mNumInstances;
    }

    @Override
    public void setVertexBuffer(@SharedPtr Buffer buffer, int baseVertex, int actualVertexCount) {
        assert (this.mVertexBuffer == null);
        this.mVertexBuffer = buffer;
        this.mBaseVertex = baseVertex;
    }

    @Override
    public void setInstanceBuffer(@SharedPtr Buffer buffer, int baseInstance, int actualInstanceCount) {
        assert (this.mInstanceBuffer == null);
        this.mInstanceBuffer = buffer;
        this.mBaseInstance = baseInstance;
    }

    @Override
    protected void onPrepareDraws(MeshDrawTarget target) {
        ByteBuffer vertexData = target.makeVertexWriter(this);
        if (vertexData == null) {
            return;
        }
        vertexData.putFloat(-1.0f).putFloat(1.0f);
        vertexData.putFloat(1.0f).putFloat(1.0f);
        vertexData.putFloat(-1.0f).putFloat(-1.0f);
        vertexData.putFloat(1.0f).putFloat(-1.0f);
        ByteBuffer instanceData = target.makeInstanceWriter(this);
        if (instanceData == null) {
            return;
        }
        for (Op it = this; it != null; it = it.nextInChain()) {
            RoundRectOp op = it;
            instanceData.putFloat(op.mColor[0]);
            instanceData.putFloat(op.mColor[1]);
            instanceData.putFloat(op.mColor[2]);
            instanceData.putFloat(op.mColor[3]);
            instanceData.putFloat(op.mLocalRect.width() / 2.0f);
            instanceData.putFloat(op.mLocalRect.centerX());
            instanceData.putFloat(op.mLocalRect.height() / 2.0f);
            instanceData.putFloat(op.mLocalRect.centerY());
            instanceData.putFloat(op.mCornerRadius).putFloat(op.mStrokeRadius);
            op.mViewMatrix.store(MemoryUtil.memAddress((ByteBuffer)instanceData));
            instanceData.position(instanceData.position() + 36);
        }
    }
}

