/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import java.util.Collection;
import java.util.List;

public final class TopologicalSort {
    public static <T> void topologicalSort(List<T> graph, Access<T> access) {
        assert (TopologicalSort.checkAllUnmarked(graph, access));
        int index = 0;
        for (T node : graph) {
            index = TopologicalSort.dfsVisit(node, access, index);
        }
        assert (index == graph.size());
        int e = graph.size();
        for (int i = 0; i < e; ++i) {
            int j = access.getIndex(graph.get(i));
            while (j != i) {
                T temp = graph.set(j, graph.get(i));
                graph.set(i, temp);
                j = access.getIndex(temp);
            }
        }
        assert (TopologicalSort.cleanExit(graph, access));
    }

    private static <T> int dfsVisit(T node, Access<T> access, int index) {
        if (access.getIndex(node) != -1) {
            return index;
        }
        if (access.isTempMarked(node)) {
            throw new IllegalStateException("cyclic dependency: " + node);
        }
        Collection<T> edges = access.getIncomingEdges(node);
        if (edges != null && !edges.isEmpty()) {
            access.setTempMarked(node, true);
            for (T edge : edges) {
                index = TopologicalSort.dfsVisit(edge, access, index);
            }
            access.setTempMarked(node, false);
        }
        access.setIndex(node, index);
        return index + 1;
    }

    private static <T> boolean checkAllUnmarked(List<T> graph, Access<T> access) {
        for (T node : graph) {
            assert (access.getIndex(node) == -1);
            assert (!access.isTempMarked(node));
        }
        return true;
    }

    private static <T> boolean cleanExit(List<T> graph, Access<T> access) {
        int e = graph.size();
        for (int i = 0; i < e; ++i) {
            T node = graph.get(i);
            assert (access.getIndex(node) == i);
            assert (!access.isTempMarked(node));
        }
        return true;
    }

    public static interface Access<T> {
        public void setIndex(T var1, int var2);

        public int getIndex(T var1);

        public void setTempMarked(T var1, boolean var2);

        public boolean isTempMarked(T var1);

        public Collection<T> getIncomingEdges(T var1);
    }
}

