/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.UniqueID;
import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.GpuRenderTarget;
import icyllis.arc3d.engine.GpuSurface;
import icyllis.arc3d.engine.IResourceKey;
import icyllis.arc3d.engine.ISurface;
import icyllis.arc3d.engine.IUniqueKey;
import icyllis.arc3d.engine.Image;
import icyllis.arc3d.engine.ImageViewProxy;
import icyllis.arc3d.engine.RenderTargetProxy;
import icyllis.arc3d.engine.ResourceProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

public abstract class SurfaceProxy
extends RefCnt {
    final BackendFormat mFormat;
    int mWidth;
    int mHeight;
    @SharedPtr
    GpuSurface mGpuSurface;
    int mSurfaceFlags;
    LazyInstantiateCallback mLazyInstantiateCallback;
    final UniqueID mUniqueID;
    int mTaskTargetCount = 0;
    boolean mIsDeferredListTarget = false;

    SurfaceProxy(BackendFormat format, int width, int height, int surfaceFlags) {
        assert (format != null);
        this.mFormat = format;
        this.mWidth = width;
        this.mHeight = height;
        this.mSurfaceFlags = surfaceFlags;
        if (format.isExternal()) {
            this.mSurfaceFlags |= 0x100;
        }
        this.mUniqueID = new UniqueID();
    }

    SurfaceProxy(@SharedPtr GpuSurface surface, int surfaceFlags) {
        assert (surface != null);
        this.mFormat = surface.getBackendFormat();
        this.mWidth = surface.getWidth();
        this.mHeight = surface.getHeight();
        this.mSurfaceFlags = surface.getSurfaceFlags() | surfaceFlags;
        assert ((this.mSurfaceFlags & 2) == 0);
        this.mUniqueID = surface.getUniqueID();
    }

    public abstract boolean isLazy();

    public final boolean isLazyMost() {
        boolean result;
        boolean bl = result = this.mWidth < 0;
        assert (result == this.mHeight < 0);
        assert (!result || this.isLazy());
        return result;
    }

    public final int getWidth() {
        assert (!this.isLazyMost());
        return this.mWidth;
    }

    public final int getHeight() {
        assert (!this.isLazyMost());
        return this.mHeight;
    }

    public abstract int getBackingWidth();

    public abstract int getBackingHeight();

    public final boolean isExact() {
        assert (!this.isLazyMost());
        if ((this.mSurfaceFlags & 2) == 0) {
            return true;
        }
        return this.mWidth == ISurface.getApproxSize(this.mWidth) && this.mHeight == ISurface.getApproxSize(this.mHeight);
    }

    public abstract int getSampleCount();

    @Nonnull
    public final BackendFormat getBackendFormat() {
        return this.mFormat;
    }

    public final UniqueID getUniqueID() {
        return this.mUniqueID;
    }

    public abstract UniqueID getBackingUniqueID();

    public abstract boolean isInstantiated();

    public abstract boolean instantiate(ResourceProvider var1);

    public abstract void clear();

    public abstract boolean shouldSkipAllocator();

    public abstract boolean isBackingWrapped();

    public final void isUsedAsTaskTarget() {
        ++this.mTaskTargetCount;
    }

    public final int getTaskTargetCount() {
        return this.mTaskTargetCount;
    }

    @Nullable
    @RawPtr
    public abstract GpuSurface getGpuSurface();

    @Nullable
    @RawPtr
    public Image getGpuImage() {
        return null;
    }

    @Nullable
    @RawPtr
    public GpuRenderTarget getGpuRenderTarget() {
        return null;
    }

    public final boolean isBudgeted() {
        return (this.mSurfaceFlags & 1) != 0;
    }

    public final boolean isReadOnly() {
        return (this.mSurfaceFlags & 0x100) != 0;
    }

    public final boolean isProtected() {
        return (this.mSurfaceFlags & 0x80) != 0;
    }

    public final boolean isManualMSAAResolve() {
        return (this.mSurfaceFlags & 0x1000) != 0;
    }

    public final boolean wrapsGLDefaultFB() {
        return (this.mSurfaceFlags & 0x800) != 0;
    }

    public final boolean wrapsVkSecondaryCB() {
        return (this.mSurfaceFlags & 0x2000) != 0;
    }

    public final boolean isDeferredListTarget() {
        return this.mIsDeferredListTarget;
    }

    @ApiStatus.Internal
    public void setIsDeferredListTarget() {
        this.mIsDeferredListTarget = true;
    }

    @ApiStatus.Internal
    public final boolean isUserExact() {
        return (this.mSurfaceFlags & 2) == 0;
    }

    public ImageViewProxy asImageProxy() {
        return null;
    }

    public RenderTargetProxy asRenderTargetProxy() {
        return null;
    }

    public IUniqueKey getUniqueKey() {
        return null;
    }

    public long getMemorySize() {
        return 0L;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    @ApiStatus.Internal
    public abstract boolean doLazyInstantiation(ResourceProvider var1);

    @Nonnull
    abstract IResourceKey computeScratchKey();

    @Nullable
    @SharedPtr
    abstract GpuSurface createSurface(ResourceProvider var1);

    @FunctionalInterface
    public static interface LazyInstantiateCallback
    extends AutoCloseable {
        public LazyCallbackResult onLazyInstantiate(ResourceProvider var1, BackendFormat var2, int var3, int var4, int var5, int var6, String var7);

        @Override
        default public void close() {
        }
    }

    public static class LazyCallbackResult {
        @SharedPtr
        public GpuSurface mSurface;
        public boolean mSyncTargetKey = true;
        public boolean mReleaseCallback = true;

        public LazyCallbackResult() {
        }

        public LazyCallbackResult(@SharedPtr GpuSurface surface) {
            this.mSurface = surface;
        }

        public LazyCallbackResult(@SharedPtr GpuSurface surface, boolean syncTargetKey, boolean releaseCallback) {
            this.mSurface = surface;
            this.mSyncTargetKey = syncTargetKey;
            this.mReleaseCallback = releaseCallback;
        }
    }
}

