/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.SLDataType;

public class ShaderVar {
    public static final byte kNone_TypeModifier = 0;
    public static final byte kOut_TypeModifier = 1;
    public static final byte kIn_TypeModifier = 2;
    public static final byte kInOut_TypeModifier = 3;
    public static final byte kUniform_TypeModifier = 4;
    public static final int kNonArray = 0;
    private byte mType;
    private byte mTypeModifier;
    private final int mArraySize;
    private String mName;
    private String mLayoutQualifier;
    private String mExtraModifiers;

    public ShaderVar() {
        this("", 0, 0, 0, "", "");
    }

    public ShaderVar(String name, byte type) {
        this(name, type, 0, 0, "", "");
    }

    public ShaderVar(String name, byte type, int arraySize) {
        this(name, type, 0, arraySize, "", "");
    }

    public ShaderVar(String name, byte type, byte typeModifier) {
        this(name, type, typeModifier, 0, "", "");
    }

    public ShaderVar(String name, byte type, byte typeModifier, int arraySize) {
        this(name, type, typeModifier, arraySize, "", "");
    }

    public ShaderVar(String name, byte type, byte typeModifier, int arraySize, String layoutQualifier, String extraModifier) {
        assert (name != null);
        assert (SLDataType.checkSLType(type));
        assert (typeModifier >= 0 && typeModifier <= 4);
        assert (arraySize == 0 || arraySize > 0);
        assert (layoutQualifier != null && extraModifier != null);
        this.mType = type;
        this.mTypeModifier = typeModifier;
        this.mArraySize = arraySize;
        this.mName = name;
        this.mLayoutQualifier = layoutQualifier;
        this.mExtraModifiers = extraModifier;
    }

    public void set(String name, byte type) {
        assert (type != 0);
        this.mType = type;
        this.mName = name;
    }

    public boolean isArray() {
        return this.mArraySize != 0;
    }

    public int getArraySize() {
        return this.mArraySize;
    }

    public String getName() {
        return this.mName;
    }

    public byte getType() {
        return this.mType;
    }

    public byte getTypeModifier() {
        return this.mTypeModifier;
    }

    public void setTypeModifier(byte typeModifier) {
        assert (typeModifier >= 0 && typeModifier <= 4);
        this.mTypeModifier = typeModifier;
    }

    public void addLayoutQualifier(String layoutQualifier) {
        assert (layoutQualifier != null && !layoutQualifier.isEmpty());
        this.mLayoutQualifier = this.mLayoutQualifier.isEmpty() ? layoutQualifier : this.mLayoutQualifier + "," + layoutQualifier;
    }

    public void addLayoutQualifier(String qualifier, int value) {
        this.addLayoutQualifier(qualifier + "=" + value);
    }

    public void addModifier(String modifier) {
        assert (modifier != null && !modifier.isEmpty());
        this.mExtraModifiers = this.mExtraModifiers.isEmpty() ? modifier : this.mExtraModifiers + " " + modifier;
    }

    public void appendDecl(StringBuilder out) {
        if (!this.mLayoutQualifier.isEmpty()) {
            out.append("layout(");
            out.append(this.mLayoutQualifier);
            out.append(") ");
        }
        if (!this.mExtraModifiers.isEmpty()) {
            out.append(this.mExtraModifiers);
            out.append(" ");
        }
        if (this.mTypeModifier != 0) {
            out.append(switch (this.mTypeModifier) {
                case 1 -> "out ";
                case 2 -> "in ";
                case 3 -> "inout ";
                case 4 -> "uniform ";
                default -> throw new IllegalStateException();
            });
        }
        byte type = this.getType();
        if (this.isArray()) {
            assert (this.getArraySize() > 0);
            out.append(SLDataType.typeString(type));
            out.append(" ");
            out.append(this.getName());
            out.append("[");
            out.append(this.getArraySize());
            out.append("]");
        } else {
            out.append(SLDataType.typeString(type));
            out.append(" ");
            out.append(this.getName());
        }
    }
}

